/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.blocks.plant.BlockBracketFungus;
import vibrantjourneys.blocks.plant.BlockShortGrass;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.init.PVJWorldGen;
import vibrantjourneys.util.PVJConfig;

public class WorldGenFallenTree
implements IWorldGenerator {
    private IBlockState logBase;
    private int frequency;
    private Biome[] biomes;

    public WorldGenFallenTree(IBlockState log, int frequency, Biome ... biomes) {
        this.logBase = log;
        this.frequency = (int)((double)frequency * ((double)PVJConfig.global.fallenTreeDensity / 100.0));
        this.biomes = biomes;
    }

    public WorldGenFallenTree(Block log, int frequency, Biome ... biomes) {
        this(log.func_176223_P(), frequency, biomes);
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int i;
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        Random random = new Random();
        ChunkPos chunkPos = world.func_72964_e(chunkX, chunkZ).func_76632_l();
        Biome biome = world.getBiomeForCoordsBody(chunkPos.func_180331_a(0, 0, 0));
        boolean isValidBiome = false;
        for (i = 0; i < this.biomes.length; ++i) {
            if (biome != this.biomes[i]) continue;
            isValidBiome = true;
            break;
        }
        if (isValidBiome) {
            for (i = 0; i < this.frequency; ++i) {
                EnumFacing branch;
                BlockPos branchPos;
                int xPos = rand.nextInt(16) + 8;
                int zPos = rand.nextInt(16) + 8;
                int y = world.func_175645_m(chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, 0, zPos)).func_177956_o() + rand.nextInt(4) - rand.nextInt(4);
                BlockPos pos = chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, y, zPos);
                if (!this.canReplace(world, pos) || !world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
                    return;
                }
                if (world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockLog) {
                    return;
                }
                int length = 4 + random.nextInt(3);
                EnumFacing facing = EnumFacing.Plane.HORIZONTAL.func_179518_a(random);
                BlockPos prev = null;
                for (int j = 0; j < length; ++j) {
                    prev = pos;
                    pos = pos.func_177972_a(facing);
                    while (this.canReplace(world, pos.func_177977_b())) {
                        pos = pos.func_177977_b();
                    }
                    if (!this.canReplace(world, pos)) continue;
                    world.func_175656_a(pos, this.logBase.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k())));
                    if (!random.nextBoolean()) continue;
                    EnumFacing temp = random.nextBoolean() ? facing.func_176734_d() : facing;
                    BlockPos tempPos = pos.func_177972_a(temp = this.getHorizontalPerpendicular(temp.func_176736_b()));
                    if (!this.canReplace(world, tempPos)) continue;
                    world.func_175656_a(tempPos, PVJBlocks.bracket_fungus.func_176223_P().func_177226_a((IProperty)BlockBracketFungus.field_185512_D, (Comparable)temp));
                }
                if (!random.nextBoolean() || !this.canReplace(world, branchPos = prev.func_177972_a(branch = this.getHorizontalPerpendicular(facing.func_176736_b())))) continue;
                world.func_175656_a(branchPos, this.logBase.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)branch.func_176740_k())));
            }
        }
    }

    public boolean canReplace(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return world.func_175623_d(pos) || state.func_177230_c().func_176200_f((IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) || state.func_177230_c() instanceof BlockTallGrass || state.func_177230_c() instanceof BlockShortGrass || state.func_177230_c() instanceof BlockLilyPad || state.func_177230_c() instanceof BlockMushroom || state.func_177230_c() instanceof BlockFlower || state.func_177230_c() instanceof BlockBracketFungus;
    }

    private EnumFacing getHorizontalPerpendicular(int facingIndex) {
        if (facingIndex == 0) {
            return EnumFacing.WEST;
        }
        if (facingIndex == 2) {
            return EnumFacing.EAST;
        }
        if (facingIndex == 1) {
            return EnumFacing.SOUTH;
        }
        return EnumFacing.NORTH;
    }
}

