/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.BlockStone;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.init.PVJWorldGen;

public class WorldGenDesertCaves
implements IWorldGenerator {
    private Biome[] biomes;

    public WorldGenDesertCaves(Biome ... biomes) {
        this.biomes = biomes;
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        Random random = new Random();
        if (world.field_73011_w.func_186058_p() != DimensionType.OVERWORLD && world.field_73011_w.func_186058_p() != DimensionType.NETHER) {
            return;
        }
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        boolean isValidBiome = false;
        for (int i = 0; i < this.biomes.length; ++i) {
            if (biome != this.biomes[i]) continue;
            isValidBiome = true;
            break;
        }
        if (isValidBiome) {
            int y = 30;
            for (BlockPos position : BlockPos.func_191531_b((int)(x - 7), (int)(y - 28), (int)(z - 7), (int)(x + 7), (int)(y + 40), (int)(z + 7))) {
                if (world.func_175678_i(position) || !(world.func_180495_p(position).func_177230_c() instanceof BlockStone)) continue;
                boolean isSandstone = false;
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    if (!world.func_175623_d(position.func_177972_a(facing)) || random.nextInt(5) >= 3) continue;
                    isSandstone = true;
                    break;
                }
                if (!isSandstone) continue;
                world.func_175656_a(position, Blocks.field_150322_A.func_176223_P());
            }
        }
    }
}

