/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.init.PVJWorldGen;

public class WorldGenCrackedSand
implements IWorldGenerator {
    private Block block;
    private Block replacedBlock;
    private int minY;
    private int maxY;
    private int frequency;
    private Biome[] biomes;

    public WorldGenCrackedSand(Block block, Block replacedBlock, int minY, int maxY, int frequency, Biome ... biomes) {
        this.block = block;
        this.replacedBlock = replacedBlock;
        this.minY = minY;
        this.maxY = maxY;
        this.frequency = frequency;
        this.biomes = biomes;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int i;
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        boolean isValidBiome = false;
        for (i = 0; i < this.biomes.length; ++i) {
            if (biome != this.biomes[i]) continue;
            isValidBiome = true;
            break;
        }
        if (isValidBiome) {
            for (i = 0; i < this.frequency; ++i) {
                int xPos = x + random.nextInt(6) - random.nextInt(6);
                int zPos = z + random.nextInt(6) - random.nextInt(6);
                int yPos = this.minY + random.nextInt(this.maxY - this.minY + 1);
                BlockPos pos = new BlockPos(xPos, yPos, zPos);
                if (world.func_180495_p(pos).func_177230_c() != this.replacedBlock) continue;
                world.func_175656_a(pos, this.block.func_176223_P());
            }
        }
    }
}

