/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.init.PVJWorldGen;

public class WorldGenCobweb
implements IWorldGenerator {
    private int frequency;

    public WorldGenCobweb(int frequency) {
        this.frequency = frequency;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator generator, IChunkProvider provider) {
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        ChunkPos chunkPos = world.func_72964_e(chunkX, chunkZ).func_76632_l();
        Biome biome = world.getBiomeForCoordsBody(chunkPos.func_180331_a(0, 0, 0));
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            for (int i = 0; i < this.frequency; ++i) {
                int xPos = random.nextInt(16) + 8;
                int zPos = random.nextInt(16) + 8;
                int y = world.func_175645_m(chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, 0, zPos)).func_177956_o() + random.nextInt(16) - random.nextInt(16);
                BlockPos pos = chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, y, zPos);
                IBlockState state = world.func_180495_p(pos.func_177984_a());
                if (!(state.func_177230_c() instanceof BlockLeaves) || !world.func_175623_d(pos)) continue;
                world.func_175656_a(pos, PVJBlocks.pvj_cobweb.func_176223_P());
            }
        }
    }
}

