/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.blocks.plant.BlockCattail;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.init.PVJWorldGen;
import vibrantjourneys.util.PVJConfig;

public class WorldGenCattail
implements IWorldGenerator {
    private int frequency;
    private Biome[] biomes;

    public WorldGenCattail(int frequency, Biome ... biomes) {
        this.frequency = (int)((double)frequency * ((double)PVJConfig.global.overworldPlantsDensity / 100.0));
        this.biomes = biomes;
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        if (Arrays.asList(this.biomes).contains(biome)) {
            for (int i = 0; i < this.frequency; ++i) {
                int xPos = rand.nextInt(16) + 8;
                int zPos = rand.nextInt(16) + 8;
                ChunkPos chunkPos = world.func_72964_e(chunkX, chunkZ).func_76632_l();
                int y = world.func_175645_m(chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, 0, zPos)).func_177956_o() + rand.nextInt(4) - rand.nextInt(4);
                BlockPos pos = chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, y, zPos);
                if (this.canGenCattail(world, pos)) {
                    ((BlockCattail)PVJBlocks.cattail).placeAt(world, pos.func_177984_a(), 2);
                }
                int neighbors = rand.nextInt(5);
                for (int j = 0; j < neighbors; ++j) {
                    int zOffset;
                    int xOffset = rand.nextInt(5);
                    BlockPos temp = pos.func_177982_a(xOffset, 0, zOffset = rand.nextInt(5));
                    if (!this.canGenCattail(world, temp)) continue;
                    ((BlockCattail)PVJBlocks.cattail).placeAt(world, temp.func_177984_a(), 2);
                }
            }
        }
    }

    private boolean canGenCattail(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150349_c) {
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                if (world.func_180495_p(pos.func_177972_a(facing)).func_185904_a() != Material.field_151586_h || !world.func_175623_d(pos.func_177984_a()) || !world.func_175623_d(pos.func_177981_b(2))) continue;
                return true;
            }
        }
        return false;
    }
}

