/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.blocks.plant.BlockBracketFungus;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.init.PVJWorldGen;
import vibrantjourneys.util.PVJConfig;

public class WorldGenBracketFungus
implements IWorldGenerator {
    private int frequency;
    private Biome[] biomes;

    public WorldGenBracketFungus(int frequency, Biome ... biomes) {
        this.frequency = (int)((double)frequency * ((double)PVJConfig.global.overworldPlantsDensity / 100.0));
        this.biomes = biomes;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator generator, IChunkProvider provider) {
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        ChunkPos chunkPos = world.func_72964_e(chunkX, chunkZ).func_76632_l();
        Biome biome = world.getBiomeForCoordsBody(chunkPos.func_180331_a(0, 0, 0));
        if (Arrays.asList(this.biomes).contains(biome)) {
            for (int i = 0; i < this.frequency; ++i) {
                Random rand;
                EnumFacing facing;
                int xPos = random.nextInt(16) + 8;
                int zPos = random.nextInt(16) + 8;
                int y = world.func_175645_m(chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, 0, zPos)).func_177956_o() + random.nextInt(16) - random.nextInt(16);
                BlockPos pos = chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, y, zPos);
                IBlockState state = world.func_180495_p(pos);
                if (!(state.func_177230_c() instanceof BlockLog) || !world.func_175623_d(pos.func_177972_a(facing = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand = new Random())))) continue;
                world.func_175656_a(pos.func_177972_a(facing), PVJBlocks.bracket_fungus.func_176223_P().func_177226_a((IProperty)BlockBracketFungus.field_185512_D, (Comparable)facing));
            }
        }
    }
}

