/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vibrantjourneys.init.PVJBiomes;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.util.BiomeReference;
import vibrantjourneys.util.EnumWoodType;
import vibrantjourneys.util.PVJConfig;
import vibrantjourneys.worldgen.feature.WorldGenBaobabTree;
import vibrantjourneys.worldgen.feature.WorldGenCherryBlossomTree;
import vibrantjourneys.worldgen.feature.WorldGenJacarandaTree;
import vibrantjourneys.worldgen.feature.WorldGenPVJDungeon;
import vibrantjourneys.worldgen.feature.WorldGenPineTree;

public class PVJTerrainGenEvents {
    @SubscribeEvent
    public void onDecorate(PopulateChunkEvent.Populate event) {
        if (event.getType().equals((Object)PopulateChunkEvent.Populate.EventType.DUNGEON) && PVJConfig.worldgen.modifyDungeons) {
            int chunkX = event.getChunkX();
            int chunkZ = event.getChunkZ();
            ChunkGeneratorSettings settings = ChunkGeneratorSettings.Factory.func_177865_a((String)event.getWorld().func_72912_H().func_82571_y()).func_177864_b();
            Random rand = event.getWorld().field_73012_v;
            int dungeonSpawnChance = settings.field_177835_t;
            for (int i = 0; i < dungeonSpawnChance; ++i) {
                int x = chunkX * 16 + 6;
                int y = rand.nextInt(256);
                int z = chunkZ * 16 + 6;
                new WorldGenPVJDungeon().func_180709_b(event.getWorld(), rand, new BlockPos(x, y, z));
            }
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void removeLakes(DecorateBiomeEvent.Decorate event) {
        Biome biome = event.getWorld().getBiomeForCoordsBody(event.getChunkPos().func_180331_a(8, 0, 8));
        if (BiomeReference.DESERT_BIOMES.contains(biome) && PVJConfig.worldgen.decreaseDesertLakes && event.getType() == DecorateBiomeEvent.Decorate.EventType.LAKE_WATER && event.getRand().nextInt(6) < 5) {
            event.setResult(Event.Result.DENY);
        }
        if (biome == Biomes.field_76772_c && PVJConfig.worldgen.decreasePlainsPonds && event.getType() == DecorateBiomeEvent.Decorate.EventType.LAKE_WATER && event.getRand().nextInt(6) < 5) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void genTrees(DecorateBiomeEvent.Decorate event) {
        Biome biome = event.getWorld().getBiomeForCoordsBody(event.getChunkPos().func_180331_a(8, 0, 8));
        if (event.getType() == DecorateBiomeEvent.Decorate.EventType.TREE) {
            BlockPos pos;
            if (BiomeReference.BAOBAB_TREES.contains(biome) && event.getRand().nextInt(200) < PVJConfig.worldgen.baobabDensity) {
                pos = event.getWorld().func_175645_m(event.getChunkPos().func_180331_a(13, 0, 13));
                new WorldGenBaobabTree(false, 15, 6).func_180709_b(event.getWorld(), event.getRand(), pos);
            }
            if ((BiomeReference.MOUNTAIN_BIOMES.contains(biome) || BiomeReference.SPRUCE_TREES.contains(biome)) && event.getRand().nextInt(7) == 0 && PVJConfig.worldgen.pineDensity > 0) {
                pos = event.getWorld().func_175672_r(event.getChunkPos().func_180331_a(8, 0, 8));
                new WorldGenPineTree(false).func_180709_b(event.getWorld(), event.getRand(), pos);
            }
            if (biome == Biomes.field_185444_T) {
                if (event.getRand().nextInt(7) == 0 && PVJConfig.worldgen.pinkCherryBlossomDensity > 0) {
                    pos = event.getWorld().func_175672_r(event.getChunkPos().func_180331_a(8, 0, 8));
                    new WorldGenCherryBlossomTree(true, true).func_180709_b(event.getWorld(), event.getRand(), pos);
                }
                if (event.getRand().nextInt(7) == 0 && PVJConfig.worldgen.whiteCherryBlossomDensity > 0) {
                    pos = event.getWorld().func_175672_r(event.getChunkPos().func_180331_a(8, 0, 8));
                    new WorldGenCherryBlossomTree(true, false).func_180709_b(event.getWorld(), event.getRand(), pos);
                }
            }
            if (BiomeReference.JACARANDA_TREES.contains(biome) && event.getRand().nextInt(7) == 0 && PVJConfig.worldgen.jacarandaDensity > 0) {
                int xRand = event.getRand().nextInt(8) - event.getRand().nextInt(8);
                int zRand = event.getRand().nextInt(8) - event.getRand().nextInt(8);
                BlockPos pos2 = event.getWorld().func_175672_r(event.getChunkPos().func_180331_a(8 + xRand, 0, 8 + zRand));
                new WorldGenJacarandaTree(false).func_180709_b(event.getWorld(), event.getRand(), pos2);
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void generateBeachVillage(BiomeEvent.GetVillageBlockID event) {
        EnumFacing facing;
        BlockLog.EnumAxis axis;
        Block block;
        if (event.getBiome() == Biomes.field_76787_r) {
            block = event.getOriginal().func_177230_c();
            if (block == Blocks.field_150344_f) {
                event.setReplacement(PVJBlocks.PLANKS.get(EnumWoodType.PALM.getID()).func_176223_P());
                event.setResult(Event.Result.DENY);
            }
            if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
                axis = (BlockLog.EnumAxis)event.getOriginal().func_177229_b((IProperty)BlockLog.field_176299_a);
                event.setReplacement(PVJBlocks.LOGS.get(EnumWoodType.PALM.getID()).func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)axis));
                event.setResult(Event.Result.DENY);
            }
            if (block == Blocks.field_180407_aO) {
                event.setReplacement(PVJBlocks.FENCES.get(EnumWoodType.PALM.getID()).func_176223_P());
                event.setResult(Event.Result.DENY);
            }
            if (block == Blocks.field_150476_ad) {
                facing = (EnumFacing)event.getOriginal().func_177229_b((IProperty)BlockStairs.field_176309_a);
                event.setReplacement(PVJBlocks.STAIRS.get(EnumWoodType.PALM.getID()).func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)facing));
                event.setResult(Event.Result.DENY);
            }
        }
        if (event.getBiome() == PVJBiomes.prairie) {
            block = event.getOriginal().func_177230_c();
            if (block == Blocks.field_150344_f) {
                event.setReplacement(PVJBlocks.PLANKS.get(EnumWoodType.COTTONWOOD.getID()).func_176223_P());
                event.setResult(Event.Result.DENY);
            }
            if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
                axis = (BlockLog.EnumAxis)event.getOriginal().func_177229_b((IProperty)BlockLog.field_176299_a);
                event.setReplacement(PVJBlocks.LOGS.get(EnumWoodType.COTTONWOOD.getID()).func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)axis));
                event.setResult(Event.Result.DENY);
            }
            if (block == Blocks.field_180407_aO) {
                event.setReplacement(PVJBlocks.FENCES.get(EnumWoodType.COTTONWOOD.getID()).func_176223_P());
                event.setResult(Event.Result.DENY);
            }
            if (block == Blocks.field_150476_ad) {
                facing = (EnumFacing)event.getOriginal().func_177229_b((IProperty)BlockStairs.field_176309_a);
                event.setReplacement(PVJBlocks.STAIRS.get(EnumWoodType.COTTONWOOD.getID()).func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)facing));
                event.setResult(Event.Result.DENY);
            }
        }
        if (event.getBiome() == PVJBiomes.blossoming_fields) {
            block = event.getOriginal().func_177230_c();
            if (block == Blocks.field_150344_f) {
                event.setReplacement(PVJBlocks.PLANKS.get(EnumWoodType.CHERRY_BLOSSOM.getID()).func_176223_P());
                event.setResult(Event.Result.DENY);
            }
            if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
                axis = (BlockLog.EnumAxis)event.getOriginal().func_177229_b((IProperty)BlockLog.field_176299_a);
                event.setReplacement(PVJBlocks.LOGS.get(EnumWoodType.CHERRY_BLOSSOM.getID()).func_176223_P().func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)axis));
                event.setResult(Event.Result.DENY);
            }
            if (block == Blocks.field_180407_aO) {
                event.setReplacement(PVJBlocks.FENCES.get(EnumWoodType.CHERRY_BLOSSOM.getID()).func_176223_P());
                event.setResult(Event.Result.DENY);
            }
            if (block == Blocks.field_150476_ad) {
                facing = (EnumFacing)event.getOriginal().func_177229_b((IProperty)BlockStairs.field_176309_a);
                event.setReplacement(PVJBlocks.STAIRS.get(EnumWoodType.CHERRY_BLOSSOM.getID()).func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)facing));
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

