/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.init;

import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;
import vibrantjourneys.ProjectVibrantJourneys;
import vibrantjourneys.init.PVJBiomes;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.integration.biomesoplenty.PVJWorldGenBOP;
import vibrantjourneys.integration.traverse.PVJWorldGenTraverse;
import vibrantjourneys.util.BiomeReference;
import vibrantjourneys.util.EnumLeafType;
import vibrantjourneys.util.EnumStoneType;
import vibrantjourneys.util.EnumWoodType;
import vibrantjourneys.util.PVJConfig;
import vibrantjourneys.util.Reference;
import vibrantjourneys.worldgen.WorldGenAbandonedFarm;
import vibrantjourneys.worldgen.WorldGenBeachGrass;
import vibrantjourneys.worldgen.WorldGenBoulder;
import vibrantjourneys.worldgen.WorldGenBracketFungus;
import vibrantjourneys.worldgen.WorldGenCattail;
import vibrantjourneys.worldgen.WorldGenCobweb;
import vibrantjourneys.worldgen.WorldGenCrackedSand;
import vibrantjourneys.worldgen.WorldGenDesertCaves;
import vibrantjourneys.worldgen.WorldGenFallenLeaves;
import vibrantjourneys.worldgen.WorldGenFallenTree;
import vibrantjourneys.worldgen.WorldGenFloaters;
import vibrantjourneys.worldgen.WorldGenFlouropore;
import vibrantjourneys.worldgen.WorldGenFlowerPatch;
import vibrantjourneys.worldgen.WorldGenFrozenCaves;
import vibrantjourneys.worldgen.WorldGenGroundCover;
import vibrantjourneys.worldgen.WorldGenJuniperTreeMesa;
import vibrantjourneys.worldgen.WorldGenMangroveRoot;
import vibrantjourneys.worldgen.WorldGenMangroveTreeSwamp;
import vibrantjourneys.worldgen.WorldGenMud;
import vibrantjourneys.worldgen.WorldGenOvergrownCaves;
import vibrantjourneys.worldgen.WorldGenPVJPlant;
import vibrantjourneys.worldgen.WorldGenPalmTreeBeach;
import vibrantjourneys.worldgen.WorldGenPillowBasalt;
import vibrantjourneys.worldgen.WorldGenRiverGrass;
import vibrantjourneys.worldgen.WorldGenRocks;
import vibrantjourneys.worldgen.WorldGenRuins;
import vibrantjourneys.worldgen.WorldGenSeaOats;
import vibrantjourneys.worldgen.WorldGenShortGrass;
import vibrantjourneys.worldgen.WorldGenSmallBush;
import vibrantjourneys.worldgen.WorldGenStalactite;
import vibrantjourneys.worldgen.WorldGenStalagmite;
import vibrantjourneys.worldgen.WorldGenTerracottaCaves;

public class PVJWorldGen {
    public static int[] dimensionBlacklist;

    public static void initWorldGen() {
        dimensionBlacklist = PVJWorldGen.getDimensionBlacklist();
        PVJWorldGen.registerWorldGen(new WorldGenCobweb(PVJConfig.worldgen.cobwebDensity));
        PVJWorldGen.registerWorldGen(new WorldGenPalmTreeBeach(PVJConfig.worldgen.palmDensity));
        PVJWorldGen.registerWorldGen(new WorldGenMangroveTreeSwamp(PVJConfig.worldgen.mangroveDensity));
        PVJWorldGen.registerWorldGen(new WorldGenJuniperTreeMesa(PVJConfig.worldgen.juniperDensity));
        PVJWorldGen.registerWorldGen(new WorldGenBoulder(PVJConfig.worldgen.boulderDensity, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES)));
        if (PVJConfig.master.enableCaves) {
            PVJWorldGen.registerWorldGen(new WorldGenStalagmite(PVJBlocks.rock_formation, 0, 70, PVJConfig.worldgen.stalagmiteDensity, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenStalactite(PVJBlocks.rock_formation, 0, 70, PVJConfig.worldgen.stalactiteDensity, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenStalactite(PVJBlocks.ice_formation, 0, 70, PVJConfig.worldgen.icicleDensity, BiomeReference.getBiomes(BiomeReference.SNOWY_BIOMES)));
            if (PVJConfig.worldgen.enableOvergrownCaves) {
                PVJWorldGen.registerWorldGen(new WorldGenOvergrownCaves(BiomeReference.getBiomes(BiomeReference.MANGROVE_TREES)));
            }
            if (PVJConfig.worldgen.enableFrozenCaves) {
                PVJWorldGen.registerWorldGen(new WorldGenFrozenCaves(BiomeReference.getBiomes(BiomeReference.SNOWY_BIOMES)));
            }
            if (PVJConfig.worldgen.enableSandstoneCaves) {
                PVJWorldGen.registerWorldGen(new WorldGenDesertCaves(BiomeReference.getBiomes(BiomeReference.DESERT_BIOMES)));
            }
            if (PVJConfig.worldgen.enableTerracottaCaves) {
                PVJWorldGen.registerWorldGen(new WorldGenTerracottaCaves(BiomeReference.getBiomes(BiomeReference.MESA_BIOMES)));
            }
        } else {
            ProjectVibrantJourneys.logger.info("Cave stuff disabled");
        }
        if (PVJConfig.master.enableStoneTypeBlocks) {
            PVJWorldGen.registerWorldGen(new WorldGenPillowBasalt(PVJConfig.worldgen.pillowBasaltDensity));
            PVJWorldGen.registerWorldGen(new WorldGenRocks(PVJBlocks.STONES.get(EnumStoneType.BASALT.getID()), 14, 65, PVJConfig.worldgen.basaltDensity, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN).toArray(new Biome[0])));
            PVJWorldGen.registerWorldGen(new WorldGenRocks(PVJBlocks.STONES.get(EnumStoneType.LIMESTONE.getID()), 14, 70, PVJConfig.worldgen.limestoneDensity, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenRocks(PVJBlocks.STONES.get(EnumStoneType.MARBLE.getID()), 9, 70, PVJConfig.worldgen.marbleDensity, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenRocks(PVJBlocks.STONES.get(EnumStoneType.SILTSTONE.getID()), 15, 65, PVJConfig.worldgen.siltstoneDensity, BiomeReference.getBiomes(BiomeReference.FRESHWATER_BIOMES)));
        }
        PVJWorldGen.registerWorldGen(new WorldGenMud(PVJConfig.worldgen.mudDensity, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP).toArray(new Biome[0])));
        if (PVJConfig.master.enableFallenTrees) {
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(BiomeReference.OAK_LOG, PVJConfig.worldgen.fallenTreeOakDensity, BiomeReference.getBiomes(BiomeReference.OAK_TREES)));
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(BiomeReference.OAK_LOG, PVJConfig.worldgen.fallenTreeOakSparseDensity, BiomeReference.getBiomes(BiomeReference.OAK_TREES_SPARSE)));
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(BiomeReference.BIRCH_LOG, PVJConfig.worldgen.fallenTreeBirchDensity, BiomeReference.getBiomes(BiomeReference.BIRCH_TREES)));
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(BiomeReference.BIRCH_LOG, PVJConfig.worldgen.fallenTreeBirchSparseDensity, BiomeReference.getBiomes(BiomeReference.BIRCH_TREES_SPARSE)));
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(BiomeReference.SPRUCE_LOG, PVJConfig.worldgen.fallenTreeSpruceDensity, BiomeReference.getBiomes(BiomeReference.SPRUCE_TREES)));
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(BiomeReference.SPRUCE_LOG, PVJConfig.worldgen.fallenTreeSpruceSparseDensity, BiomeReference.getBiomes(BiomeReference.SPRUCE_TREES_SPARSE)));
            PVJWorldGen.registerWorldGen(new WorldGenFallenTree(BiomeReference.ACACIA_LOG, PVJConfig.worldgen.fallenTreeAcaciaDensity, BiomeReference.getBiomes(BiomeReference.ACACIA_TREES)));
            for (EnumWoodType enumWoodType : EnumWoodType.values()) {
                if (enumWoodType.getFallenTreeDensity() == -1 || enumWoodType.getTreeDensity() <= 0) continue;
                PVJWorldGen.registerWorldGen(new WorldGenFallenTree(PVJBlocks.LOGS.get(enumWoodType.getID()), enumWoodType.getFallenTreeDensity(), enumWoodType.getTreeBiomes()));
            }
        } else {
            ProjectVibrantJourneys.logger.info("Fallen trees disabled");
        }
        PVJWorldGen.registerWorldGen(new WorldGenMangroveRoot(PVJConfig.worldgen.mangroveRootDensity, BiomeReference.getBiomes(BiomeReference.MANGROVE_TREES)));
        PVJWorldGen.registerWorldGen(new WorldGenSmallBush(PVJConfig.worldgen.bushDensity, BiomeReference.getBiomes(BiomeReference.OAK_TREES_SPARSE)));
        if (PVJConfig.master.enableGroundcover) {
            if (PVJConfig.master.enableFallenLeaves) {
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_oak, PVJConfig.worldgen.fallenLeavesOakDensity, BiomeReference.OAK_TREES.toArray(new Biome[0])));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_oak, PVJConfig.worldgen.fallenLeavesOakSparseDensity, BiomeReference.getBiomes(BiomeReference.OAK_TREES_SPARSE)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_birch, PVJConfig.worldgen.fallenLeavesBirchDensity, BiomeReference.getBiomes(BiomeReference.BIRCH_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_birch, PVJConfig.worldgen.fallenLeavesBirchSparseDensity, BiomeReference.getBiomes(BiomeReference.BIRCH_TREES_SPARSE)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_spruce, PVJConfig.worldgen.fallenLeavesSpruceDensity, BiomeReference.getBiomes(BiomeReference.SPRUCE_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_spruce, PVJConfig.worldgen.fallenLeavesSpruceSparseDensity, BiomeReference.getBiomes(BiomeReference.SPRUCE_TREES_SPARSE)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_jungle, PVJConfig.worldgen.fallenLeavesJungleDensity, BiomeReference.getBiomes(BiomeReference.JUNGLE_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_jungle, PVJConfig.worldgen.fallenLeavesJungleSparseDensity, BiomeReference.getBiomes(BiomeReference.JUNGLE_TREES_SPARSE)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_darkoak, PVJConfig.worldgen.fallenLeavesDarkOakDensity, BiomeReference.getBiomes(BiomeReference.DARKOAK_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_darkoak, PVJConfig.worldgen.fallenLeavesDarkOakSparseDensity, BiomeReference.getBiomes(BiomeReference.DARKOAK_TREES_SPARSE)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_acacia, PVJConfig.worldgen.fallenLeavesAcaciaDensity, BiomeReference.getBiomes(BiomeReference.ACACIA_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_acacia, PVJConfig.worldgen.fallenLeavesAcaciaDensity, BiomeReference.getBiomes(BiomeReference.ACACIA_TREES_SPARSE)));
                PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.fallenleaves_dead, PVJConfig.worldgen.fallenLeavesDeadDensity, BiomeReference.getBiomes(BiomeReference.MESA_BIOMES)));
                for (Enum enum_ : EnumLeafType.values()) {
                    if (((EnumLeafType)enum_).getFallenLeavesDensity() == -1 || ((EnumLeafType)enum_).getWoodType().getTreeDensity() <= 0) continue;
                    PVJWorldGen.registerWorldGen(new WorldGenFallenLeaves(PVJBlocks.FALLEN_LEAVES.get(((EnumLeafType)enum_).getID()), ((EnumLeafType)enum_).getFallenLeavesDensity(), ((EnumLeafType)enum_).getTreeBiomes()));
                }
            } else {
                ProjectVibrantJourneys.logger.info("Fallen leaves disabled");
            }
            if (PVJConfig.master.enableRocks) {
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.stone_rocks, 60, 200, PVJConfig.worldgen.stoneRocksDensity, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.cobblestone_rocks, 60, 200, PVJConfig.worldgen.cobblestoneRocksDensity, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.mossy_cobblestone_rocks, 40, 200, PVJConfig.worldgen.mossyCobblestoneRocksDensity, BiomeReference.getBiomes(BiomeReference.MOSSY_COBBLESTONE_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.andesite_rocks, 60, 200, PVJConfig.worldgen.andesiteRocksDensity, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.granite_rocks, 60, 200, PVJConfig.worldgen.graniteRocksDensity, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.diorite_rocks, 60, 200, PVJConfig.worldgen.dioriteRocksDensity, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.sandstone_rocks, 50, 100, PVJConfig.worldgen.sandstoneRocksDensity, BiomeReference.getBiomes(BiomeReference.SANDSTONE_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.red_sandstone_rocks, 55, 75, PVJConfig.worldgen.redSandstoneRocksDensity, BiomeReference.getBiomes(BiomeReference.MESA_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.stone_rocks, 1, 60, PVJConfig.worldgen.stoneRocksCaveDensity, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.cobblestone_rocks, 1, 60, PVJConfig.worldgen.cobblestoneRocksCaveDensity, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.andesite_rocks, 1, 60, PVJConfig.worldgen.andesiteRocksCaveDensity, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.granite_rocks, 1, 60, PVJConfig.worldgen.graniteCaveDensity, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.diorite_rocks, 1, 60, PVJConfig.worldgen.dioriteRocksCaveDensity, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES)));
            } else {
                ProjectVibrantJourneys.logger.info("Rocks disabled");
            }
            if (PVJConfig.master.enableTwigs) {
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.oak_twigs, 60, 150, PVJConfig.worldgen.oakTwigsDensity, BiomeReference.getBiomes(BiomeReference.OAK_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.oak_twigs, 60, 150, PVJConfig.worldgen.oakTwigsSparseDensity, BiomeReference.getBiomes(BiomeReference.OAK_TREES_SPARSE)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.birch_twigs, 60, 150, PVJConfig.worldgen.birchTwigsDensity, BiomeReference.getBiomes(BiomeReference.BIRCH_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.birch_twigs, 60, 150, PVJConfig.worldgen.birchTwigsSparseDensity, BiomeReference.getBiomes(BiomeReference.BIRCH_TREES_SPARSE)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.spruce_twigs, 60, 150, PVJConfig.worldgen.spruceTwigsDensity, BiomeReference.getBiomes(BiomeReference.SPRUCE_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.spruce_twigs, 60, 150, PVJConfig.worldgen.spruceTwigsSparseDensity, BiomeReference.getBiomes(BiomeReference.SPRUCE_TREES_SPARSE)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.jungle_twigs, 60, 150, PVJConfig.worldgen.jungleTwigsDensity, BiomeReference.getBiomes(BiomeReference.JUNGLE_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.acacia_twigs, 60, 150, PVJConfig.worldgen.acaciaTwigsDensity, BiomeReference.getBiomes(BiomeReference.ACACIA_TREES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.dark_oak_twigs, 60, 150, PVJConfig.worldgen.darkOakTwigsDensity, BiomeReference.getBiomes(BiomeReference.DARKOAK_TREES)));
                for (Enum enum_ : EnumLeafType.values()) {
                    if (((EnumLeafType)enum_).getTwigsDensity() == -1 || ((EnumLeafType)enum_).getWoodType().getTreeDensity() <= 0) continue;
                    PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.TWIGS.get(((EnumLeafType)enum_).getID()), 60, 150, ((EnumLeafType)enum_).getTwigsDensity(), ((EnumLeafType)enum_).getTreeBiomes()));
                }
            } else {
                ProjectVibrantJourneys.logger.info("Twigs disabled");
            }
            if (PVJConfig.master.enableBones) {
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.bones, 1, 100, PVJConfig.worldgen.bonesDensity, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.bones, 1, 100, PVJConfig.worldgen.bonesDesertDensity, BiomeReference.getBiomes(BiomeReference.DESERT_BIOMES)));
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.bones, 1, 150, PVJConfig.worldgen.bonesNetherDensity, BiomeReference.getBiomes(BiomeReference.NETHER_BIOMES)));
            } else {
                ProjectVibrantJourneys.logger.info("Bones disabled");
            }
            if (PVJConfig.master.enableSeashells) {
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.seashells, 60, 80, PVJConfig.worldgen.seashellsDensity, BiomeReference.getBiomes(BiomeReference.BEACH_BIOMES)));
            } else {
                ProjectVibrantJourneys.logger.info("Seashells disabled :(");
            }
            if (PVJConfig.master.enablePinecones) {
                PVJWorldGen.registerWorldGen(new WorldGenGroundCover(PVJBlocks.pinecones, 60, 80, PVJConfig.worldgen.pineconesDensity, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS).toArray(new Biome[0])));
            } else {
                ProjectVibrantJourneys.logger.info("Pinecones took a long time to model...and you disabled them!");
            }
            if (PVJConfig.master.enableFlowerPatches) {
                PVJWorldGen.registerWorldGen(new WorldGenFlowerPatch(PVJConfig.worldgen.flowerPatchDensity, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES)));
            } else {
                ProjectVibrantJourneys.logger.info("Flower patches disabled");
            }
        } else {
            ProjectVibrantJourneys.logger.info("Groundcover disabled. You're a boring person!");
        }
        PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.wild_wheat, PVJConfig.worldgen.wildWheatDensity, PVJBiomes.prairie));
        PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.wild_potato, PVJConfig.worldgen.wildPotatoDensity, Biomes.field_76772_c));
        PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.wild_carrot, PVJConfig.worldgen.wildCarrotDensity, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.COLD).toArray(new Biome[0])));
        PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.wild_beetroot, PVJConfig.worldgen.wildBeetrootDensity, BiomeReference.getBiomes(BiomeReference.OAK_TREES)));
        PVJWorldGen.registerWorldGen(new WorldGenCrackedSand(PVJBlocks.cracked_sand, (Block)Blocks.field_150354_m, 60, 150, PVJConfig.worldgen.crackedSandDensity, BiomeReference.getBiomes(BiomeReference.DESERT_BIOMES)));
        PVJWorldGen.registerWorldGen(new WorldGenCrackedSand(PVJBlocks.red_cracked_sand, (Block)Blocks.field_150354_m, 60, 150, PVJConfig.worldgen.redCrackedSandDensity, BiomeReference.getBiomes(BiomeReference.MESA_BIOMES)));
        if (PVJConfig.master.enableOverworldPlants) {
            PVJWorldGen.registerWorldGen(new WorldGenShortGrass(PVJBlocks.short_grass, PVJConfig.worldgen.shortGrassDensity, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.frost_lotus, PVJConfig.worldgen.frostLotusDensity, BiomeReference.getBiomes(BiomeReference.SNOWY_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.sundew, PVJConfig.worldgen.sundewDensity, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP).toArray(new Biome[0])));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.silverleaf, PVJConfig.worldgen.silverleafDensity, BiomeReference.getBiomes(BiomeReference.OAK_TREES)));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.chickweed, PVJConfig.worldgen.chickweedDensity, BiomeReference.getBiomes(BiomeReference.FRESHWATER_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.clovers, PVJConfig.worldgen.cloversDensity, BiomeReference.getBiomes(BiomeReference.FRESHWATER_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.crabgrass, PVJConfig.worldgen.crabgrassDensity, BiomeReference.getBiomes(BiomeReference.FRESHWATER_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.waxcap, PVJConfig.worldgen.waxcapDensity, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST).toArray(new Biome[0])));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.orange_mushroom, PVJConfig.worldgen.orangeMushroomDensity, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST).toArray(new Biome[0])));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.deathcap, PVJConfig.worldgen.deathcapDensity, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST).toArray(new Biome[0])));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.small_cactus, PVJConfig.worldgen.smallCactusDensity, BiomeReference.getBiomes(BiomeReference.DESERT_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.small_cactus, PVJConfig.worldgen.smallCactusDensity, BiomeReference.getBiomes(BiomeReference.MESA_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenBeachGrass(PVJConfig.worldgen.beachGrassDensity, BiomeReference.getBiomes(BiomeReference.BEACH_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenSeaOats(PVJConfig.worldgen.seaOatsDensity, BiomeReference.getBiomes(BiomeReference.BEACH_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenFloaters(true, PVJConfig.worldgen.lilypadRiverDensity, true));
            PVJWorldGen.registerWorldGen(new WorldGenFloaters(false, PVJConfig.worldgen.lilypadLakesDensity, false));
            PVJWorldGen.registerWorldGen(new WorldGenBracketFungus(PVJConfig.worldgen.bracketFungusDensity, BiomeReference.getBiomes(BiomeReference.FRESHWATER_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenFlouropore(PVJConfig.worldgen.flouroporeDensity, BiomeReference.getBiomes(BiomeReference.OVERWORLD_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenRiverGrass(PVJConfig.worldgen.riverGrassDensity));
            PVJWorldGen.registerWorldGen(new WorldGenCattail(PVJConfig.worldgen.cattailDensity, BiomeReference.getBiomes(BiomeReference.FRESHWATER_BIOMES)));
        } else {
            ProjectVibrantJourneys.logger.info("Overworld plants disabled");
        }
        if (PVJConfig.master.enableNetherPlants) {
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.bloodnettle, PVJConfig.worldgen.bloodnettleDensity, -1, BiomeReference.getBiomes(BiomeReference.NETHER_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.glowcap, PVJConfig.worldgen.glowcapDensity, -1, BiomeReference.getBiomes(BiomeReference.NETHER_BIOMES)));
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.witherweed, PVJConfig.worldgen.witherweedDensity, -1, BiomeReference.getBiomes(BiomeReference.NETHER_BIOMES)));
        } else {
            ProjectVibrantJourneys.logger.info("Nether plants disabled");
        }
        if (PVJConfig.master.enableEndPlants) {
            PVJWorldGen.registerWorldGen(new WorldGenPVJPlant(PVJBlocks.void_grass, PVJConfig.worldgen.voidGrassDensity, 1, BiomeReference.getBiomes(BiomeReference.END_BIOMES)));
        } else {
            ProjectVibrantJourneys.logger.info("End plants disabled");
        }
        if (PVJConfig.master.enableStructures) {
            PVJWorldGen.registerWorldGen(new WorldGenAbandonedFarm(PVJConfig.worldgen.abandonedFarmWeight, BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.PLAINS).toArray(new Biome[0])));
            PVJWorldGen.registerWorldGen(new WorldGenRuins(PVJConfig.worldgen.ruinsWeight, BiomeReference.getBiomes(BiomeReference.OAK_TREES)));
            PVJWorldGen.registerWorldGen(new WorldGenRuins(PVJConfig.worldgen.ruinsWeight, BiomeReference.getBiomes(BiomeReference.BIRCH_TREES)));
        } else {
            ProjectVibrantJourneys.logger.info("Structures disabled");
        }
        if (Reference.isBOPLoaded) {
            PVJWorldGenBOP.initWorldGenBOP();
        }
        if (Reference.isTraverseLoaded) {
            PVJWorldGenTraverse.initWorldGenBOP();
        }
    }

    public static void registerWorldGen(IWorldGenerator worldgen) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldgen, (int)0);
    }

    public static int[] getDimensionBlacklist() {
        if (!PVJConfig.worldgen.dimensionBlacklist.equals("")) {
            String[] temp = PVJConfig.worldgen.dimensionBlacklist.split(",");
            int[] ids = new int[temp.length];
            for (int i = 0; i < temp.length; ++i) {
                String s = temp[i];
                try {
                    int id;
                    ids[i] = id = Integer.parseInt(s);
                    continue;
                }
                catch (NumberFormatException e) {
                    ProjectVibrantJourneys.logger.error("Invalid id format in the dimension blacklist: " + s);
                    ids[i] = 921;
                }
            }
            return ids;
        }
        return new int[0];
    }

    public static boolean shouldGenHere(int dim, World world) {
        try {
            if (world.field_73011_w == DimensionManager.getProvider((int)dim)) {
                return false;
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        return true;
    }
}

