/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.init;

import java.util.ArrayList;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vibrantjourneys.ProjectVibrantJourneys;
import vibrantjourneys.biomes.BiomeAspenGrove;
import vibrantjourneys.biomes.BiomeBaobabFields;
import vibrantjourneys.biomes.BiomeBlossomingFields;
import vibrantjourneys.biomes.BiomeBorealForest;
import vibrantjourneys.biomes.BiomeOvergrownSpires;
import vibrantjourneys.biomes.BiomePrairie;
import vibrantjourneys.biomes.BiomeRedwoods;
import vibrantjourneys.biomes.BiomeWillowSwamp;
import vibrantjourneys.util.PVJConfig;

public class PVJBiomes {
    public static final ArrayList<Biome> BIOMES = new ArrayList();
    public static Biome prairie = new BiomePrairie(new Biome.BiomeProperties("Prairie").func_185398_c(0.018f).func_185400_d(0.005f).func_185410_a(0.8f).func_185395_b(0.25f));
    public static Biome redwoods = new BiomeRedwoods(new Biome.BiomeProperties("Redwoods").func_185398_c(0.19f).func_185400_d(0.31f).func_185410_a(0.45f).func_185395_b(0.6f));
    public static Biome redwood_peaks = new BiomeRedwoods(new Biome.BiomeProperties("Redwood Peaks").func_185398_c(0.8f).func_185400_d(0.75f).func_185410_a(0.45f).func_185395_b(0.55f));
    public static Biome willow_swamp = new BiomeWillowSwamp(new Biome.BiomeProperties("Willow Swamp").func_185398_c(-0.2f).func_185400_d(0.05f).func_185410_a(0.8f).func_185395_b(0.9f).func_185402_a(14745518));
    public static Biome boreal_forest = new BiomeBorealForest(new Biome.BiomeProperties("Boreal Forest").func_185398_c(0.2f).func_185400_d(0.1f).func_185410_a(0.25f).func_185395_b(0.8f));
    public static Biome snowy_boreal_forest = new BiomeBorealForest(new Biome.BiomeProperties("Snowy Boreal Forest").func_185398_c(0.2f).func_185400_d(0.1f).func_185410_a(-0.5f).func_185395_b(0.4f).func_185411_b());
    public static Biome aspen_grove = new BiomeAspenGrove(new Biome.BiomeProperties("Aspen Grove").func_185410_a(0.7f).func_185395_b(0.8f));
    public static Biome overgrown_spires = new BiomeOvergrownSpires(new Biome.BiomeProperties("Overgrown Spires").func_185398_c(0.2f).func_185400_d(0.3f).func_185410_a(0.95f).func_185395_b(0.9f));
    public static Biome blossoming_fields = new BiomeBlossomingFields(new Biome.BiomeProperties("Blossoming Fields").func_185398_c(0.009f).func_185400_d(0.001f).func_185410_a(0.5f).func_185395_b(0.55f));
    public static Biome baobab_fields = new BiomeBaobabFields(new Biome.BiomeProperties("Baobab Fields").func_185398_c(0.125f).func_185400_d(0.05f).func_185410_a(1.2f).func_185395_b(0.0f).func_185396_a());

    public static void initBiomes() {
        if (PVJConfig.master.enableBiomes) {
            PVJBiomes.registerBiome(prairie, "prairie", PVJConfig.biomes.prairieWeight, true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.PLAINS);
            PVJBiomes.registerBiome(redwoods, "redwoods", PVJConfig.biomes.redwoodsWeight, false, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST);
            PVJBiomes.registerBiome(redwood_peaks, "redwood_peaks", PVJConfig.biomes.redwoodPeaksWeight, false, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN);
            PVJBiomes.registerBiome(willow_swamp, "willow_swamp", PVJConfig.biomes.willowSwampWeight, false, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH);
            PVJBiomes.registerBiome(boreal_forest, "boreal_forest", PVJConfig.biomes.borealForestWeight, false, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST);
            PVJBiomes.registerBiome(snowy_boreal_forest, "snowy_boreal_forest", PVJConfig.biomes.snowyBorealForestWeight, false, BiomeManager.BiomeType.ICY, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY);
            PVJBiomes.registerBiome(aspen_grove, "aspen_grove", PVJConfig.biomes.aspenGroveWeight, false, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST);
            PVJBiomes.registerBiome(overgrown_spires, "overgrown_spires", PVJConfig.biomes.overgrownSpiresWeight, false, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.JUNGLE);
            PVJBiomes.registerBiome(blossoming_fields, "blossoming_fields", PVJConfig.biomes.blossomingfields, true, BiomeManager.BiomeType.COOL, BiomeDictionary.Type.FOREST);
            if (PVJConfig.worldgen.enableBaobabFields) {
                PVJBiomes.registerBiome(baobab_fields, "baobab_fields", PVJConfig.biomes.baobabFieldsWeight, true, BiomeManager.BiomeType.WARM, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE);
            }
        } else {
            ProjectVibrantJourneys.logger.info("Biomes disabled. That makes me sad :(");
        }
        if (PVJConfig.worldgen.allowBeachVillages) {
            BiomeManager.addVillageBiome((Biome)Biomes.field_76787_r, (boolean)true);
        }
    }

    public static void registerBiome(Biome biome, String name, int weight, boolean hasVillages, BiomeManager.BiomeType biomeType, BiomeDictionary.Type ... types) {
        if (weight > 0) {
            biome.setRegistryName(name);
            ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
            BiomeManager.addBiome((BiomeManager.BiomeType)biomeType, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, weight));
            BiomeManager.addSpawnBiome((Biome)biome);
            if (hasVillages) {
                BiomeManager.addVillageBiome((Biome)biome, (boolean)true);
            }
        }
    }
}

