/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.entities.monster;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import vibrantjourneys.entities.ai.EntityAIGoonPukeSilverfish;
import vibrantjourneys.entities.ai.EntityAISilverfishDeathTimer;
import vibrantjourneys.init.PVJSounds;
import vibrantjourneys.util.PVJConfig;
import vibrantjourneys.util.PVJLootTableList;

public class EntityGoon
extends EntityMob {
    private int maxSilverfishSpawned;
    private int silverfishSpawned;

    public EntityGoon(World world) {
        super(world);
        this.func_70105_a(0.52f, 1.6575f);
        this.maxSilverfishSpawned = world.field_73012_v.nextInt(2) + 4 + (world.field_73012_v.nextInt(5) < 2 ? 1 : 0);
        this.silverfishSpawned = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, new EntityAIGoonPukeSilverfish<EntityGoon>(this, 1.1, 60, 15.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityChicken.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    public void func_70636_d() {
        boolean flag;
        float f;
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && (f = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v)) && (flag = true)) {
            this.func_70015_d(8);
        }
        super.func_70636_d();
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return PVJLootTableList.GOON;
    }

    protected SoundEvent func_184639_G() {
        return PVJConfig.entities.replaceGoonSounds ? SoundEvents.field_187899_gZ : PVJSounds.GOON_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return PVJConfig.entities.replaceGoonSounds ? SoundEvents.field_187934_hh : PVJSounds.GOON_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return PVJConfig.entities.replaceGoonSounds ? SoundEvents.field_187930_hd : PVJSounds.GOON_DEATH;
    }

    public int func_70641_bl() {
        return 1;
    }

    public void incrementSilverfish() {
        ++this.silverfishSpawned;
        if (this.silverfishSpawned >= this.maxSilverfishSpawned) {
            this.field_70714_bg.func_85156_a(new EntityAIGoonPukeSilverfish<EntityGoon>(this, 1.1, 60, 15.0f));
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        }
    }

    public void pukeSilverfish(EntityLivingBase target) {
        if (!this.field_70170_p.field_72995_K) {
            EntitySilverfish silverfish = new EntitySilverfish(this.field_70170_p);
            silverfish.field_70714_bg.field_75782_a.clear();
            silverfish.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)silverfish, 1.0, false));
            silverfish.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
            silverfish.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAISilverfishDeathTimer(silverfish));
            silverfish.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70170_p.func_72838_d((Entity)silverfish);
            this.func_184185_a(PVJConfig.entities.replaceGoonSounds ? SoundEvents.field_187934_hh : PVJSounds.GOON_PUKE, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            silverfish.func_70624_b(target);
            this.incrementSilverfish();
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("SilverfishSpawned", this.silverfishSpawned);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.silverfishSpawned = compound.func_74762_e("SilverfishSpawned");
    }

    public boolean func_70601_bi() {
        if (this.field_70170_p.field_73011_w.func_186058_p() != DimensionType.OVERWORLD) {
            return false;
        }
        return super.func_70601_bi();
    }
}

