/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.blocks.wood;

import com.google.common.collect.ImmutableList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.TerrainGen;
import vibrantjourneys.util.EnumLeafType;
import vibrantjourneys.util.EnumWoodType;
import vibrantjourneys.util.IPropertyHelper;
import vibrantjourneys.worldgen.feature.WorldGenAspenTree;
import vibrantjourneys.worldgen.feature.WorldGenBaobabTree;
import vibrantjourneys.worldgen.feature.WorldGenCherryBlossomTree;
import vibrantjourneys.worldgen.feature.WorldGenCottonwoodTree;
import vibrantjourneys.worldgen.feature.WorldGenFirTree;
import vibrantjourneys.worldgen.feature.WorldGenGenericTree;
import vibrantjourneys.worldgen.feature.WorldGenJacarandaTree;
import vibrantjourneys.worldgen.feature.WorldGenJuniperTree;
import vibrantjourneys.worldgen.feature.WorldGenMangroveTree;
import vibrantjourneys.worldgen.feature.WorldGenPalmTree;
import vibrantjourneys.worldgen.feature.WorldGenPineTree;
import vibrantjourneys.worldgen.feature.WorldGenRedwoodLarge;
import vibrantjourneys.worldgen.feature.WorldGenRedwoodSmall;
import vibrantjourneys.worldgen.feature.WorldGenWillowTree;

public class BlockPVJSapling
extends BlockBush
implements IGrowable,
IPropertyHelper {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);
    private EnumLeafType leafType;

    public BlockPVJSapling(EnumLeafType leafType) {
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        this.leafType = leafType;
        Blocks.field_150480_ab.func_180686_a((Block)this, 30, 60);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (!worldIn.func_175697_a(pos, 1)) {
                return;
            }
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.grow(worldIn, pos, state, rand);
            }
        }
    }

    public void grow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
        } else {
            this.generateTree(worldIn, pos, state, rand);
        }
    }

    public void generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        Object worldgenerator = new WorldGenRedwoodSmall();
        int i = 0;
        int j = 0;
        boolean flag = false;
        switch (this.leafType) {
            case REDWOOD: {
                block17: for (i = 0; i >= -1; --i) {
                    for (j = 0; j >= -1; --j) {
                        if (!this.isTwoByTwoOfType(worldIn, pos, i, j, EnumWoodType.REDWOOD)) continue;
                        worldgenerator = new WorldGenRedwoodLarge(true, 30, 20);
                        flag = true;
                        break block17;
                    }
                }
                if (flag) break;
                i = 0;
                j = 0;
                worldgenerator = new WorldGenRedwoodSmall();
                break;
            }
            case BAOBAB: {
                block19: for (i = 0; i >= -1; --i) {
                    for (j = 0; j >= -1; --j) {
                        if (!this.isTwoByTwoOfType(worldIn, pos, i, j, EnumWoodType.BAOBAB)) continue;
                        worldgenerator = new WorldGenBaobabTree(true, 15, 6);
                        flag = true;
                        break block19;
                    }
                }
                if (flag) break;
                return;
            }
            case PALM: {
                worldgenerator = new WorldGenPalmTree();
                break;
            }
            case WILLOW: {
                worldgenerator = new WorldGenWillowTree();
                break;
            }
            case MANGROVE: {
                worldgenerator = new WorldGenMangroveTree();
                break;
            }
            case FIR: {
                worldgenerator = new WorldGenFirTree(true);
                break;
            }
            case PINE: {
                worldgenerator = new WorldGenPineTree(true);
                break;
            }
            case ASPEN: {
                worldgenerator = new WorldGenAspenTree(true);
                break;
            }
            case RED_MAPLE: {
                worldgenerator = new WorldGenGenericTree(true, EnumWoodType.MAPLE, EnumLeafType.RED_MAPLE);
                break;
            }
            case ORANGE_MAPLE: {
                worldgenerator = new WorldGenGenericTree(true, EnumWoodType.MAPLE, EnumLeafType.ORANGE_MAPLE);
                break;
            }
            case COTTONWOOD: {
                worldgenerator = new WorldGenCottonwoodTree(true);
                break;
            }
            case JUNIPER: {
                worldgenerator = new WorldGenJuniperTree(true);
                break;
            }
            case WHITE_CHERRY_BLOSSOM: {
                worldgenerator = new WorldGenCherryBlossomTree(true, false);
                break;
            }
            case PINK_CHERRY_BLOSSOM: {
                worldgenerator = new WorldGenCherryBlossomTree(true, true);
                break;
            }
            case JACARANDA: {
                worldgenerator = new WorldGenJacarandaTree(true);
                break;
            }
        }
        IBlockState iblockstate2 = Blocks.field_150350_a.func_176223_P();
        if (flag) {
            worldIn.func_180501_a(pos.func_177982_a(i, 0, j), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i, 0, j + 1), iblockstate2, 4);
            worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), iblockstate2, 4);
        } else {
            worldIn.func_180501_a(pos, iblockstate2, 4);
        }
        if (!worldgenerator.func_180709_b(worldIn, rand, pos.func_177982_a(i, 0, j))) {
            if (flag) {
                worldIn.func_180501_a(pos.func_177982_a(i, 0, j), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i, 0, j + 1), state, 4);
                worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), state, 4);
            } else {
                worldIn.func_180501_a(pos, state, 4);
            }
        }
    }

    public EnumLeafType getLeafType() {
        return this.leafType;
    }

    private boolean isTwoByTwoOfType(World worldIn, BlockPos pos, int xOffset, int zOffset, EnumWoodType type) {
        return this.isTypeAt(worldIn, pos.func_177982_a(xOffset, 0, zOffset), type) && this.isTypeAt(worldIn, pos.func_177982_a(xOffset + 1, 0, zOffset), type) && this.isTypeAt(worldIn, pos.func_177982_a(xOffset, 0, zOffset + 1), type) && this.isTypeAt(worldIn, pos.func_177982_a(xOffset + 1, 0, zOffset + 1), type);
    }

    public boolean isTypeAt(World worldIn, BlockPos pos, EnumWoodType type) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (iblockstate.func_177230_c() instanceof BlockPVJSapling) {
            return ((BlockPVJSapling)iblockstate.func_177230_c()).getLeafType() == this.leafType;
        }
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        if (this.leafType == EnumLeafType.PALM || this.leafType == EnumLeafType.MANGROVE || this.leafType == EnumLeafType.JUNIPER) {
            return super.func_176196_c(worldIn, pos) || soil.func_177230_c() == Blocks.field_150354_m;
        }
        return super.func_176196_c(worldIn, pos) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    protected boolean func_185514_i(IBlockState state) {
        if (this.leafType == EnumLeafType.PALM || this.leafType == EnumLeafType.MANGROVE) {
            return state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150458_ak || state.func_177230_c() == Blocks.field_150354_m;
        }
        return state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150458_ak;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.grow(worldIn, pos, state, rand);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return Blocks.field_150345_g.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return Blocks.field_150345_g.getFireSpreadSpeed(world, pos, face);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }

    @Override
    public ImmutableList<IBlockState> getProperties() {
        return this.field_176227_L.func_177619_a();
    }
}

