/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.blocks;

import com.google.common.collect.ImmutableList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vibrantjourneys.util.IPropertyHelper;
import vibrantjourneys.util.PVJConfig;

public class BlockGroundCover
extends Block
implements IPropertyHelper {
    public static final PropertyInteger MODEL = PropertyInteger.func_177719_a((String)"model", (int)0, (int)4);
    private GroundcoverType groundcoverType;

    public BlockGroundCover(Material material, GroundcoverType type) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)MODEL, (Comparable)Integer.valueOf(0)));
        if (material == Material.field_151582_l) {
            this.func_149672_a(SoundType.field_185850_c);
        } else if (type == GroundcoverType.TWIGS || type == GroundcoverType.PINECONES) {
            this.func_149672_a(SoundType.field_185848_a);
        }
        this.groundcoverType = type;
        this.func_149711_c(0.1f);
        if (type == GroundcoverType.TWIGS || type == GroundcoverType.PINECONES) {
            Blocks.field_150480_ab.func_180686_a((Block)this, 30, 60);
        }
    }

    public GroundcoverType getGroundcoverType() {
        return this.groundcoverType;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.getGroundcoverType() == GroundcoverType.FLOWER_PATCH) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.01, 1.0);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) ? this.canBlockStay(worldIn, pos) : false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            worldIn.func_175698_g(pos);
        }
    }

    private boolean canBlockStay(World world, BlockPos pos) {
        return world.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149751_l(IBlockState state) {
        if (this.getGroundcoverType() == GroundcoverType.FLOWER_PATCH) {
            return true;
        }
        return super.func_149751_l(state);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        if (this.getGroundcoverType() == GroundcoverType.FLOWER_PATCH) {
            return BlockRenderLayer.TRANSLUCENT;
        }
        return super.func_180664_k();
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            int meta = new Random().nextInt(5);
            world.func_175656_a(pos, this.func_176203_a(meta));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_70093_af() && PVJConfig.misc.shiftRightClickGroundCover) {
            ItemStack stack = new ItemStack((Block)this, 1, 0);
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            world.func_175698_g(pos);
        } else if (player.func_184812_l_()) {
            int meta = this.func_176201_c(state);
            meta = meta != 4 ? ++meta : 0;
            world.func_175656_a(pos, this.func_176203_a(meta));
        }
        return true;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.getGroundcoverType() == GroundcoverType.TWIGS && rand.nextBoolean()) {
            return Items.field_151055_y;
        }
        return Items.field_190931_a;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MODEL, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)MODEL);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MODEL});
    }

    @Override
    public ImmutableList<IBlockState> getProperties() {
        return this.field_176227_L.func_177619_a();
    }

    public static enum GroundcoverType {
        TWIGS,
        ROCKS,
        BONES,
        SEASHELLS,
        PINECONES,
        FLOWER_PATCH;

    }
}

