/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.biomes;

import java.util.Random;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vibrantjourneys.util.PVJConfig;
import vibrantjourneys.worldgen.feature.WorldGenCherryBlossomTree;
import vibrantjourneys.worldgen.feature.WorldGenJacarandaTree;

public class BiomeBlossomingFields
extends Biome {
    private static final WorldGenCherryBlossomTree PINK_CHERRY = new WorldGenCherryBlossomTree(false, true);
    private static final WorldGenCherryBlossomTree WHITE_CHERRY = new WorldGenCherryBlossomTree(false, false);
    private static final WorldGenJacarandaTree JACARANDA = new WorldGenJacarandaTree(false);

    public BiomeBlossomingFields(Biome.BiomeProperties properties) {
        super(properties);
        this.field_76760_I.field_76832_z = 1;
        this.field_76760_I.field_76803_B = 13;
        this.field_76760_I.field_76802_A = 18;
        this.field_76760_I.field_76798_D = -999;
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        int num = rand.nextInt(100);
        if (PVJConfig.worldgen.pinkCherryBlossomDensity > 0 && num > 66) {
            return PINK_CHERRY;
        }
        if (PVJConfig.worldgen.whiteCherryBlossomDensity > 0 && num > 33) {
            return WHITE_CHERRY;
        }
        return JACARANDA;
    }

    public BlockFlower.EnumFlowerType func_180623_a(Random rand, BlockPos pos) {
        double d0 = MathHelper.func_151237_a((double)((1.0 + field_180281_af.func_151601_a((double)pos.func_177958_n() / 48.0, (double)pos.func_177952_p() / 48.0)) / 2.0), (double)0.0, (double)0.9999);
        BlockFlower.EnumFlowerType flower = BlockFlower.EnumFlowerType.values()[(int)(d0 * (double)BlockFlower.EnumFlowerType.values().length)];
        return flower;
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        int i = rand.nextInt(5) - 1;
        this.addDoublePlants(worldIn, rand, pos, i);
        super.func_180624_a(worldIn, rand, pos);
    }

    public void addDoublePlants(World world, Random rand, BlockPos pos, int frequency) {
        block0: for (int i = 0; i < frequency; ++i) {
            int j = rand.nextInt(3);
            if (j == 0) {
                field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.SYRINGA);
            } else if (j == 1) {
                field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.ROSE);
            } else if (j == 2) {
                field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.PAEONIA);
            }
            for (int k = 0; k < 5; ++k) {
                int l = rand.nextInt(16) + 8;
                int i1 = rand.nextInt(16) + 8;
                int j1 = rand.nextInt(world.func_175645_m(pos.func_177982_a(l, 0, i1)).func_177956_o() + 32);
                if (field_180280_ag.func_180709_b(world, rand, new BlockPos(pos.func_177958_n() + l, j1, pos.func_177952_p() + i1))) continue block0;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return 11464028;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        return 11464028;
    }
}

