/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.soulshardsrespawn.core;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import info.tehnut.soulshardsrespawn.SoulShards;
import info.tehnut.soulshardsrespawn.core.data.MultiblockPattern;
import info.tehnut.soulshardsrespawn.core.util.JsonUtil;
import info.tehnut.soulshardsrespawn.core.util.compat.ICompatibilityPlugin;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.FileUtils;

public class ConfigHandler {
    private static final Set<String> DEFAULT_DISABLES = Sets.newHashSet((Object[])new String[]{"minecraft:armor_stand", "minecraft:elder_guardian", "minecraft:ender_dragon", "minecraft:wither"});
    private final Configuration config;
    private final Map<ResourceLocation, Boolean> entityMap;
    private int spawnCap;
    private boolean allowBossSpawns;
    private boolean allowSpawnerAbsorption;
    private int absorptionBonus;
    private boolean dropExperience;
    private boolean countCageBornForShard;
    private boolean addShardResetRecipe;
    private boolean allowShardCombination;
    private boolean allowFakePlayers;
    private MultiblockPattern multiblockPattern;
    private boolean requireOwnerOnline;
    private boolean requireRedstoneSignal;
    private boolean displayDurabilityBar;
    private boolean explodeCreativeTab;
    private boolean ignoreBlacklistForTab;
    private boolean hwylaCompatibility;

    public ConfigHandler(File configDir) {
        this.config = new Configuration(new File(configDir, "soulshardsrespawn.cfg"));
        this.entityMap = Maps.newHashMap();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void syncConfig() {
        this.spawnCap = this.config.getInt("spawnCap", "balance", 30, 0, 256, "The maximum amount of cage born mobs that a cage can have in a 16 block radius before shutting off.");
        this.allowBossSpawns = this.config.getBoolean("allowBossSpawns", "balance", false, "Allows boss mobs to be spawned by cages. Some bosses (like the Ender Dragon) have custom logic which causes them to not work properly when spawned.");
        this.allowSpawnerAbsorption = this.config.getBoolean("allowSpawnerAbsorption", "balance", true, "Allow shards to absorb Mob Spawners of the same entity type.");
        this.absorptionBonus = this.config.getInt("absorptionBonus", "balance", 200, 0, Integer.MAX_VALUE, "The amount of souls to absorb from Mob Spawners.");
        this.dropExperience = this.config.getBoolean("dropExperience", "balance", true, "Mobs spawned via the cage will drop experience.");
        this.countCageBornForShard = this.config.getBoolean("countCageBornForShard", "balance", false, "Mobs spawned via the cage should count toward shard kills.");
        this.addShardResetRecipe = this.config.getBoolean("addShardResetRecipe", "balance", true, "Adds a shapeless recipe that allows shards to be reset fresh.");
        this.allowShardCombination = this.config.getBoolean("allowShardCombination", "balance", true, "Allows shards of the same entity to be combined in an anvil for a direct kill addition.");
        this.allowFakePlayers = this.config.getBoolean("allowFakePlayers", "balance", false, "Allows fake players to grow Shards in their inventories.");
        this.requireOwnerOnline = this.config.getBoolean("requireOwnerOnline", "server", false, "Requires the shard owner to be online. The owner is the first person to obtain a kill with the shard.");
        this.requireRedstoneSignal = this.config.getBoolean("requireRedstoneSignal", "server", false, "Requires a redstone signal to activate cages regardless of tier.");
        this.displayDurabilityBar = this.config.getBoolean("displayDurabilityBar", "client", true, "Displays a durability bar for how full the shard is compared to the max tier available.");
        this.explodeCreativeTab = this.config.getBoolean("explodeCreativeTab", "client", false, "Displays a shard for every enabled entity in the creative tab.");
        this.ignoreBlacklistForTab = this.config.getBoolean("ignoreBlacklistForTab", "client", false, "Adds blacklisted entities to the creative tab if \"explodeCreativeTab\" is true.");
        this.hwylaCompatibility = this.config.getBoolean("hwylaCompatibility", "compat", true, "Adds information regarding cage-born mobs and soul cages to HWYLA");
        for (ICompatibilityPlugin plugin : SoulShards.COMPAT_PLUGINS) {
            plugin.handleConfiguration(this.config);
        }
        this.config.save();
    }

    public void syncEntityList() {
        this.entityMap.clear();
        ForgeRegistries.ENTITIES.getEntries().stream().filter(e -> EntityLivingBase.class.isAssignableFrom(((EntityEntry)e.getValue()).getEntityClass())).forEach(e -> this.entityMap.put((ResourceLocation)e.getKey(), this.config.getBoolean(((ResourceLocation)e.getKey()).toString(), "entity_list", !DEFAULT_DISABLES.contains(((ResourceLocation)e.getKey()).toString()), "Allows the gathering and spawning of " + ((EntityEntry)e.getValue()).getName())));
        this.config.addCustomCategoryComment("entity_list", "Enabling boss mobs is not supported. If they work, great. If not, oh well.");
        this.config.save();
    }

    public void syncMultiblock() {
        File multiblockFile = new File(this.config.getConfigFile().getParent(), "multiblock.json");
        if (!multiblockFile.exists()) {
            try {
                FileUtils.copyInputStreamToFile((InputStream)ConfigHandler.class.getResourceAsStream("/assets/soulshardsrespawn/multiblock.json"), (File)multiblockFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.multiblockPattern = (MultiblockPattern)JsonUtil.fromJson(TypeToken.get(MultiblockPattern.class), multiblockFile);
        if (this.multiblockPattern == null) {
            this.multiblockPattern = MultiblockPattern.DEFAULT;
        }
    }

    public boolean isEntityEnabled(ResourceLocation entityId) {
        return this.entityMap.getOrDefault(entityId, false);
    }

    public boolean isEntityEnabled(Class<? extends Entity> entityClass) {
        return this.isEntityEnabled(EntityList.func_191306_a(entityClass));
    }

    public Configuration getConfig() {
        return this.config;
    }

    public Map<ResourceLocation, Boolean> getEntityMap() {
        return this.entityMap;
    }

    public int getSpawnCap() {
        return this.spawnCap;
    }

    public boolean allowBossSpawns() {
        return this.allowBossSpawns;
    }

    public boolean allowSpawnerAbsorption() {
        return this.allowSpawnerAbsorption;
    }

    public int getAbsorptionBonus() {
        return this.absorptionBonus;
    }

    public boolean dropExperience() {
        return this.dropExperience;
    }

    public boolean countCageBornForShard() {
        return this.countCageBornForShard;
    }

    public boolean addShardResetRecipe() {
        return this.addShardResetRecipe;
    }

    public boolean allowShardCombination() {
        return this.allowShardCombination;
    }

    public boolean allowFakePlayers() {
        return this.allowFakePlayers;
    }

    public MultiblockPattern getMultiblockPattern() {
        return this.multiblockPattern;
    }

    public boolean requireOwnerOnline() {
        return this.requireOwnerOnline;
    }

    public boolean requireRedstoneSignal() {
        return this.requireRedstoneSignal;
    }

    public boolean displayDurabilityBar() {
        return this.displayDurabilityBar;
    }

    public boolean explodeCreativeTab() {
        return this.explodeCreativeTab;
    }

    public boolean ignoreBlacklistForTab() {
        return this.ignoreBlacklistForTab;
    }

    public boolean hwylaCompatibility() {
        return this.hwylaCompatibility;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("soulshardsrespawn")) {
            this.syncConfig();
            this.syncEntityList();
            this.syncMultiblock();
        }
    }
}

