/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks.helper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import toast.lostBooks.LostBooks;
import toast.lostBooks.config.ConfigPropertyHelper;
import toast.lostBooks.helper.FileHelper;

public class InitConfig {
    public static void init() {
        if (ConfigPropertyHelper.getBoolean("general", "generateDefaultBookPackAtStart")) {
            try {
                LostBooks.console("Initializing config directory with the default books. Set 'generateDefaultBookPackAtStart' to False in lostbooks.cfg to disable this behaviour.");
                URL url = FileHelper.class.getClassLoader().getResource("assets/lostbooks/LostBooks");
                url = InitConfig.formatFileUrl2JarUrl(url);
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                InitConfig.copyJarResourceToFolder(jarURLConnection, new File(LostBooks.CONFIG_DIRECTORY, "/LostBooks"));
                LostBooks.console("Completed initializing config directory with the default books.");
            }
            catch (Exception e) {
                LostBooks.console("Failed to initialize the ConfigFileHelper. Please report the below error at the issue tracker (https://github.com/WinDanesz/LostBooks-II/issues)");
                e.printStackTrace();
            }
        } else {
            LostBooks.console("Skipping initialization of the default book pack as 'generateDefaultBookPackAtStart' was set to False.");
        }
    }

    public static void copyJarResourceToFolder(JarURLConnection jarConnection, File destDir) {
        try {
            JarFile jarFile = jarConnection.getJarFile();
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                String jarConnectionEntryName;
                JarEntry jarEntry = e.nextElement();
                String jarEntryName = jarEntry.getName();
                if (!jarEntryName.startsWith(jarConnectionEntryName = jarConnection.getEntryName())) continue;
                String filename = jarEntryName.startsWith(jarConnectionEntryName) ? jarEntryName.substring(jarConnectionEntryName.length()) : jarEntryName;
                File currentFile = new File(destDir, filename);
                if (jarEntry.isDirectory()) {
                    currentFile.mkdirs();
                    continue;
                }
                InputStream is = jarFile.getInputStream(jarEntry);
                FileOutputStream out = FileUtils.openOutputStream((File)currentFile);
                IOUtils.copy((InputStream)is, (OutputStream)out);
                is.close();
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            LostBooks.console("Failed to initialize the /config/LostBooks config directory with the default book pack!");
            e.printStackTrace();
        }
    }

    public static URL formatFileUrl2JarUrl(URL url) throws MalformedURLException {
        StringBuilder urlStr = new StringBuilder();
        urlStr.append(url.toString());
        return new URL(urlStr.toString());
    }
}

