/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks.book;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import toast.lostBooks.LostBooks;
import toast.lostBooks.book.BookCollection;
import toast.lostBooks.book.BookStats;
import toast.lostBooks.book.IBook;
import toast.lostBooks.book.LostBookCollection;
import toast.lostBooks.config.ConfigPropertyHelper;
import toast.lostBooks.helper.BookHelper;
import toast.lostBooks.helper.RandomHelper;

public abstract class Library {
    public static final char N = '\n';
    public static final char F = '\f';
    public static final char R = '\r';
    public static final char S = '\u00a7';
    public static final IBook UNIQUE_BOOKS = new BookCollection("unique", new File(LostBooks.CONFIG_DIRECTORY, "/LostBooks/unique"));
    public static final IBook COMMON_BOOKS = new BookCollection("common", new File(LostBooks.CONFIG_DIRECTORY, "/LostBooks/common"));
    public static final IBook AD_LIB_BOOKS = new BookCollection("adlib", new File(LostBooks.CONFIG_DIRECTORY, "/LostBooks/adLib"));
    public static final LostBookCollection LOST_BOOKS = new LostBookCollection("lost");
    public static final int UNIQUE_BOOK_COUNT = UNIQUE_BOOKS.size();

    public static ItemStack nextBook(EntityLivingBase entity) {
        IBook category = RandomHelper.choose(entity, UNIQUE_BOOKS, COMMON_BOOKS, AD_LIB_BOOKS, LOST_BOOKS);
        if (category != null) {
            ItemStack book = new ItemStack(Items.field_151164_bB);
            BookStats story = category.getBookStats(entity);
            if (category == UNIQUE_BOOKS) {
                if (story == null) {
                    category = RandomHelper.choose(entity, COMMON_BOOKS, AD_LIB_BOOKS, LOST_BOOKS);
                    if (category != null) {
                        story = category.getBookStats(entity);
                    }
                } else if (ConfigPropertyHelper.getBoolean("general", "markUnique")) {
                    BookHelper.addItemText(book, "\u00a79Unique");
                }
            }
            if (story != null) {
                story.writeTo(book);
                if (book.func_77942_o()) {
                    return book;
                }
            }
        }
        return null;
    }

    public static ItemStack nextSpawnBook(EntityPlayer player) {
        IBook category = RandomHelper.chooseSpawn(player, UNIQUE_BOOKS, COMMON_BOOKS, AD_LIB_BOOKS, LOST_BOOKS);
        if (category != null) {
            ItemStack book = new ItemStack(Items.field_151164_bB);
            BookStats story = category.getBookStatsSpawn(player);
            if (category == UNIQUE_BOOKS) {
                if (story == null) {
                    category = RandomHelper.chooseSpawn(player, COMMON_BOOKS, AD_LIB_BOOKS, LOST_BOOKS);
                    if (category != null) {
                        story = category.getBookStatsSpawn(player);
                    }
                } else if (ConfigPropertyHelper.getBoolean("general", "markUnique")) {
                    BookHelper.addItemText(book, "\u00a79Unique");
                }
            }
            if (story != null) {
                story.writeTo(book);
                if (book.func_77942_o()) {
                    return book;
                }
            }
        }
        return null;
    }

    public static ItemStack nextTradeBook(EntityLivingBase customer) {
        BookStats story;
        IBook category;
        ArrayList<IBook> tradeableBooks = new ArrayList<IBook>(4);
        tradeableBooks.add(COMMON_BOOKS);
        tradeableBooks.add(AD_LIB_BOOKS);
        if (ConfigPropertyHelper.getBoolean("trading", "sellUnique")) {
            tradeableBooks.add(UNIQUE_BOOKS);
        }
        if (ConfigPropertyHelper.getBoolean("trading", "sellLost")) {
            tradeableBooks.add(LOST_BOOKS);
        }
        if ((category = RandomHelper.chooseTrade(customer, tradeableBooks.toArray(new IBook[0]))) != null && (story = category.getBookStatsTrade(customer)) != null) {
            ItemStack book = story.writeTo(new ItemStack(Items.field_151164_bB));
            BookHelper.removeBookId(book);
            return book;
        }
        return null;
    }

    public static HashSet<String> getUniqueIds() {
        HashSet<String> ids = new HashSet<String>(UNIQUE_BOOK_COUNT);
        Library.addCollectionIds(ids, (BookCollection)UNIQUE_BOOKS);
        return ids;
    }

    private static void addCollectionIds(HashSet<String> ids, BookCollection collection) {
        for (IBook book : collection.books) {
            if (book instanceof BookCollection) {
                Library.addCollectionIds(ids, (BookCollection)book);
                continue;
            }
            ids.add(book.getId());
        }
    }
}

