/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks.book;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import toast.lostBooks.Blackouts;
import toast.lostBooks.book.BookCollection;
import toast.lostBooks.book.BookProperties;
import toast.lostBooks.book.IBook;
import toast.lostBooks.helper.BookHelper;

public class BookStats
implements IBook {
    public final String fileName;
    public final String bookId;
    public final String title;
    public final String author;
    public final String[] pages;
    public final int weight;
    public final ArrayList<Class> whitelist;
    public final ArrayList<Class> blacklist;
    public final boolean canBuy;
    public final HashSet<Integer> biomes;

    public BookStats(String name, String t, String a, String ... text) {
        this.fileName = name;
        this.bookId = null;
        this.title = t == null ? "Untitled" : t;
        this.author = a == null ? "Anonymous" : a;
        this.pages = text == null ? new String[]{} : text;
        this.weight = 100;
        this.whitelist = null;
        this.blacklist = null;
        this.canBuy = true;
        this.biomes = null;
    }

    public BookStats(BookCollection parentCollection, File file, BookProperties properties, boolean unique, String t, String a, String ... text) {
        this.fileName = file.getName();
        this.bookId = unique ? parentCollection.getId() + this.fileName.substring(0, this.fileName.length() - 5) : null;
        this.title = t == null ? "Untitled" : t;
        this.author = a == null ? "Anonymous" : a;
        this.pages = text == null ? new String[]{} : text;
        ArrayList<Class> whitelistDefault = parentCollection.whitelist;
        ArrayList<Class> blacklistDefault = parentCollection.blacklist;
        boolean canBuyDefault = parentCollection.canBuy;
        HashSet<Integer> biomesDefault = parentCollection.biomes;
        if (properties != null) {
            this.weight = Math.max(0, properties.getInt("weight", 100));
            this.whitelist = properties.getEntityList("whitelist", whitelistDefault);
            this.blacklist = properties.getEntityList("blacklist", blacklistDefault);
            this.canBuy = properties.getBoolean("can_buy", canBuyDefault);
            this.biomes = properties.getIdSet("biomes", biomesDefault);
        } else {
            this.weight = 100;
            this.whitelist = whitelistDefault;
            this.blacklist = blacklistDefault;
            this.canBuy = canBuyDefault;
            this.biomes = biomesDefault;
        }
    }

    public ItemStack writeTo(ItemStack book) {
        BookHelper.setTitleAndAuthor(book, this.bookId, this.title, this.author);
        int y = 0;
        for (String page : this.pages) {
            JsonObject json = new JsonObject();
            json.addProperty("text", page);
            this.pages[y] = new Gson().toJson((JsonElement)json);
            ++y;
        }
        BookHelper.setPages(book, this.pages);
        return book;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public String getId() {
        return this.bookId;
    }

    @Override
    public BookStats getBookStats(EntityLivingBase entity) {
        if (this.bookId != null && Blackouts.DROP_BLACKOUTS && Blackouts.ADAPTIVE_DROPS && BookHelper.getBlackouts(entity.field_70170_p).isBlackedOut(this.bookId)) {
            return null;
        }
        return this;
    }

    @Override
    public BookStats getBookStatsSpawn(EntityPlayer player) {
        if (this.bookId != null && Blackouts.DROP_BLACKOUTS && Blackouts.ADAPTIVE_DROPS && BookHelper.isBookFound(player, this.bookId)) {
            return null;
        }
        return this;
    }

    @Override
    public BookStats getBookStatsTrade(EntityLivingBase entity) {
        return this;
    }

    @Override
    public boolean isValid(EntityLivingBase entity) {
        if (this.bookId != null && Blackouts.DROP_BLACKOUTS && !Blackouts.ADAPTIVE_DROPS && BookHelper.getBlackouts(entity.field_70170_p).isBlackedOut(this.bookId)) {
            return false;
        }
        return this.getWeight() > 0 && BookHelper.canBookDrop(entity, this.whitelist, this.blacklist, this.biomes);
    }

    @Override
    public boolean isValidSpawn(EntityPlayer player) {
        if (this.bookId != null && Blackouts.DROP_BLACKOUTS && !Blackouts.ADAPTIVE_DROPS && BookHelper.isBookFound(player, this.bookId)) {
            return false;
        }
        return this.getWeight() > 0;
    }

    @Override
    public boolean isValidTrade(EntityLivingBase entity) {
        return this.canBuy && this.getWeight() > 0;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public int size() {
        return 1;
    }
}

