/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks.book;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import toast.lostBooks.book.BookProperties;
import toast.lostBooks.book.BookStats;
import toast.lostBooks.book.IBook;
import toast.lostBooks.config.ConfigPropertyHelper;
import toast.lostBooks.helper.FileHelper;
import toast.lostBooks.helper.RandomHelper;

public class BookCollection
implements IBook {
    public final String fileName;
    public final String bookId;
    public final String categoryId;
    public final IBook[] books;
    public final int weight;
    public final ArrayList<Class> whitelist;
    public final ArrayList<Class> blacklist;
    public final boolean canBuy;
    public final boolean inOrder;
    public final HashSet<Integer> biomes;

    public BookCollection() {
        this.fileName = "dummy";
        this.bookId = null;
        this.categoryId = "dummy";
        this.weight = -1;
        this.whitelist = null;
        this.blacklist = null;
        this.canBuy = true;
        this.inOrder = false;
        this.biomes = null;
        this.books = new IBook[0];
    }

    public BookCollection(String category, File folder) {
        this.fileName = folder.getName();
        this.bookId = category == "unique" ? "" : null;
        this.categoryId = category;
        this.weight = -1;
        this.whitelist = null;
        this.blacklist = null;
        this.canBuy = true;
        this.inOrder = category == "unique";
        this.biomes = null;
        this.books = FileHelper.loadCollection(category, this, folder);
    }

    public BookCollection(String category, BookCollection parentCollection, File folder, BookProperties properties) {
        this.fileName = folder.getName();
        this.bookId = category == "unique" ? parentCollection.getId() + this.fileName + "/" : null;
        this.categoryId = null;
        ArrayList<Class> whitelistDefault = parentCollection.whitelist;
        ArrayList<Class> blacklistDefault = parentCollection.blacklist;
        boolean canBuyDefault = parentCollection.canBuy;
        boolean inOrderDefault = parentCollection.inOrder;
        HashSet<Integer> biomesDefault = parentCollection.biomes;
        if (properties != null) {
            this.weight = Math.max(0, properties.getInt("weight", 100));
            this.whitelist = properties.getEntityList("whitelist", whitelistDefault);
            this.blacklist = properties.getEntityList("blacklist", blacklistDefault);
            this.canBuy = properties.getBoolean("can_buy", canBuyDefault);
            this.inOrder = category == "unique" && properties.getBoolean("in_order", inOrderDefault);
            this.biomes = properties.getIdSet("biomes", biomesDefault);
        } else {
            this.weight = 100;
            this.whitelist = whitelistDefault;
            this.blacklist = blacklistDefault;
            this.canBuy = canBuyDefault;
            this.inOrder = category == "unique" && inOrderDefault;
            this.biomes = biomesDefault;
        }
        this.books = FileHelper.loadCollection(category, this, folder);
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public String getId() {
        return this.bookId;
    }

    @Override
    public BookStats getBookStats(EntityLivingBase entity) {
        IBook book;
        if (this.inOrder) {
            // empty if block
        }
        return (book = RandomHelper.choose(entity, this.books)) == null ? null : book.getBookStats(entity);
    }

    @Override
    public BookStats getBookStatsSpawn(EntityPlayer player) {
        IBook book;
        if (this.inOrder) {
            // empty if block
        }
        return (book = RandomHelper.chooseSpawn(player, this.books)) == null ? null : book.getBookStatsSpawn(player);
    }

    @Override
    public BookStats getBookStatsTrade(EntityLivingBase entity) {
        IBook book = RandomHelper.chooseTrade(entity, this.books);
        return book == null ? null : book.getBookStatsTrade(entity);
    }

    @Override
    public boolean isValid(EntityLivingBase entity) {
        for (IBook book : this.books) {
            if (book == null || !book.isValid(entity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidSpawn(EntityPlayer player) {
        for (IBook book : this.books) {
            if (book == null || !book.isValidSpawn(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidTrade(EntityLivingBase entity) {
        for (IBook book : this.books) {
            if (book == null || !book.isValidTrade(entity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getWeight() {
        if (this.categoryId == null) {
            return this.weight;
        }
        return ConfigPropertyHelper.getInt("general", this.categoryId + "BookWeight");
    }

    @Override
    public int size() {
        int size = 0;
        for (IBook book : this.books) {
            if (book == null) continue;
            size += book.size();
        }
        return size;
    }
}

