/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks;

import java.util.HashMap;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import toast.lostBooks.Blackouts;

public class TickHandler {
    private static final HashMap<World, Blackouts> blackoutCache = new HashMap();
    private static byte updateTicks = (byte)-128;

    public static Blackouts getOrCreateBlackouts(World world) {
        Blackouts blackouts = blackoutCache.get(world);
        if (blackouts == null) {
            blackouts = new Blackouts(world);
            blackoutCache.put(world, blackouts);
        }
        return blackouts;
    }

    public static void unloadBlackouts() {
        blackoutCache.clear();
    }

    public static void unloadBlackouts(World world) {
        blackoutCache.remove(world);
    }

    public TickHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID() == "lostbooks") {
            // empty if block
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && (updateTicks = (byte)(updateTicks + 1)) == 127) {
            updateTicks = (byte)-128;
            TickHandler.unloadBlackouts();
        }
    }
}

