/*
 * Decompiled with CFR 0.152.
 */
package toast.lostBooks;

import java.io.File;
import java.util.Random;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLModDisabledEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import toast.lostBooks.MessageCurrPage;
import toast.lostBooks.TickHandler;
import toast.lostBooks.book.CommonProxy;
import toast.lostBooks.book.Library;
import toast.lostBooks.command.CommandBlackouts;
import toast.lostBooks.config.ConfigPropertyHelper;
import toast.lostBooks.helper.AdLibHelper;
import toast.lostBooks.helper.FileHelper;
import toast.lostBooks.helper.InitConfig;

@Mod(modid="lostbooks", name="Lost Books II", version="2.0.3", acceptedMinecraftVersions="[1.12.2]", updateJSON="https://raw.githubusercontent.com/WinDanesz/LostBooks-II/1.12.2/.forge/update.json")
public class LostBooks {
    public static final String NAME = "Lost Books II";
    public static final String MODID = "lostbooks";
    public static final String VERSION = "2.0.3";
    public static final String MC_VERSION = "[1.12.2]";
    public static final String UPDATE_JSON = "https://raw.githubusercontent.com/WinDanesz/LostBooks-II/1.12.2/.forge/update.json";
    public static final boolean debug = false;
    public static final Random random = new Random();
    public static SimpleNetworkWrapper CHANNEL;
    public static boolean DISABLED;
    public static File CONFIG_DIRECTORY;
    public static Configuration CONFIG;
    @SidedProxy(clientSide="toast.lostBooks.client.ClientProxy", serverSide="toast.lostBooks.book.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LostBooks.debugConsole("Loading in debug mode!");
        CONFIG_DIRECTORY = event.getModConfigurationDirectory();
        LostBooks.debugConsole("configpath? " + event.getModConfigurationDirectory().getPath());
        CONFIG = new Configuration(event.getSuggestedConfigurationFile());
        ConfigPropertyHelper.init(CONFIG);
        CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("LB|CP");
        CHANNEL.registerMessage(MessageCurrPage.Handler.class, MessageCurrPage.class, 0, Side.SERVER);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        InitConfig.init();
        proxy.registerVillagerTrades();
        new TickHandler();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LostBooks.console("Loading books...");
        LostBooks.console("Loaded " + Library.UNIQUE_BOOK_COUNT + " unique books, " + Library.COMMON_BOOKS.size() + " common books, and " + Library.AD_LIB_BOOKS.size() + " adlib books!");
        AdLibHelper.init();
    }

    @Mod.EventHandler
    public void disable(FMLModDisabledEvent event) {
        DISABLED = true;
        LostBooks.debugConsole("DISABLED!");
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        FileHelper.init(event.getServer());
        event.registerServerCommand((ICommand)new CommandBlackouts());
    }

    public static void console(String message) {
        System.out.println("[LostBooks] " + message);
    }

    public static void debugConsole(String message) {
    }

    public static void exception(String message) {
        throw new RuntimeException("[LostBooks] " + message);
    }

    public static void debugException(String message) {
    }

    static {
        DISABLED = false;
    }
}

