/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.nyx.items;

import com.google.common.collect.Streams;
import de.ellpeck.nyx.capabilities.NyxWorld;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MeteorFinder
extends Item {
    public MeteorFinder() {
        this.func_185043_a(new ResourceLocation("angle"), new IItemPropertyGetter(){
            @SideOnly(value=Side.CLIENT)
            double rotation;
            @SideOnly(value=Side.CLIENT)
            double rota;
            @SideOnly(value=Side.CLIENT)
            long lastUpdateTick;
            @SideOnly(value=Side.CLIENT)
            BlockPos meteorPos;

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                EntityLivingBase entity;
                if (entityIn == null && !stack.func_82839_y()) {
                    return 0.0f;
                }
                boolean flag = entityIn != null;
                Object object = entity = flag ? entityIn : stack.func_82836_z();
                if (worldIn == null) {
                    worldIn = entity.field_70170_p;
                }
                double d1 = flag ? (double)entity.field_70177_z : this.getFrameRotation((EntityItemFrame)entity);
                d1 = MathHelper.func_191273_b((double)(d1 / 360.0), (double)1.0);
                double d2 = this.getSpawnToAngle(worldIn, (Entity)entity) / (Math.PI * 2);
                double d0 = Double.isNaN(d2) ? Math.random() : 0.5 - (d1 - 0.25 - d2);
                if (flag) {
                    d0 = this.wobble(worldIn, d0);
                }
                return MathHelper.func_188207_b((float)((float)d0), (float)1.0f);
            }

            @SideOnly(value=Side.CLIENT)
            private double wobble(World worldIn, double d) {
                if (worldIn.func_82737_E() != this.lastUpdateTick) {
                    this.lastUpdateTick = worldIn.func_82737_E();
                    double d0 = d - this.rotation;
                    d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rota), (double)1.0);
                }
                return this.rotation;
            }

            @SideOnly(value=Side.CLIENT)
            private double getFrameRotation(EntityItemFrame frame) {
                return MathHelper.func_188209_b((int)(180 + frame.field_174860_b.func_176736_b() * 90));
            }

            @SideOnly(value=Side.CLIENT)
            private double getSpawnToAngle(World world, Entity e) {
                if (this.meteorPos == null || world.func_82737_E() % 100L == 0L) {
                    NyxWorld data = NyxWorld.get(world);
                    if (data == null || data.meteorLandingSites.isEmpty()) {
                        return Double.NaN;
                    }
                    this.meteorPos = (BlockPos)Streams.concat((Stream[])new Stream[]{data.meteorLandingSites.stream(), data.cachedMeteorPositions.stream()}).min((p1, p2) -> MathHelper.func_76128_c((double)(e.func_174818_b(p1) - e.func_174818_b(p2)))).get();
                }
                if (this.meteorPos == null) {
                    return Double.NaN;
                }
                return Math.atan2((double)this.meteorPos.func_177952_p() - e.field_70161_v, (double)this.meteorPos.func_177958_n() - e.field_70165_t);
            }
        });
    }
}

