/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.nyx.items;

import de.ellpeck.nyx.Registry;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class LunarWaterBottle
extends Item {
    public LunarWaterBottle() {
        Registry.initItem(this, "lunar_water_bottle");
        this.func_77625_d(1);
    }

    public static boolean applyLunarWater(EntityLivingBase entity) {
        boolean did = false;
        HashSet<Potion> effectsToRemove = new HashSet<Potion>();
        for (PotionEffect effect : entity.func_70651_bq()) {
            Potion potion = effect.func_188419_a();
            if (!potion.func_76398_f()) continue;
            effectsToRemove.add(potion);
            did = true;
        }
        effectsToRemove.forEach(arg_0 -> ((EntityLivingBase)entity).func_184589_d(arg_0));
        if (entity.func_70660_b(MobEffects.field_76428_l) == null) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100, 1));
            did = true;
        }
        return did;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        EntityPlayer player;
        if (!worldIn.field_72995_K) {
            LunarWaterBottle.applyLunarWater(entityLiving);
        }
        EntityPlayer entityPlayer = player = entityLiving instanceof EntityPlayer ? (EntityPlayer)entityLiving : null;
        if (player == null || !player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                return new ItemStack(Items.field_151069_bo);
            }
            if (player != null) {
                player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new BucketWrapper(stack);
    }

    private static class BucketWrapper
    extends FluidBucketWrapper {
        private static final int VOLUME = 250;

        public BucketWrapper(ItemStack container) {
            super(container);
        }

        public IFluidTankProperties[] getTankProperties() {
            return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), 250)};
        }

        public FluidStack getFluid() {
            if (this.container.func_77973_b() == Registry.lunarWaterBottle) {
                return new FluidStack(Registry.lunarWaterFluid, 250);
            }
            return null;
        }

        protected void setFluid(@Nullable Fluid fluid) {
            this.setFluid(new FluidStack(fluid, 250));
        }

        protected void setFluid(@Nullable FluidStack fluidStack) {
            this.container = fluidStack == null ? new ItemStack(Items.field_151069_bo) : new ItemStack(Registry.lunarWaterBottle);
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (this.container.func_190916_E() != 1 || resource == null || resource.amount < 250 || this.getFluid() != null || !this.canFillFluidType(resource)) {
                return 0;
            }
            if (doFill) {
                this.setFluid(resource);
            }
            return 1000;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (this.container.func_190916_E() != 1 || resource == null || resource.amount < 250) {
                return null;
            }
            FluidStack fluidStack = this.getFluid();
            if (fluidStack != null && fluidStack.isFluidEqual(resource)) {
                if (doDrain) {
                    this.setFluid((FluidStack)null);
                }
                return fluidStack;
            }
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (this.container.func_190916_E() != 1 || maxDrain < 250) {
                return null;
            }
            FluidStack fluidStack = this.getFluid();
            if (fluidStack != null) {
                if (doDrain) {
                    this.setFluid((FluidStack)null);
                }
                return fluidStack;
            }
            return null;
        }
    }
}

