/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.nyx.entities;

import de.ellpeck.nyx.Registry;
import de.ellpeck.nyx.capabilities.NyxWorld;
import de.ellpeck.nyx.entities.FallingStar;
import de.ellpeck.nyx.lunarevents.HarvestMoon;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FallingMeteor
extends FallingStar {
    public static final DataParameter<Integer> SIZE = EntityDataManager.func_187226_a(FallingMeteor.class, (DataSerializer)DataSerializers.field_187192_b);
    public boolean homing;
    public boolean disableMessage;
    public float speedModifier;
    public boolean spawnNoBlocks;

    public FallingMeteor(World worldIn) {
        super(worldIn);
        this.field_70180_af.func_187227_b(SIZE, (Object)(worldIn.field_73012_v.nextInt(3) + 1));
        this.initTrajectory(2.0f * this.speedModifier);
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SIZE, (Object)1);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if ((Integer)this.field_70180_af.func_187225_a(SIZE) <= 0) {
            this.field_70180_af.func_187227_b(SIZE, (Object)2);
        }
        if (this.speedModifier <= 0.0f) {
            this.speedModifier = 1.0f;
        }
        if (this.trajectoryX == 0.0f && this.trajectoryY == 0.0f && this.trajectoryZ == 0.0f) {
            this.initTrajectory(2.0f * this.speedModifier);
        }
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        if (this.homing) {
            y += 48.0;
        }
        super.func_70012_b(x, y, z, yaw, pitch);
    }

    @Override
    protected void customUpdate() {
        block17: {
            block15: {
                block16: {
                    EntityPlayer player;
                    if (this.field_70170_p.field_72995_K) break block15;
                    if (this.field_70163_u <= -64.0) {
                        this.func_70106_y();
                    }
                    if (this.homing && (player = this.field_70170_p.func_184137_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 128.0, false)) != null && player.func_70068_e((Entity)this) >= 1024.0) {
                        Vec3d motion = new Vec3d(player.field_70165_t - this.field_70165_t, player.field_70163_u - this.field_70163_u, player.field_70161_v - this.field_70161_v);
                        motion = motion.func_72432_b();
                        this.trajectoryX = (float)motion.field_72450_a * 2.0f * this.speedModifier;
                        if (motion.field_72448_b < 0.0) {
                            this.trajectoryY = (float)motion.field_72448_b * 2.0f * this.speedModifier;
                        }
                        this.trajectoryZ = (float)motion.field_72449_c * 2.0f * this.speedModifier;
                    }
                    if (!this.field_70132_H) break block16;
                    if (this.removeTrees(this.func_180425_c())) {
                        return;
                    }
                    NyxWorld data = NyxWorld.get(this.field_70170_p);
                    Explosion exp = this.field_70170_p.func_72876_a(null, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, (float)((Integer)this.field_70180_af.func_187225_a(SIZE) * 4), true);
                    if (!this.spawnNoBlocks) {
                        for (BlockPos affected : exp.func_180343_e()) {
                            if (!this.field_70170_p.func_180495_p(affected).func_177230_c().func_176200_f((IBlockAccess)this.field_70170_p, affected) || !this.field_70170_p.func_180495_p(affected.func_177977_b()).func_185913_b() || this.field_70170_p.field_73012_v.nextInt(2) != 0) continue;
                            if (this.field_70170_p.field_73012_v.nextInt(5) == 0) {
                                this.field_70170_p.func_175656_a(affected, Blocks.field_189877_df.func_176223_P());
                                continue;
                            }
                            if (data.currentEvent instanceof HarvestMoon && this.field_70170_p.field_73012_v.nextInt(10) == 0) {
                                this.field_70170_p.func_175656_a(affected, Registry.gleaningMeteorRock.func_176223_P());
                            } else {
                                this.field_70170_p.func_175656_a(affected, Registry.meteorRock.func_176223_P());
                            }
                            data.meteorLandingSites.add(affected);
                        }
                    }
                    data.sendToClients();
                    this.func_70106_y();
                    if (this.disableMessage) break block17;
                    ITextComponent text = new TextComponentTranslation("info.nyx.meteor", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(true)));
                    for (EntityPlayer player2 : this.field_70170_p.field_73010_i) {
                        float pitch;
                        SoundEvent sound;
                        double dist = player2.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        if (dist <= 65536.0) {
                            if (dist > 256.0) {
                                player2.func_145747_a(text);
                            }
                            sound = SoundEvents.field_187539_bB;
                            pitch = 0.15f;
                        } else {
                            sound = Registry.fallingMeteorImpactSound;
                            pitch = 1.0f;
                        }
                        if (!(player2 instanceof EntityPlayerMP) || player2.field_71093_bK != this.field_70170_p.field_73011_w.getDimension()) continue;
                        ((EntityPlayerMP)player2).field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(sound, SoundCategory.AMBIENT, player2.field_70165_t, player2.field_70163_u, player2.field_70161_v, 0.5f, pitch));
                    }
                    break block17;
                }
                if (this.field_70170_p.func_82737_E() % 35L != 0L) break block17;
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, Registry.fallingMeteorSound, SoundCategory.AMBIENT, 5.0f, 1.0f);
                break block17;
            }
            if (this.isLoaded()) {
                float size = (float)((Integer)this.field_70180_af.func_187225_a(SIZE)).intValue() / 2.0f + 1.0f;
                for (int i = 0; i < 60; ++i) {
                    double x = this.field_70165_t + MathHelper.func_82716_a((Random)this.field_70170_p.field_73012_v, (double)(-size), (double)size);
                    double y = this.field_70163_u + MathHelper.func_82716_a((Random)this.field_70170_p.field_73012_v, (double)(-size), (double)size);
                    double z = this.field_70161_v + MathHelper.func_82716_a((Random)this.field_70170_p.field_73012_v, (double)(-size), (double)size);
                    double mX = -this.field_70159_w + this.field_70170_p.field_73012_v.nextGaussian() * 0.02;
                    double mY = -this.field_70181_x + this.field_70170_p.field_73012_v.nextGaussian() * 0.02;
                    double mZ = -this.field_70179_y + this.field_70170_p.field_73012_v.nextGaussian() * 0.02;
                    float f = this.field_70170_p.field_73012_v.nextFloat();
                    EnumParticleTypes type = f >= 0.65f ? EnumParticleTypes.FLAME : (f >= 0.45f ? EnumParticleTypes.LAVA : (f >= 0.3f ? EnumParticleTypes.SMOKE_NORMAL : EnumParticleTypes.SMOKE_LARGE));
                    this.field_70170_p.func_175682_a(type, true, x, y, z, mX, mY, mZ, new int[0]);
                }
            }
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("size", ((Integer)this.field_70180_af.func_187225_a(SIZE)).intValue());
        compound.func_74757_a("homing", this.homing);
        compound.func_74757_a("disable_message", this.disableMessage);
        compound.func_74776_a("speed", this.speedModifier);
        compound.func_74757_a("spawn_no_blocks", this.spawnNoBlocks);
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(SIZE, (Object)compound.func_74762_e("size"));
        this.homing = compound.func_74767_n("homing");
        this.disableMessage = compound.func_74767_n("disable_message");
        this.speedModifier = compound.func_74760_g("speed");
        this.spawnNoBlocks = compound.func_74767_n("spawn_no_blocks");
    }

    private boolean removeTrees(BlockPos pos) {
        boolean any = false;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    IBlockState state;
                    BlockPos offset = pos.func_177982_a(x, y, z);
                    if (offset.func_177954_c(this.field_70165_t, this.field_70163_u, this.field_70161_v) >= 64.0 || !(state = this.field_70170_p.func_180495_p(offset)).func_177230_c().isLeaves(state, (IBlockAccess)this.field_70170_p, offset) && !state.func_177230_c().isWood((IBlockAccess)this.field_70170_p, offset)) continue;
                    this.field_70170_p.func_175698_g(offset);
                    this.removeTrees(offset);
                    any = true;
                }
            }
        }
        return any;
    }

    public static FallingMeteor spawn(World world, BlockPos pos) {
        pos = world.func_175725_q(pos).func_177981_b(MathHelper.func_76136_a((Random)world.field_73012_v, (int)64, (int)96));
        FallingMeteor meteor = new FallingMeteor(world);
        meteor.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        world.func_72838_d((Entity)meteor);
        return meteor;
    }
}

