/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.nyx.capabilities;

import de.ellpeck.nyx.Config;
import de.ellpeck.nyx.Registry;
import de.ellpeck.nyx.lunarevents.BloodMoon;
import de.ellpeck.nyx.lunarevents.FullMoon;
import de.ellpeck.nyx.lunarevents.HarvestMoon;
import de.ellpeck.nyx.lunarevents.LunarEvent;
import de.ellpeck.nyx.lunarevents.StarShower;
import de.ellpeck.nyx.network.PacketHandler;
import de.ellpeck.nyx.network.PacketNyxWorld;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import org.apache.commons.lang3.mutable.MutableInt;

public class NyxWorld
implements ICapabilityProvider,
INBTSerializable<NBTTagCompound> {
    public static float moonPhase;
    public final World world;
    public final List<LunarEvent> lunarEvents = new ArrayList<LunarEvent>();
    public final Set<BlockPos> cachedMeteorPositions = new HashSet<BlockPos>();
    public final Map<ChunkPos, MutableInt> playersPresentTicks = new HashMap<ChunkPos, MutableInt>();
    public final Set<BlockPos> meteorLandingSites = new HashSet<BlockPos>();
    public final Set<String> visitedDimensions = new HashSet<String>();
    public float eventSkyModifier;
    public int currentSkyColor;
    public LunarEvent currentEvent;
    public LunarEvent forcedEvent;
    private boolean wasDaytime;

    public NyxWorld(World world) {
        this.world = world;
        this.lunarEvents.add(new HarvestMoon(this));
        this.lunarEvents.add(new StarShower(this));
        this.lunarEvents.add(new BloodMoon(this));
        this.lunarEvents.add(new FullMoon(this));
    }

    public void update() {
        String dimension;
        if (!this.world.field_72995_K) {
            if (this.world.func_82737_E() % 200L == 0L) {
                for (EntityPlayer player : this.world.func_73046_m().func_184103_al().func_181057_v()) {
                    this.visitedDimensions.add(player.field_70170_p.field_73011_w.func_186058_p().func_186065_b());
                }
            }
            int interval = 100;
            if (Config.meteors && this.world.func_82737_E() % (long)interval == 0L) {
                HashSet<ChunkPos> remaining = new HashSet<ChunkPos>(this.playersPresentTicks.keySet());
                for (EntityPlayer player : this.world.field_73010_i) {
                    for (int x = -Config.meteorDisallowRadius; x <= Config.meteorDisallowRadius; ++x) {
                        for (int z = -Config.meteorDisallowRadius; z <= Config.meteorDisallowRadius; ++z) {
                            ChunkPos pos = new ChunkPos(MathHelper.func_76128_c((double)(player.field_70165_t / 16.0)) + x, MathHelper.func_76128_c((double)(player.field_70161_v / 16.0)) + z);
                            MutableInt time = this.playersPresentTicks.computeIfAbsent(pos, p -> new MutableInt());
                            time.add(interval);
                            remaining.remove(pos);
                        }
                    }
                }
                if (remaining.size() > 0) {
                    Iterator iterator = remaining.iterator();
                    while (iterator.hasNext()) {
                        ChunkPos pos = (ChunkPos)iterator.next();
                        MutableInt time = this.playersPresentTicks.get(pos);
                        time.subtract(interval);
                        if (time.intValue() > 0) continue;
                        this.playersPresentTicks.remove(pos);
                    }
                }
            }
        }
        if (Config.allowedDimensions.contains(dimension = this.world.field_73011_w.func_186058_p().func_186065_b())) {
            moonPhase = this.world.func_130001_d();
            for (LunarEvent lunarEvent : this.lunarEvents) {
                lunarEvent.update(this.wasDaytime);
            }
            if (!this.world.field_72995_K) {
                boolean isDirty = false;
                if (this.currentEvent == null) {
                    if (this.forcedEvent != null && this.forcedEvent.shouldStart(this.wasDaytime)) {
                        this.currentEvent = this.forcedEvent;
                        this.forcedEvent = null;
                    } else {
                        for (LunarEvent event : this.lunarEvents) {
                            if (!event.shouldStart(this.wasDaytime)) continue;
                            this.currentEvent = event;
                            break;
                        }
                    }
                    if (this.currentEvent != null) {
                        isDirty = true;
                        if (Config.eventNotifications) {
                            ITextComponent iTextComponent = this.currentEvent.getStartMessage();
                            for (EntityPlayer player : this.world.field_73010_i) {
                                player.func_145747_a(iTextComponent);
                            }
                        }
                    }
                }
                if (this.currentEvent != null && this.currentEvent.shouldStop(this.wasDaytime)) {
                    this.currentEvent = null;
                    isDirty = true;
                }
                if (isDirty) {
                    this.sendToClients();
                }
                this.wasDaytime = NyxWorld.isDaytime(this.world);
            } else if (this.currentEvent != null && this.currentSkyColor != 0) {
                if (this.eventSkyModifier < 1.0f) {
                    this.eventSkyModifier += 0.01f;
                }
            } else if (this.eventSkyModifier > 0.0f) {
                this.eventSkyModifier -= 0.01f;
            }
        }
    }

    public void sendToClients() {
        for (EntityPlayer player : this.world.field_73010_i) {
            PacketHandler.sendTo(player, new PacketNyxWorld(this));
        }
    }

    public NBTTagCompound serializeNBT() {
        return this.serializeNBT(false);
    }

    public NBTTagCompound serializeNBT(boolean client) {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.currentEvent != null) {
            compound.func_74778_a("event", this.currentEvent.name);
        }
        compound.func_74757_a("was_daytime", this.wasDaytime);
        for (LunarEvent lunarEvent : this.lunarEvents) {
            compound.func_74782_a(lunarEvent.name, (NBTBase)lunarEvent.serializeNBT());
        }
        NBTTagList landings = new NBTTagList();
        for (BlockPos blockPos : this.meteorLandingSites) {
            landings.func_74742_a((NBTBase)new NBTTagLong(blockPos.func_177986_g()));
        }
        compound.func_74782_a("meteor_landings", (NBTBase)landings);
        NBTTagList nBTTagList = new NBTTagList();
        for (BlockPos blockPos : this.cachedMeteorPositions) {
            nBTTagList.func_74742_a((NBTBase)new NBTTagLong(blockPos.func_177986_g()));
        }
        compound.func_74782_a("cached_meteors", (NBTBase)nBTTagList);
        if (!client) {
            NBTTagList nBTTagList2 = new NBTTagList();
            for (Map.Entry<ChunkPos, MutableInt> entry : this.playersPresentTicks.entrySet()) {
                NBTTagCompound comp = new NBTTagCompound();
                comp.func_74768_a("x", entry.getKey().field_77276_a);
                comp.func_74768_a("z", entry.getKey().field_77275_b);
                comp.func_74768_a("ticks", entry.getValue().intValue());
                nBTTagList2.func_74742_a((NBTBase)comp);
            }
            compound.func_74782_a("players_present_ticks", (NBTBase)nBTTagList2);
            NBTTagList nBTTagList3 = new NBTTagList();
            for (String dim : this.visitedDimensions) {
                nBTTagList3.func_74742_a((NBTBase)new NBTTagString(dim));
            }
            compound.func_74782_a("visited_dims", (NBTBase)nBTTagList3);
        }
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.deserializeNBT(compound, false);
    }

    public void deserializeNBT(NBTTagCompound compound, boolean client) {
        String name = compound.func_74779_i("event");
        this.currentEvent = this.lunarEvents.stream().filter(e -> e.name.equals(name)).findFirst().orElse(null);
        if (this.currentEvent != null) {
            this.currentSkyColor = this.currentEvent.getSkyColor();
        }
        this.wasDaytime = compound.func_74767_n("was_daytime");
        for (LunarEvent event : this.lunarEvents) {
            event.deserializeNBT(compound.func_74775_l(event.name));
        }
        this.meteorLandingSites.clear();
        NBTTagList landings = compound.func_150295_c("meteor_landings", 4);
        for (int i = 0; i < landings.func_74745_c(); ++i) {
            this.meteorLandingSites.add(BlockPos.func_177969_a((long)((NBTTagLong)landings.func_179238_g(i)).func_150291_c()));
        }
        this.cachedMeteorPositions.clear();
        NBTTagList meteors = compound.func_150295_c("cached_meteors", 4);
        for (int i = 0; i < meteors.func_74745_c(); ++i) {
            this.cachedMeteorPositions.add(BlockPos.func_177969_a((long)((NBTTagLong)meteors.func_179238_g(i)).func_150291_c()));
        }
        if (!client) {
            this.playersPresentTicks.clear();
            NBTTagList ticks = compound.func_150295_c("players_present_ticks", 10);
            for (int i = 0; i < ticks.func_74745_c(); ++i) {
                NBTTagCompound comp = ticks.func_150305_b(i);
                this.playersPresentTicks.put(new ChunkPos(comp.func_74762_e("x"), comp.func_74762_e("z")), new MutableInt(comp.func_74762_e("ticks")));
            }
            this.visitedDimensions.clear();
            NBTTagList dimensions = compound.func_150295_c("visited_dims", 8);
            for (int i = 0; i < dimensions.func_74745_c(); ++i) {
                this.visitedDimensions.add(((NBTTagString)dimensions.func_179238_g(i)).func_150285_a_());
            }
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == Registry.worldCapability;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == Registry.worldCapability ? this : null);
    }

    public static boolean isDaytime(World world) {
        long time = world.func_72820_D() % 24000L;
        return time < 12541L || time >= 23458L;
    }

    public static NyxWorld get(World world) {
        if (world.hasCapability(Registry.worldCapability, null)) {
            return (NyxWorld)world.getCapability(Registry.worldCapability, null);
        }
        return null;
    }
}

