/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.nyx;

import de.ellpeck.nyx.Config;
import de.ellpeck.nyx.Nyx;
import de.ellpeck.nyx.blocks.Crystal;
import de.ellpeck.nyx.blocks.Glass;
import de.ellpeck.nyx.blocks.LunarWater;
import de.ellpeck.nyx.blocks.LunarWaterCauldron;
import de.ellpeck.nyx.blocks.LunarWaterFluid;
import de.ellpeck.nyx.blocks.MeteorRock;
import de.ellpeck.nyx.blocks.NyxSlab;
import de.ellpeck.nyx.blocks.NyxStairs;
import de.ellpeck.nyx.blocks.StarAir;
import de.ellpeck.nyx.capabilities.NyxWorld;
import de.ellpeck.nyx.enchantments.LunarEdge;
import de.ellpeck.nyx.enchantments.LunarShield;
import de.ellpeck.nyx.entities.CauldronTracker;
import de.ellpeck.nyx.entities.FallingMeteor;
import de.ellpeck.nyx.entities.FallingStar;
import de.ellpeck.nyx.items.Axe;
import de.ellpeck.nyx.items.Bow;
import de.ellpeck.nyx.items.FallenStar;
import de.ellpeck.nyx.items.Hammer;
import de.ellpeck.nyx.items.LunarWaterBottle;
import de.ellpeck.nyx.items.MeteorFinder;
import de.ellpeck.nyx.items.Pickaxe;
import de.ellpeck.nyx.items.Scythe;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="nyx")
public final class Registry {
    public static final Set<Item> MOD_ITEMS = new HashSet<Item>();
    public static final CreativeTabs CREATIVE_TAB = new CreativeTabs("nyx"){

        public ItemStack func_78016_d() {
            return new ItemStack(fallenStar);
        }
    };
    @CapabilityInject(value=NyxWorld.class)
    public static Capability<NyxWorld> worldCapability;
    public static Enchantment lunarEdge;
    public static Enchantment lunarShield;
    public static Block lunarWater;
    public static Block lunarWaterCauldron;
    public static Block starAir;
    public static Block starBlock;
    public static Block crackedStarBlock;
    public static Block chiseledStarBlock;
    public static Block starStairs;
    public static Block starSlab;
    public static Block meteorRock;
    public static Block gleaningMeteorRock;
    public static Block crystal;
    public static Block meteorBlock;
    public static Block meteorGlass;
    public static Fluid lunarWaterFluid;
    public static Item lunarWaterBottle;
    public static Item meteorShard;
    public static Item fallenStar;
    public static Item meteorDust;
    public static Item meteorFinder;
    public static Item unrefinedCrystal;
    public static Item scythe;
    public static Item meteorIngot;
    public static Item meteorBow;
    public static Item meteorPickaxe;
    public static Item meteorAxe;
    public static Item meteorShovel;
    public static Item meteorHoe;
    public static Item meteorSword;
    public static Item meteorHelm;
    public static Item meteorChest;
    public static Item meteorPants;
    public static Item meteorBoots;
    public static Item meteorHammer;
    public static SoundEvent lunarWaterSound;
    public static SoundEvent fallingStarSound;
    public static SoundEvent fallingStarImpactSound;
    public static SoundEvent fallingMeteorSound;
    public static SoundEvent fallingMeteorImpactSound;
    public static SoundEvent hammerStartSound;
    public static SoundEvent hammerEndSound;
    public static Item.ToolMaterial meteorToolMaterial;
    public static ItemArmor.ArmorMaterial meteorArmorMaterial;

    @SubscribeEvent
    public static void onEnchantmentRegistry(RegistryEvent.Register<Enchantment> event) {
        if (Config.enchantments) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Enchantment[]{lunarEdge = new LunarEdge(), lunarShield = new LunarShield()});
        }
    }

    @SubscribeEvent
    public static void onBlockRegistry(RegistryEvent.Register<Block> event) {
        IForgeRegistry reg = event.getRegistry();
        if (Config.lunarWater) {
            LunarWaterFluid fluid = new LunarWaterFluid();
            FluidRegistry.registerFluid((Fluid)fluid);
            FluidRegistry.addBucketForFluid((Fluid)fluid);
            lunarWaterFluid = FluidRegistry.getFluid((String)fluid.getName());
            lunarWater = new LunarWater(lunarWaterFluid);
            lunarWaterCauldron = new LunarWaterCauldron();
            reg.registerAll((IForgeRegistryEntry[])new Block[]{lunarWater, lunarWaterCauldron});
        }
        if (Config.fallingStars) {
            starAir = new StarAir();
            starBlock = Registry.initBlock(new Block(Material.field_151576_e).func_149711_c(2.0f), "star_block", ItemBlock::new);
            reg.registerAll((IForgeRegistryEntry[])new Block[]{starAir, starBlock, crackedStarBlock = Registry.initBlock(new Block(Material.field_151576_e).func_149711_c(2.0f), "cracked_star_block", ItemBlock::new), chiseledStarBlock = Registry.initBlock(new Block(Material.field_151576_e).func_149711_c(2.0f), "chiseled_star_block", ItemBlock::new), starStairs = Registry.initBlock((Block)new NyxStairs(starBlock.func_176223_P()), "star_stairs", ItemBlock::new)});
            NyxSlab[] slabs = NyxSlab.makeSlab("star_slab", Material.field_151576_e, SoundType.field_185851_d, 2.0f);
            reg.registerAll((IForgeRegistryEntry[])slabs);
            starSlab = slabs[0];
        }
        if (Config.meteors) {
            meteorRock = Registry.initBlock(new MeteorRock(() -> meteorShard), "meteor_rock", ItemBlock::new);
            reg.registerAll((IForgeRegistryEntry[])new Block[]{meteorRock, gleaningMeteorRock = Registry.initBlock(new MeteorRock(() -> unrefinedCrystal), "gleaning_meteor_rock", ItemBlock::new), crystal = new Crystal(), meteorBlock = Registry.initBlock(new Block(Material.field_151576_e).func_149711_c(3.0f), "meteor_block", ItemBlock::new), meteorGlass = Registry.initBlock(new Glass().func_149711_c(5.0f).func_149752_b(3000.0f), "meteor_glass", ItemBlock::new)});
        }
    }

    @SubscribeEvent
    public static void onItemRegistry(RegistryEvent.Register<Item> event) {
        if (Config.lunarWater) {
            lunarWaterBottle = new LunarWaterBottle();
        }
        meteorShard = Registry.initItem(new Item(), "meteor_shard");
        if (Config.meteors) {
            meteorDust = Registry.initItem(new Item(), "meteor_dust");
            meteorFinder = Registry.initItem(new MeteorFinder(), "meteor_finder");
            unrefinedCrystal = Registry.initItem(new Item(), "unrefined_crystal");
            scythe = Registry.initItem(new Scythe(), "scythe");
            meteorIngot = Registry.initItem(new Item(), "meteor_ingot");
            meteorBow = Registry.initItem((Item)new Bow(), "meteor_bow");
            meteorPickaxe = Registry.initItem((Item)new Pickaxe(meteorToolMaterial), "meteor_pickaxe");
            meteorAxe = Registry.initItem((Item)new Axe(meteorToolMaterial, 12.0f, -3.2f), "meteor_axe");
            meteorShovel = Registry.initItem((Item)new ItemSpade(meteorToolMaterial), "meteor_shovel");
            meteorHoe = Registry.initItem((Item)new ItemHoe(meteorToolMaterial), "meteor_hoe");
            meteorSword = Registry.initItem((Item)new ItemSword(meteorToolMaterial), "meteor_sword");
            meteorHelm = Registry.initItem((Item)new ItemArmor(meteorArmorMaterial, 0, EntityEquipmentSlot.HEAD), "meteor_helm");
            meteorChest = Registry.initItem((Item)new ItemArmor(meteorArmorMaterial, 1, EntityEquipmentSlot.CHEST), "meteor_chest");
            meteorPants = Registry.initItem((Item)new ItemArmor(meteorArmorMaterial, 2, EntityEquipmentSlot.LEGS), "meteor_pants");
            meteorBoots = Registry.initItem((Item)new ItemArmor(meteorArmorMaterial, 3, EntityEquipmentSlot.FEET), "meteor_boots");
            meteorHammer = Registry.initItem((Item)new Hammer(meteorToolMaterial), "meteor_hammer");
        }
        if (Config.fallingStars) {
            fallenStar = Registry.initItem(new FallenStar(), "fallen_star");
        }
        MOD_ITEMS.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
    }

    @SubscribeEvent
    public static void onSoundRegistry(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{lunarWaterSound = (SoundEvent)new SoundEvent(new ResourceLocation("nyx", "lunar_water")).setRegistryName("lunar_water"), fallingStarSound = (SoundEvent)new SoundEvent(new ResourceLocation("nyx", "falling_star")).setRegistryName("falling_star"), fallingStarImpactSound = (SoundEvent)new SoundEvent(new ResourceLocation("nyx", "falling_star_impact")).setRegistryName("falling_star_impact"), fallingMeteorSound = (SoundEvent)new SoundEvent(new ResourceLocation("nyx", "falling_meteor")).setRegistryName("falling_meteor"), fallingMeteorImpactSound = (SoundEvent)new SoundEvent(new ResourceLocation("nyx", "falling_meteor_impact")).setRegistryName("falling_meteor_impact"), hammerStartSound = (SoundEvent)new SoundEvent(new ResourceLocation("nyx", "hammer_start")).setRegistryName("hammer_start"), hammerEndSound = (SoundEvent)new SoundEvent(new ResourceLocation("nyx", "hammer_end")).setRegistryName("hammer_end")});
    }

    public static void preInit() {
        if (Config.lunarWater) {
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("nyx", "cauldron_tracker"), CauldronTracker.class, (String)"nyx.cauldron_tracker", (int)0, (Object)Nyx.instance, (int)64, (int)20, (boolean)false);
        }
        if (Config.fallingStars) {
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("nyx", "falling_star"), FallingStar.class, (String)"nyx.falling_star", (int)1, (Object)Nyx.instance, (int)128, (int)1, (boolean)true);
        }
        if (Config.meteors) {
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("nyx", "falling_meteor"), FallingMeteor.class, (String)"nyx.falling_meteor", (int)2, (Object)Nyx.instance, (int)256, (int)1, (boolean)true);
            meteorToolMaterial = EnumHelper.addToolMaterial((String)"NYX:METEOR", (int)3, (int)2341, (float)7.0f, (float)7.0f, (int)18);
            meteorArmorMaterial = EnumHelper.addArmorMaterial((String)"NYX:METEOR", (String)"nyx:meteor", (int)49, (int[])new int[]{4, 8, 10, 4}, (int)18, (SoundEvent)SoundEvents.field_187719_p, (float)3.0f);
        }
        CapabilityManager.INSTANCE.register(NyxWorld.class, (Capability.IStorage)new Capability.IStorage<NyxWorld>(){

            @Nullable
            public NBTBase writeNBT(Capability capability, NyxWorld instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability capability, NyxWorld instance, EnumFacing side, NBTBase nbt) {
            }
        }, () -> null);
    }

    public static void init() {
        if (Config.fallingStars) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(starBlock), (ItemStack)new ItemStack(crackedStarBlock), (float)0.1f);
        }
        if (Config.meteors) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(unrefinedCrystal), (ItemStack)new ItemStack(crystal), (float)0.25f);
            GameRegistry.addSmelting((ItemStack)new ItemStack(meteorShard), (ItemStack)new ItemStack(meteorIngot), (float)0.15f);
            GameRegistry.addSmelting((ItemStack)new ItemStack(meteorDust), (ItemStack)new ItemStack(meteorGlass), (float)0.1f);
        }
    }

    public static Item initItem(Item item, String name) {
        item.setRegistryName(new ResourceLocation("nyx", name));
        item.func_77655_b("nyx." + item.getRegistryName().func_110623_a());
        item.func_77637_a(CREATIVE_TAB);
        MOD_ITEMS.add(item);
        return item;
    }

    public static Block initBlock(Block block, String name, Function<Block, ItemBlock> item) {
        block.setRegistryName(new ResourceLocation("nyx", name));
        block.func_149663_c("nyx." + block.getRegistryName().func_110623_a());
        block.func_149647_a(CREATIVE_TAB);
        if (item != null) {
            Registry.initItem((Item)item.apply(block), name);
        }
        return block;
    }
}

