/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.core.mixin.client;

import com.fuzs.aquaacrobatics.client.entity.IPlayerSPSwimming;
import com.fuzs.aquaacrobatics.config.ConfigHandler;
import com.fuzs.aquaacrobatics.entity.Pose;
import com.fuzs.aquaacrobatics.entity.player.IPlayerResizeable;
import com.fuzs.aquaacrobatics.integration.IntegrationManager;
import com.fuzs.aquaacrobatics.util.MovementInputStorage;
import com.fuzs.aquaacrobatics.util.math.AxisAlignedBBSpliterator;
import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketEntityAction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovementInput;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityPlayerSP.class})
public abstract class EntityPlayerSPMixin
extends AbstractClientPlayer
implements IPlayerSPSwimming {
    @Shadow
    @Final
    public NetHandlerPlayClient field_71174_a;
    @Shadow
    protected Minecraft field_71159_c;
    @Shadow
    protected int field_71156_d;
    @Shadow
    private int field_189812_cs;
    @Shadow
    public MovementInput field_71158_b;
    private final MovementInputStorage movementStorage = new MovementInputStorage();
    private boolean isCrouching;

    public EntityPlayerSPMixin(World worldIn, GameProfile playerProfile) {
        super(worldIn, playerProfile);
    }

    @Redirect(method={"onUpdateWalkingPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/entity/EntityPlayerSP;isSneaking()Z"))
    private boolean onUpdateWalkingPlayerIsSneaking(EntityPlayerSP playerIn) {
        return this.isActuallySneaking();
    }

    @Inject(method={"isSneaking"}, at={@At(value="HEAD")}, cancellable=true)
    public void isSneaking(CallbackInfoReturnable<Boolean> callbackInfo) {
        callbackInfo.setReturnValue((Object)this.isCrouching);
    }

    public void func_174830_Y() {
        if (!(this.field_71075_bZ.field_75100_b || this.func_175149_v() || this.func_70093_af() || this.func_180799_ab() || !this.func_70089_S())) {
            super.func_174830_Y();
        }
    }

    @Override
    public boolean isActuallySneaking() {
        return this.field_71158_b != null && this.field_71158_b.field_78899_d;
    }

    @Override
    public boolean isForcedDown() {
        return ((IPlayerResizeable)((Object)this)).isResizingAllowed() && !this.field_71075_bZ.field_75100_b ? this.func_70093_af() || ((IPlayerResizeable)((Object)this)).isVisuallySwimming() : this.isActuallySneaking();
    }

    @Override
    public boolean isUsingSwimmingAnimation() {
        return this.isUsingSwimmingAnimation(this.field_71158_b.field_192832_b, this.field_71158_b.field_78902_a);
    }

    @Override
    public boolean isUsingSwimmingAnimation(float moveForward, float moveStrafe) {
        if (this.canSwim()) {
            return this.isMovingForward(moveForward, moveStrafe);
        }
        if (ConfigHandler.MovementConfig.sidewaysSprinting) {
            return moveForward >= 0.8f || Math.abs(moveStrafe) > 0.8f;
        }
        return moveForward >= 0.8f;
    }

    @Override
    public boolean canSwim() {
        return ((IPlayerResizeable)((Object)this)).getEyesInWaterPlayer();
    }

    @Override
    public boolean isMovingForward(float moveForward, float moveStrafe) {
        if (moveForward > 1.0E-5f) {
            return true;
        }
        if (ConfigHandler.MovementConfig.sidewaysSwimming) {
            return Math.abs(moveStrafe) > 1.0E-5f;
        }
        return false;
    }

    @Inject(method={"pushOutOfBlocks"}, at={@At(value="HEAD")}, cancellable=true)
    protected void pushOutOfBlocks(double x, double y, double z, CallbackInfoReturnable<Boolean> callbackInfo) {
        if (ConfigHandler.playerBlockCollisions != ConfigHandler.PlayerBlockCollisions.EXACT) {
            return;
        }
        if (!this.field_70145_X) {
            this.setPlayerOffsetMotion(x, z);
        }
        callbackInfo.setReturnValue((Object)false);
    }

    private void setPlayerOffsetMotion(double x, double z) {
        BlockPos blockpos = new BlockPos(x, this.field_70163_u, z);
        if (this.shouldBlockPushPlayer(blockpos)) {
            EnumFacing[] xzPlane;
            double d0 = x - (double)blockpos.func_177958_n();
            double d1 = z - (double)blockpos.func_177952_p();
            EnumFacing direction = null;
            double d2 = Double.MAX_VALUE;
            for (EnumFacing direction1 : xzPlane = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH}) {
                double d4;
                EnumFacing.Axis axis = direction1.func_176740_k();
                double d3 = axis == EnumFacing.Axis.X ? d0 : (axis == EnumFacing.Axis.Z ? d1 : 0.0);
                double d = d4 = direction1.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 1.0 - d3 : d3;
                if (!(d4 < d2) || this.shouldBlockPushPlayer(blockpos.func_177972_a(direction1))) continue;
                d2 = d4;
                direction = direction1;
            }
            if (direction != null) {
                if (direction.func_176740_k() == EnumFacing.Axis.X) {
                    this.field_70159_w = 0.1 * (double)direction.func_176730_m().func_177958_n();
                } else {
                    this.field_70179_y = 0.1 * (double)direction.func_176730_m().func_177952_p();
                }
            }
        }
    }

    private boolean shouldBlockPushPlayer(BlockPos pos) {
        double minY = this.func_174813_aQ().field_72338_b;
        double maxY = this.func_174813_aQ().field_72337_e;
        AxisAlignedBB aabb = new AxisAlignedBB((double)pos.func_177958_n(), minY, (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.0, maxY, (double)pos.func_177952_p() + 1.0);
        return !EntityPlayerSPMixin.isAxisAlignedBBNotClear(this.field_70170_p, (Entity)this, aabb.func_186664_h(1.0E-7));
    }

    private static boolean isAxisAlignedBBNotClear(World world, @Nullable Entity entity, AxisAlignedBB aabb) {
        return EntityPlayerSPMixin.createAxisAlignedBBStream(world, entity, aabb).allMatch(Objects::isNull);
    }

    private static Stream<AxisAlignedBB> createAxisAlignedBBStream(World world, @Nullable Entity entity, AxisAlignedBB aabb) {
        return StreamSupport.stream(new AxisAlignedBBSpliterator(world, entity, aabb), false);
    }

    @Redirect(method={"pushOutOfBlocks", "localPushOutOfBlocks"}, at=@At(value="INVOKE", target="Ljava/lang/Math;ceil(D)D"))
    private double ceil(double a) {
        if (ConfigHandler.playerBlockCollisions == ConfigHandler.PlayerBlockCollisions.APPROXIMATE) {
            a -= 0.65;
        }
        return Math.ceil(a);
    }

    @Inject(method={"onLivingUpdate"}, at={@At(value="HEAD")})
    public void onLivingUpdatePre(CallbackInfo callbackInfo) {
        this.updateSprintToggleTimer();
        this.movementStorage.copyFrom(this.field_71158_b);
        this.movementStorage.isSprinting = this.func_70051_ag();
        this.movementStorage.isFlying = this.field_71075_bZ.field_75100_b;
        this.movementStorage.isStartingToFly = this.isStartingToFly();
    }

    private void updateSprintToggleTimer() {
        if (this.field_71158_b.field_78899_d) {
            this.field_71156_d = 0;
        }
        this.movementStorage.sprintToggleTimer = this.field_71156_d;
        if (this.movementStorage.sprintToggleTimer > 0) {
            --this.movementStorage.sprintToggleTimer;
        }
        if (this.func_184587_cr() && !this.func_184218_aH()) {
            this.movementStorage.sprintToggleTimer = 0;
        }
    }

    private boolean isStartingToFly() {
        if (this.field_71075_bZ.field_75101_c) {
            if (this.field_71159_c.field_71442_b.func_178887_k()) {
                return !this.field_71075_bZ.field_75100_b;
            }
            if (!this.field_71158_b.field_78901_c && this.field_71159_c.field_71474_y.field_74314_A.func_151470_d() && this.field_189812_cs == 0) {
                return this.field_71101_bC != 0 && !((IPlayerResizeable)((Object)this)).isSwimming();
            }
        }
        return false;
    }

    @Inject(method={"onLivingUpdate", "localOnLivingUpdate"}, at={@At(value="FIELD", target="Lnet/minecraft/client/entity/EntityPlayerSP;wasFallFlying:Z")})
    public void onLivingUpdate(CallbackInfo callbackInfo) {
        this.updatePlayerMoveState();
        this.isCrouching = this.isCrouching(((IPlayerResizeable)((Object)this)).isPoseClear(Pose.STANDING));
        this.func_70031_b(this.movementStorage.isSprinting);
        boolean isSaturated = (float)this.func_71024_bL().func_75116_a() > 6.0f || this.field_71075_bZ.field_75101_c;
        this.startSprinting(isSaturated);
        this.stopSprinting(isSaturated);
        this.handleElytraTakeoff();
        this.handleWaterSneaking();
        this.slowDownSneakFlying();
    }

    private void updatePlayerMoveState() {
        if (!this.field_71158_b.field_78899_d && this.isForcedDown()) {
            this.field_71158_b.field_78902_a = (float)((double)this.field_71158_b.field_78902_a * 0.3);
            this.field_71158_b.field_192832_b = (float)((double)this.field_71158_b.field_192832_b * 0.3);
        }
        if (this.field_71158_b.field_78899_d && !this.isForcedDown()) {
            this.field_71158_b.field_78902_a = (float)((double)this.field_71158_b.field_78902_a / 0.3);
            this.field_71158_b.field_192832_b = (float)((double)this.field_71158_b.field_192832_b / 0.3);
        }
    }

    private boolean isCrouching(boolean cantStand) {
        if (!(this.movementStorage.isFlying && cantStand || this.func_184599_cB() > 4 || ((IPlayerResizeable)((Object)this)).isSwimming() || !this.field_70122_E && this.func_70090_H() || this.func_70617_f_() || !((IPlayerResizeable)((Object)this)).isPoseClear(Pose.CROUCHING) && !this.field_70145_X)) {
            return this.field_71158_b.field_78899_d || ((IPlayerResizeable)((Object)this)).isResizingAllowed() && !this.func_70608_bn() && !cantStand;
        }
        return false;
    }

    private void startSprinting(boolean isSaturated) {
        boolean isSprintingEnvironment;
        boolean wasSneaking = this.movementStorage.field_78899_d;
        boolean wasSwimming = this.isUsingSwimmingAnimation(this.movementStorage.field_192832_b, this.movementStorage.field_78902_a);
        boolean bl = isSprintingEnvironment = this.field_70122_E || this.canSwim() || this.movementStorage.isFlying;
        if (isSprintingEnvironment && !wasSneaking && !wasSwimming && this.isUsingSwimmingAnimation() && !this.func_70051_ag() && isSaturated && !this.func_184587_cr() && !this.func_70644_a(MobEffects.field_76440_q)) {
            if (this.movementStorage.sprintToggleTimer <= 0 && !this.field_71159_c.field_71474_y.field_151444_V.func_151470_d()) {
                this.field_71156_d = ConfigHandler.MovementConfig.noDoubleTapSprinting ? 0 : 7;
            } else {
                this.func_70031_b(true);
            }
        }
        if (!this.func_70051_ag() && (!this.func_70090_H() || this.canSwim()) && this.isUsingSwimmingAnimation() && isSaturated && !this.func_184587_cr() && !this.func_70644_a(MobEffects.field_76440_q) && this.field_71159_c.field_71474_y.field_151444_V.func_151470_d()) {
            this.func_70031_b(true);
        }
    }

    private void stopSprinting(boolean isSaturated) {
        if (this.func_70051_ag()) {
            boolean hasCollided;
            boolean isNotMoving = !this.isMovingForward(this.field_71158_b.field_192832_b, this.field_71158_b.field_78902_a) || !isSaturated;
            boolean bl = hasCollided = isNotMoving || this.field_70123_F || this.func_70090_H() && !this.canSwim() && !this.movementStorage.isFlying;
            if (((IPlayerResizeable)((Object)this)).isSwimming()) {
                if (!this.field_71158_b.field_78899_d && isNotMoving || !this.func_70090_H()) {
                    this.func_70031_b(false);
                }
            } else if (hasCollided) {
                this.func_70031_b(false);
            }
        }
    }

    @Override
    public boolean canPerformElytraTakeoff() {
        return ConfigHandler.MovementConfig.easyElytraTakeoff && this.field_71158_b.field_78901_c && !this.movementStorage.isStartingToFly && !this.movementStorage.field_78901_c && this.field_70181_x >= 0.0 && !this.field_71075_bZ.field_75100_b && !this.func_184218_aH() && !this.func_70617_f_();
    }

    private void handleElytraTakeoff() {
        if (this.canPerformElytraTakeoff()) {
            ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.CHEST);
            if (itemstack.func_77973_b() == Items.field_185160_cR && ItemElytra.func_185069_d((ItemStack)itemstack)) {
                this.field_71174_a.func_147297_a((Packet)new CPacketEntityAction((Entity)this, CPacketEntityAction.Action.START_FALL_FLYING));
            } else {
                IntegrationManager.elytraOpenHooks.forEach(hook -> hook.openElytra((EntityPlayerSP)this));
            }
        }
    }

    private void handleWaterSneaking() {
        if (this.func_70090_H() && this.field_71158_b.field_78899_d && !this.field_71075_bZ.field_75100_b) {
            this.handleSneakWater();
        }
    }

    private void slowDownSneakFlying() {
        if (this.field_71075_bZ.field_75100_b && this.func_175160_A() && this.field_71158_b.field_78899_d) {
            this.field_71158_b.field_78902_a = (float)((double)this.field_71158_b.field_78902_a * 0.3);
            this.field_71158_b.field_192832_b = (float)((double)this.field_71158_b.field_192832_b * 0.3);
        }
    }

    protected void handleSneakWater() {
        this.field_70181_x -= (double)0.04f * this.func_110148_a(SWIM_SPEED).func_111126_e();
    }

    @Shadow
    protected abstract boolean func_175160_A();
}

