/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.invman;

import com.m4thg33k.tombmanygraves.api.TempInventory;
import com.m4thg33k.tombmanygraves.blocks.ModBlocks;
import com.m4thg33k.tombmanygraves.invman.GraveInventoryManager;
import com.m4thg33k.tombmanygraves.items.ItemDeathList;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class InventoryHolder {
    public static final String TAG_NAME = "InventoryHolder";
    public static final String EMPTY = "IsEmpty";
    public static final String TIMESTAMP = "Timestamp";
    public static final String PLAYER_NAME = "PlayerName";
    public static final String X = "Xcoord";
    public static final String Y = "Ycoord";
    public static final String Z = "Zcoord";
    private NBTTagCompound compound = new NBTTagCompound();
    private boolean isEmpty = true;
    private String timestamp = "";
    private int xcoord = -1;
    private int ycoord = -1;
    private int zcoord = -1;
    private String playerName = "unknown";

    public boolean isInventoryEmpty() {
        return this.isEmpty;
    }

    public void grabPlayerData(EntityPlayer player) {
        HashMap<String, TempInventory> map = GraveInventoryManager.getInstance().grabItemsFromPlayer(player);
        this.isEmpty = map.isEmpty();
        this.compound = new NBTTagCompound();
        for (Map.Entry<String, TempInventory> entry : map.entrySet()) {
            NBTTagList list = new NBTTagList();
            entry.getValue().writeToTagList(list);
            this.compound.func_74782_a(entry.getKey(), (NBTBase)list);
        }
        this.playerName = player.func_70005_c_();
        this.compound.func_74778_a(PLAYER_NAME, this.playerName);
        this.setTimestamp(new SimpleDateFormat("MM_dd_YYYY_HH_mm_ss").format(new Date()));
    }

    public List<ItemStack> getAllItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (String key : this.compound.func_150296_c()) {
            TempInventory inv = new TempInventory(this.compound.func_150295_c(key, 10));
            list.addAll(inv.getListOfNonEmptyItemStacks());
        }
        return list;
    }

    public void ensure(List<EntityItem> drops) {
        for (String key : this.compound.func_150296_c()) {
            TempInventory inv = new TempInventory(this.compound.func_150295_c(key, 10));
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                boolean contains = false;
                for (EntityItem itm : drops) {
                    if (!ItemStack.func_77989_b((ItemStack)inv.func_70301_a(i), (ItemStack)itm.func_92059_d())) continue;
                    contains = true;
                    drops.remove(itm);
                    break;
                }
                if (contains) continue;
                inv.func_70299_a(i, ItemStack.field_190927_a);
            }
            NBTTagList list = new NBTTagList();
            inv.writeToTagList(list);
            this.compound.func_74782_a(key, (NBTBase)list);
        }
        this.isEmpty = this.getAllItems().isEmpty();
    }

    public void grabPlayerData(EntityPlayer player, BlockPos pos) {
        this.grabPlayerData(player);
        this.setPosition(pos);
    }

    public void setPosition(BlockPos pos) {
        this.xcoord = pos.func_177958_n();
        this.ycoord = pos.func_177956_o();
        this.zcoord = pos.func_177952_p();
        this.compound.func_74768_a(X, this.xcoord);
        this.compound.func_74768_a(Y, this.ycoord);
        this.compound.func_74768_a(Z, this.zcoord);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public BlockPos getPosition() {
        return new BlockPos(this.xcoord, this.ycoord, this.zcoord);
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
        this.compound.func_74778_a(TIMESTAMP, timestamp);
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public static boolean isItemValidForGrave(ItemStack stack) {
        return !stack.func_190926_b() && !(stack.func_77973_b() instanceof ItemDeathList) && stack.func_77973_b() != Item.func_150898_a((Block)ModBlocks.blockGrave);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound inCompound) {
        inCompound.func_74782_a(TAG_NAME, (NBTBase)this.compound);
        inCompound.func_74757_a(EMPTY, this.isEmpty);
        return inCompound;
    }

    public void readFromNBT(NBTTagCompound inCompound) {
        if (inCompound.func_74764_b(TAG_NAME)) {
            this.compound = inCompound.func_74775_l(TAG_NAME);
            this.isEmpty = inCompound.func_74767_n(EMPTY);
            this.xcoord = this.compound.func_74762_e(X);
            this.ycoord = this.compound.func_74762_e(Y);
            this.zcoord = this.compound.func_74762_e(Z);
            this.timestamp = this.compound.func_74779_i(TIMESTAMP);
            this.playerName = this.compound.func_74779_i(PLAYER_NAME);
        } else {
            this.compound = new NBTTagCompound();
            this.isEmpty = true;
            this.xcoord = -1;
            this.ycoord = -1;
            this.zcoord = -1;
            this.timestamp = "";
            this.playerName = "unknown";
        }
    }

    public void insertInventory(EntityPlayer player) {
        if (this.isEmpty) {
            return;
        }
        GraveInventoryManager.getInstance().insertInventory(player, this.compound, false);
    }

    public void forceInventory(EntityPlayer player) {
        if (this.isEmpty) {
            return;
        }
        GraveInventoryManager.getInstance().insertInventory(player, this.compound, true);
    }

    public void dropInventory(EntityPlayer player) {
        this.dropInventory(player.func_130014_f_(), player.func_180425_c());
    }

    public void dropInventory(World world, BlockPos pos) {
        GraveInventoryManager.getInstance().generateDrops(this.compound).forEach(itemStack -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemStack));
    }

    public static void dropItem(EntityPlayer player, ItemStack stack) {
        InventoryHelper.func_180173_a((World)player.func_130014_f_(), (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (ItemStack)stack);
    }

    public static void dropItem(World world, BlockPos pos, ItemStack stack) {
        InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
    }

    public Map<String, Tuple<String, List<String>>> getItemStackStringsForGui() {
        return GraveInventoryManager.getInstance().createItemListForGui(this.compound);
    }
}

