/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.structure.context;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockAreas;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.world.chunk.gen.StructureBoundingBoxes;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.utils.RCAxisAlignedTransform;
import ivorius.reccomplex.utils.RCBlockAreas;
import ivorius.reccomplex.utils.RCStructureBoundingBoxes;
import ivorius.reccomplex.world.gen.feature.HeightMapFreezer;
import ivorius.reccomplex.world.gen.feature.structure.Environment;
import ivorius.reccomplex.world.gen.feature.structure.context.StructureLiveContext;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class StructureSpawnContext
extends StructureLiveContext {
    @Nonnull
    public final Random random;
    @Nullable
    public final StructureBoundingBox generationBB;
    @Nullable
    public final Predicate<Vec3i> generationPredicate;
    public final int generationLayer;
    public final GenerateMaturity generateMaturity;
    private HeightMapFreezer heightMapFreezer;

    public StructureSpawnContext(@Nonnull Environment environment, @Nonnull Random random, @Nonnull AxisAlignedTransform2D transform, @Nonnull StructureBoundingBox boundingBox, @Nullable StructureBoundingBox generationBB, Predicate<Vec3i> generationPredicate, int generationLayer, boolean generateAsSource, GenerateMaturity generateMaturity) {
        super(transform, boundingBox, generateAsSource, environment);
        this.random = random;
        this.generationBB = generationBB;
        this.generationPredicate = generationPredicate;
        this.generationLayer = generationLayer;
        this.generateMaturity = generateMaturity;
    }

    @Nullable
    public StructureBoundingBox sourceIntersection(StructureBoundingBox area) {
        return this.generationBB != null ? RCStructureBoundingBoxes.intersection(area, BlockAreas.toBoundingBox((BlockArea)RCAxisAlignedTransform.apply(RCAxisAlignedTransform.invert(this.transform), RCBlockAreas.sub(RCBlockAreas.from(this.generationBB), (Vec3i)StructureBoundingBoxes.min((StructureBoundingBox)this.boundingBox)), StructureBoundingBoxes.size((StructureBoundingBox)this.boundingBox), 1))) : area;
    }

    public StructureBoundingBox intersection(StructureBoundingBox area) {
        return this.generationBB != null ? RCStructureBoundingBoxes.intersection(area, this.generationBB) : area;
    }

    public boolean includes(Vec3i coord) {
        return !(this.generationBB != null && !this.generationBB.func_175898_b(coord) || this.generationPredicate != null && !this.generationPredicate.test(coord));
    }

    public boolean includesComplex(Vec3i coord) {
        return this.generationPredicate == null || this.generationPredicate.test(coord);
    }

    public boolean setBlock(BlockPos pos, IBlockState state, int flag) {
        if (!RecurrentComplex.specialRegistry.isSafe(state.func_177230_c())) {
            this.environment.world.func_180501_a(pos.func_185334_h(), Blocks.field_150350_a.func_176223_P(), 2);
            return false;
        }
        if (this.includes((Vec3i)pos)) {
            this.environment.world.func_180501_a(pos.func_185334_h(), state, flag);
            if (this.heightMapFreezer != null) {
                this.heightMapFreezer.markBlock(pos, state);
            }
            return true;
        }
        return false;
    }

    public void freezeHeightMap(StructureBoundingBox boundingBox) {
        this.heightMapFreezer = HeightMapFreezer.freeze(boundingBox, (World)this.environment.world);
    }

    public void meltHeightMap() {
        this.heightMapFreezer.melt();
        this.heightMapFreezer = null;
    }

    public static enum GenerateMaturity {
        PLAN,
        SUGGEST,
        FIRST,
        COMPLEMENT;


        public boolean isSuggest() {
            return this == PLAN || this == SUGGEST;
        }

        public boolean isFirstTime() {
            return this != COMPLEMENT;
        }

        public boolean generates() {
            return this != PLAN;
        }
    }
}

