/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature.selector;

import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.reccomplex.world.gen.feature.selector.StructureSelector;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.tuple.Pair;

public class MixingStructureSelector<T extends GenerationType, C extends Category>
extends StructureSelector<T, C> {
    public MixingStructureSelector(Map<String, Structure<?>> structures, WorldProvider provider, Biome biome, Class<T> typeClass) {
        super(structures, provider, biome, typeClass);
    }

    public int structuresInBiome(C category, WorldProvider worldProvider, Biome biome, Float distanceToSpawn, Random random) {
        return category != null ? category.structuresInBiome(biome, worldProvider, this.totalWeight(category), distanceToSpawn, random) : 0;
    }

    public List<Pair<Structure<?>, T>> generatedStructures(Random random, Biome biome, WorldProvider provider, Float distanceToSpawn) {
        return this.weightedStructureInfos.keySet().stream().flatMap(category -> IntStream.range(0, this.structuresInBiome(category, provider, biome, distanceToSpawn, random)).mapToObj(i -> category)).map(category -> (Pair)WeightedSelector.select((Random)random, (Collection)this.weightedStructureInfos.get(category))).collect(Collectors.toList());
    }

    @Nullable
    public Pair<Structure<?>, T> selectOne(Random random, WorldProvider provider, Biome biome, @Nullable C c, Float distanceToSpawn) {
        if (c != null) {
            return super.selectOne(random, c);
        }
        List list = this.weightedStructureInfos.keySet().stream().map(category -> new WeightedSelector.SimpleItem((double)this.structuresInBiome(category, provider, biome, distanceToSpawn, random), category)).collect(Collectors.toList());
        return this.selectOne(random, WeightedSelector.select((Random)random, list));
    }

    static interface Category {
        public int structuresInBiome(Biome var1, WorldProvider var2, double var3, Float var5, Random var6);
    }
}

