/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils.expression;

import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.ivtoolkit.world.MockWorld;
import ivorius.ivtoolkit.world.WorldCache;
import ivorius.reccomplex.utils.RCBlockLogic;
import ivorius.reccomplex.utils.algebra.BoolFunctionExpressionCache;
import ivorius.reccomplex.utils.algebra.FunctionExpressionCache;
import ivorius.reccomplex.utils.algebra.RCBoolAlgebra;
import ivorius.reccomplex.utils.algebra.SupplierCache;
import ivorius.reccomplex.utils.expression.BlockExpression;
import ivorius.reccomplex.utils.expression.DelegatingVariableType;
import java.text.ParseException;
import java.util.function.Function;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class PositionedBlockExpression
extends BoolFunctionExpressionCache<Argument, Object> {
    public static final String BLOCK_PREFIX = "block.";
    public static final String IS_PREFIX = "is:";
    public static final String SUSTAIN_PREFIX = "sustains.";
    public static final String BLOCKS_PREFIX = "blocks:";
    public final MCRegistry registry;

    public PositionedBlockExpression(MCRegistry registry) {
        super(RCBoolAlgebra.algebra(), true, TextFormatting.GREEN + "Any Block");
        this.registry = registry;
        this.addTypes(new BlockVariableType(BLOCK_PREFIX, "", registry), v -> v.alias("", ""));
        this.addTypes(new IsVariableType(IS_PREFIX, ""), new Function[0]);
        this.addType(new SustainVariableType(SUSTAIN_PREFIX, ""));
        this.addType(new BlocksVariableType(BLOCKS_PREFIX, ""));
    }

    public static class BlocksVariableType
    extends FunctionExpressionCache.VariableType<Boolean, Argument, Object> {
        public BlocksVariableType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        @Override
        public Function<SupplierCache<Argument>, Boolean> parse(String var) throws ParseException {
            switch (var) {
                case "movement": {
                    return argument -> ((Argument)argument.get()).state.func_185904_a().func_76230_c();
                }
                case "light": {
                    return argument -> ((Argument)argument.get()).state.func_185904_a().func_76228_b();
                }
            }
            throw new ParseException("Unknown Type: " + var, 0);
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, Object object) {
            return var.equals("movement") || var.equals("light") ? FunctionExpressionCache.Validity.KNOWN : FunctionExpressionCache.Validity.ERROR;
        }
    }

    public static class SustainVariableType
    extends FunctionExpressionCache.VariableType<Boolean, Argument, Object> {
        public SustainVariableType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        @Override
        public Function<SupplierCache<Argument>, Boolean> parse(String var) throws ParseException {
            switch (var) {
                case "trees": {
                    return argument -> ((Argument)argument.get()).state.func_177230_c().canSustainPlant(((Argument)argument.get()).state, (IBlockAccess)((Argument)argument.get()).world.asWorld(), ((Argument)argument.get()).pos, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
                }
                case "mushrooms": {
                    return argument -> ((Argument)argument.get()).state.func_177230_c() == Blocks.field_150346_d || ((Argument)argument.get()).state.func_177230_c() == Blocks.field_150349_c || ((Argument)argument.get()).state.func_177230_c() == Blocks.field_150391_bh;
                }
                case "cacti": {
                    return argument -> Blocks.field_150434_aF.func_176586_d(((Argument)argument.get()).world.asWorld(), ((Argument)argument.get()).pos);
                }
            }
            throw new ParseException("Unknown Type: " + var, 0);
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, Object object) {
            return var.equals("trees") || var.equals("mushrooms") || var.equals("cacti") ? FunctionExpressionCache.Validity.KNOWN : FunctionExpressionCache.Validity.ERROR;
        }
    }

    public static class IsVariableType
    extends FunctionExpressionCache.VariableType<Boolean, Argument, Object> {
        public IsVariableType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        @Override
        public Function<SupplierCache<Argument>, Boolean> parse(String var) throws ParseException {
            switch (var) {
                case "leaves": {
                    return argument -> ((Argument)argument.get()).state.func_185904_a() == Material.field_151584_j || ((Argument)argument.get()).state.func_177230_c().isLeaves(((Argument)argument.get()).state, (IBlockAccess)((Argument)argument.get()).world.asWorld(), ((Argument)argument.get()).pos);
                }
                case "air": {
                    return argument -> ((Argument)argument.get()).state.func_185904_a() == Material.field_151579_a || ((Argument)argument.get()).state.func_177230_c().isAir(((Argument)argument.get()).state, (IBlockAccess)((Argument)argument.get()).world.asWorld(), ((Argument)argument.get()).pos);
                }
                case "foliage": {
                    return argument -> RCBlockLogic.isFoliage(((Argument)argument.get()).state, (IBlockAccess)((Argument)argument.get()).world.asWorld(), ((Argument)argument.get()).pos);
                }
                case "replaceable": {
                    return argument -> ((Argument)argument.get()).state.func_177230_c().func_176200_f((IBlockAccess)((Argument)argument.get()).world.asWorld(), ((Argument)argument.get()).pos);
                }
                case "liquid": {
                    return argument -> ((Argument)argument.get()).state.func_185904_a() instanceof MaterialLiquid;
                }
                case "water": {
                    return argument -> ((Argument)argument.get()).state.func_185904_a() == Material.field_151586_h;
                }
                case "lava": {
                    return argument -> ((Argument)argument.get()).state.func_185904_a() == Material.field_151587_i;
                }
            }
            throw new ParseException("Unknown Type: " + var, 0);
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, Object object) {
            return var.equals("leaves") || var.equals("air") || var.equals("foliage") || var.equals("replaceable") || var.equals("liquid") || var.equals("water") || var.equals("lava") ? FunctionExpressionCache.Validity.KNOWN : FunctionExpressionCache.Validity.ERROR;
        }
    }

    public static class BlockVariableType
    extends DelegatingVariableType<Boolean, Argument, Object, IBlockState, Object, BlockExpression> {
        public final MCRegistry registry;

        public BlockVariableType(String prefix, String suffix, MCRegistry registry) {
            super(prefix, suffix);
            this.registry = registry;
        }

        @Override
        public IBlockState convertEvaluateArgument(String var, Argument argument) {
            return argument.state;
        }

        @Override
        public BlockExpression createCache() {
            return new BlockExpression(this.registry);
        }
    }

    public static class Argument {
        public MockWorld world;
        public BlockPos pos;
        public IBlockState state;

        public Argument(MockWorld world, BlockPos pos, IBlockState state) {
            this.world = world;
            this.pos = pos;
            this.state = state;
        }

        public static Argument at(MockWorld world, BlockPos pos) {
            return new Argument(world, pos, world.func_180495_p(pos));
        }

        public static Argument at(World world, BlockPos pos) {
            return Argument.at((MockWorld)new MockWorld.Real(world), pos);
        }

        public static Argument at(WorldCache cache, BlockPos pos) {
            return Argument.at((MockWorld)new MockWorld.Cache(cache), pos);
        }
    }
}

