/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.init;

import com.google.common.base.Preconditions;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.block.MoCBlock;
import drzhark.mocreatures.block.MoCBlockDirt;
import drzhark.mocreatures.block.MoCBlockGrass;
import drzhark.mocreatures.block.MoCBlockLeaf;
import drzhark.mocreatures.block.MoCBlockLog;
import drzhark.mocreatures.block.MoCBlockPlanks;
import drzhark.mocreatures.block.MoCBlockRock;
import drzhark.mocreatures.block.MoCBlockTallGrass;
import drzhark.mocreatures.block.MultiItemBlock;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="mocreatures")
public class MoCBlocks {
    public static ArrayList<String> multiBlockNames = new ArrayList();
    public static MoCBlock mocStone = (MoCBlock)new MoCBlockRock("MoCStone").func_149711_c(1.5f).func_149752_b(10.0f);
    public static MoCBlock mocGrass = (MoCBlock)new MoCBlockGrass("MoCGrass").func_149711_c(0.5f);
    public static MoCBlock mocDirt = (MoCBlock)new MoCBlockDirt("MoCDirt").func_149711_c(0.6f);
    public static MoCBlock mocLeaf = (MoCBlock)new MoCBlockLeaf("MoCLeaves").func_149711_c(0.2f).func_149713_g(1);
    public static MoCBlock mocLog = (MoCBlock)new MoCBlockLog("MoCLog").func_149711_c(2.0f);
    public static MoCBlockTallGrass mocTallGrass = (MoCBlockTallGrass)new MoCBlockTallGrass("MoCTallGrass", true).func_149711_c(0.0f);
    public static MoCBlock mocPlank = (MoCBlock)new MoCBlockPlanks("MoCWoodPlank").func_149711_c(2.0f).func_149752_b(5.0f);

    @Mod.EventBusSubscriber(modid="mocreatures")
    public static class RegistrationHandler {
        public static final Set<ItemBlock> ITEM_BLOCKS = new HashSet<ItemBlock>();

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            Block[] blocks = new Block[]{mocStone, mocGrass, mocDirt, mocLeaf, mocLog, mocTallGrass, mocPlank};
            mocDirt.setHarvestLevel("shovel", 0, mocDirt.func_176223_P());
            mocGrass.setHarvestLevel("shovel", 0, mocGrass.func_176223_P());
            mocStone.setHarvestLevel("pickaxe", 1, mocStone.func_176223_P());
            multiBlockNames.add("WyvernLair");
            multiBlockNames.add("OgreLair");
            registry.registerAll((IForgeRegistryEntry[])blocks);
        }

        @SubscribeEvent
        public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
            ItemBlock[] items = new ItemBlock[]{new MultiItemBlock(mocStone), new MultiItemBlock(mocGrass), new MultiItemBlock(mocDirt), new MultiItemBlock(mocLeaf), new MultiItemBlock(mocLog), new MultiItemBlock((Block)mocTallGrass), new MultiItemBlock(mocPlank)};
            IForgeRegistry registry = event.getRegistry();
            for (ItemBlock item : items) {
                Block block = item.func_179223_d();
                ResourceLocation registryName = (ResourceLocation)Preconditions.checkNotNull((Object)block.getRegistryName(), (String)"Block %s has null registry name", (Object)block);
                registry.register(item.setRegistryName(registryName));
                ITEM_BLOCKS.add(item);
                if (MoCreatures.isServer()) continue;
                String name = item.func_77658_a().replace("tile.", "").replace("MoC", "").toLowerCase();
                System.out.println("registering custom location " + name);
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("mocreatures:wyvern_" + name)});
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("mocreatures:ogre_" + name)});
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("mocreatures:wyvern_" + name, "inventory"));
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)1, (ModelResourceLocation)new ModelResourceLocation("mocreatures:ogre_" + name, "inventory"));
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)2, (ModelResourceLocation)new ModelResourceLocation("mocreatures:wyvern_" + name, "variant=wyvern_lair"));
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)3, (ModelResourceLocation)new ModelResourceLocation("mocreatures:ogre_" + name, "variant=ogre_lair"));
            }
        }
    }
}

