/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.renderer.lwjgl;

import de.matthiasmann.twl.renderer.MouseCursor;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLTexture;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;

class LWJGLCursor
implements MouseCursor {
    Cursor cursor;

    LWJGLCursor(ByteBuffer src, LWJGLTexture.Format srcFmt, int srcStride, int x, int y, int width, int height, int hotSpotX, int hotSpotY) {
        width = Math.min(Cursor.getMaxCursorSize(), width);
        height = Math.min(Cursor.getMaxCursorSize(), height);
        int dstSize = Math.max(Cursor.getMinCursorSize(), Math.max(width, height));
        IntBuffer buf = BufferUtils.createIntBuffer((int)(dstSize * dstSize));
        int row = height;
        int dstPos = 0;
        while (row-- > 0) {
            int offset = srcStride * (y + row) + x * srcFmt.getPixelSize();
            buf.position(dstPos);
            switch (srcFmt) {
                case RGB: {
                    int b;
                    int g;
                    int r;
                    int col;
                    for (col = 0; col < width; ++col) {
                        r = src.get(offset + col * 3 + 0) & 0xFF;
                        g = src.get(offset + col * 3 + 1) & 0xFF;
                        b = src.get(offset + col * 3 + 2) & 0xFF;
                        buf.put(LWJGLCursor.makeColor(r, g, b, 255));
                    }
                    break;
                }
                case RGBA: {
                    int a;
                    int b;
                    int g;
                    int r;
                    int col;
                    for (col = 0; col < width; ++col) {
                        r = src.get(offset + col * 4 + 0) & 0xFF;
                        g = src.get(offset + col * 4 + 1) & 0xFF;
                        b = src.get(offset + col * 4 + 2) & 0xFF;
                        a = src.get(offset + col * 4 + 3) & 0xFF;
                        buf.put(LWJGLCursor.makeColor(r, g, b, a));
                    }
                    break;
                }
                case ABGR: {
                    int a;
                    int b;
                    int g;
                    int r;
                    int col;
                    for (col = 0; col < width; ++col) {
                        r = src.get(offset + col * 4 + 3) & 0xFF;
                        g = src.get(offset + col * 4 + 2) & 0xFF;
                        b = src.get(offset + col * 4 + 1) & 0xFF;
                        a = src.get(offset + col * 4 + 0) & 0xFF;
                        buf.put(LWJGLCursor.makeColor(r, g, b, a));
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported color format");
                }
            }
            dstPos += dstSize;
        }
        buf.clear();
        try {
            this.cursor = new Cursor(dstSize, dstSize, hotSpotX, Math.min(dstSize - 1, height - hotSpotY - 1), 1, buf, null);
        }
        catch (LWJGLException ex) {
            ex.printStackTrace();
        }
    }

    private static int makeColor(int r, int g, int b, int a) {
        a = a > 222 ? 255 : 0;
        return a << 24 | r << 16 | g << 8 | b;
    }

    void destroy() {
        if (this.cursor != null) {
            this.cursor.destroy();
            this.cursor = null;
        }
    }
}

