/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.ComboBoxBase;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.TableRowSelectionManager;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.TreePathDisplay;
import de.matthiasmann.twl.TreeTable;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.TableSingleSelectionModel;
import de.matthiasmann.twl.model.TreeTableModel;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twl.utils.CallbackSupport;

public class TreeComboBox
extends ComboBoxBase {
    private static final String DEFAULT_POPUP_THEME = "treecomboboxPopup";
    final TableSingleSelectionModel selectionModel = new TableSingleSelectionModel();
    final TreePathDisplay display = new TreePathDisplay();
    final TreeTable table;
    private TreeTableModel model;
    private Callback[] callbacks;
    private PathResolver pathResolver;
    private boolean suppressCallback;
    boolean suppressTreeSelectionUpdating;

    public TreeComboBox() {
        this.display.setTheme("display");
        this.table = new TreeTable();
        this.table.setSelectionManager(new TableRowSelectionManager(this.selectionModel){

            @Override
            protected boolean handleMouseClick(int row, int column, boolean isShift, boolean isCtrl) {
                if (!isShift && !isCtrl && row >= 0 && row < this.getNumRows()) {
                    TreeComboBox.this.popup.closePopup();
                    return true;
                }
                return super.handleMouseClick(row, column, isShift, isCtrl);
            }
        });
        this.display.addCallback(new TreePathDisplay.Callback(){

            @Override
            public void pathElementClicked(TreeTableNode node, TreeTableNode child) {
                TreeComboBox.this.fireSelectedNodeChanged(node, child);
            }

            @Override
            public boolean resolvePath(String path) {
                return TreeComboBox.this.resolvePath(path);
            }
        });
        this.selectionModel.addSelectionChangeListener(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int row = TreeComboBox.this.selectionModel.getFirstSelected();
                if (row >= 0) {
                    TreeComboBox.this.suppressTreeSelectionUpdating = true;
                    try {
                        TreeComboBox.this.nodeChanged(TreeComboBox.this.table.getNodeFromRow(row));
                    }
                    finally {
                        TreeComboBox.this.suppressTreeSelectionUpdating = false;
                    }
                }
            }
        });
        ScrollPane scrollPane = new ScrollPane(this.table);
        scrollPane.setFixed(ScrollPane.Fixed.HORIZONTAL);
        this.add(this.display);
        this.popup.setTheme(DEFAULT_POPUP_THEME);
        this.popup.add(scrollPane);
    }

    public TreeComboBox(TreeTableModel model) {
        this();
        this.setModel(model);
    }

    public TreeTableModel getModel() {
        return this.model;
    }

    public void setModel(TreeTableModel model) {
        if (this.model != model) {
            this.model = model;
            this.table.setModel(model);
            this.display.setCurrentNode(model);
        }
    }

    public void setCurrentNode(TreeTableNode node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        this.display.setCurrentNode(node);
        if (this.popup.isOpen()) {
            this.tableSelectToCurrentNode();
        }
    }

    public TreeTableNode getCurrentNode() {
        return this.display.getCurrentNode();
    }

    public void setSeparator(String separator) {
        this.display.setSeparator(separator);
    }

    public String getSeparator() {
        return this.display.getSeparator();
    }

    public PathResolver getPathResolver() {
        return this.pathResolver;
    }

    public void setPathResolver(PathResolver pathResolver) {
        this.pathResolver = pathResolver;
        this.display.setAllowEdit(pathResolver != null);
    }

    public TreeTable getTreeTable() {
        return this.table;
    }

    public EditField getEditField() {
        return this.display.getEditField();
    }

    public void addCallback(Callback callback) {
        this.callbacks = CallbackSupport.addCallbackToList(this.callbacks, callback, Callback.class);
    }

    public void removeCallback(Callback callback) {
        this.callbacks = CallbackSupport.removeCallbackFromList(this.callbacks, callback);
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.applyTreeComboboxPopupThemeName(themeInfo);
    }

    protected void applyTreeComboboxPopupThemeName(ThemeInfo themeInfo) {
        this.popup.setTheme(themeInfo.getParameter("popupThemeName", DEFAULT_POPUP_THEME));
    }

    @Override
    protected Widget getLabel() {
        return this.display;
    }

    void fireSelectedNodeChanged(TreeTableNode node, TreeTableNode child) {
        if (this.callbacks != null) {
            for (Callback cb : this.callbacks) {
                cb.selectedNodeChanged(node, child);
            }
        }
    }

    boolean resolvePath(String path) {
        if (this.pathResolver != null) {
            try {
                TreeTableNode node = this.pathResolver.resolvePath(this.model, path);
                assert (node != null);
                this.nodeChanged(node);
                return true;
            }
            catch (IllegalArgumentException ex) {
                this.display.setEditErrorMessage(ex.getMessage());
            }
        }
        return false;
    }

    void nodeChanged(TreeTableNode node) {
        TreeTableNode oldNode = this.display.getCurrentNode();
        this.display.setCurrentNode(node);
        if (!this.suppressCallback) {
            this.fireSelectedNodeChanged(node, this.getChildOf(node, oldNode));
        }
    }

    private TreeTableNode getChildOf(TreeTableNode parent, TreeTableNode node) {
        while (node != null && node != parent) {
            node = node.getParent();
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tableSelectToCurrentNode() {
        if (!this.suppressTreeSelectionUpdating) {
            this.table.collapseAll();
            int idx = this.table.getRowFromNodeExpand(this.display.getCurrentNode());
            this.suppressCallback = true;
            try {
                this.selectionModel.setSelection(idx, idx);
            }
            finally {
                this.suppressCallback = false;
            }
            this.table.scrollToRow(Math.max(0, idx));
        }
    }

    @Override
    protected boolean openPopup() {
        if (super.openPopup()) {
            this.popup.validateLayout();
            this.tableSelectToCurrentNode();
            return true;
        }
        return false;
    }

    public static interface PathResolver {
        public TreeTableNode resolvePath(TreeTableModel var1, String var2) throws IllegalArgumentException;
    }

    public static interface Callback {
        public void selectedNodeChanged(TreeTableNode var1, TreeTableNode var2);
    }
}

