/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.CallbackWithReason;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.ListBoxDisplay;
import de.matthiasmann.twl.Scrollbar;
import de.matthiasmann.twl.TextWidget;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twl.model.ListModel;
import de.matthiasmann.twl.model.ListSelectionModel;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.utils.CallbackSupport;

public class ListBox<T>
extends Widget {
    public static final int NO_SELECTION = -1;
    public static final int DEFAULT_CELL_HEIGHT = 20;
    public static final int SINGLE_COLUMN = -1;
    private static final ListBoxDisplay[] EMPTY_LABELS = new ListBoxDisplay[0];
    private final ListModel.ChangeListener modelCallback;
    private final Scrollbar scrollbar;
    private ListBoxDisplay[] labels;
    private ListModel<T> model;
    private IntegerModel selectionModel;
    private Runnable selectionModelCallback;
    private int cellHeight = 20;
    private int cellWidth = -1;
    private boolean rowMajor = true;
    private boolean fixedCellWidth;
    private boolean fixedCellHeight;
    private int minDisplayedRows = 1;
    private int numCols = 1;
    private int firstVisible;
    private int selected = -1;
    private int numEntries;
    private boolean needUpdate;
    private boolean inSetSelected;
    private CallbackWithReason<?>[] callbacks;

    public ListBox() {
        LImpl li = new LImpl();
        this.modelCallback = li;
        this.scrollbar = new Scrollbar();
        this.scrollbar.addCallback(li);
        this.labels = EMPTY_LABELS;
        super.insertChild(this.scrollbar, 0);
        this.setSize(200, 300);
        this.setCanAcceptKeyboardFocus(true);
        this.setDepthFocusTraversal(false);
    }

    public ListBox(ListModel<T> model) {
        this();
        this.setModel(model);
    }

    public ListBox(ListSelectionModel<T> model) {
        this();
        this.setModel(model);
    }

    public ListModel<T> getModel() {
        return this.model;
    }

    public void setModel(ListModel<T> model) {
        if (this.model != model) {
            if (this.model != null) {
                this.model.removeChangeListener(this.modelCallback);
            }
            this.model = model;
            if (model != null) {
                model.addChangeListener(this.modelCallback);
            }
            this.modelCallback.allChanged();
        }
    }

    public IntegerModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(IntegerModel selectionModel) {
        if (this.selectionModel != selectionModel) {
            if (this.selectionModel != null) {
                this.selectionModel.removeCallback(this.selectionModelCallback);
            }
            this.selectionModel = selectionModel;
            if (selectionModel != null) {
                if (this.selectionModelCallback == null) {
                    this.selectionModelCallback = new Runnable(){

                        @Override
                        public void run() {
                            ListBox.this.syncSelectionFromModel();
                        }
                    };
                }
                this.selectionModel.addCallback(this.selectionModelCallback);
                this.syncSelectionFromModel();
            }
        }
    }

    public void setModel(ListSelectionModel<T> model) {
        this.setSelectionModel(null);
        if (model == null) {
            this.setModel((ListModel)null);
        } else {
            this.setModel(model.getListModel());
            this.setSelectionModel(model);
        }
    }

    public void addCallback(CallbackWithReason<CallbackReason> cb) {
        this.callbacks = CallbackSupport.addCallbackToList(this.callbacks, cb, CallbackWithReason.class);
    }

    public void removeCallback(CallbackWithReason<CallbackReason> cb) {
        this.callbacks = CallbackSupport.removeCallbackFromList(this.callbacks, cb);
    }

    private void doCallback(CallbackReason reason) {
        CallbackSupport.fireCallbacks(this.callbacks, reason);
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public void setCellHeight(int cellHeight) {
        if (cellHeight < 1) {
            throw new IllegalArgumentException("cellHeight < 1");
        }
        this.cellHeight = cellHeight;
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public void setCellWidth(int cellWidth) {
        if (cellWidth < 1 && cellWidth != -1) {
            throw new IllegalArgumentException("cellWidth < 1");
        }
        this.cellWidth = cellWidth;
    }

    public boolean isFixedCellHeight() {
        return this.fixedCellHeight;
    }

    public void setFixedCellHeight(boolean fixedCellHeight) {
        this.fixedCellHeight = fixedCellHeight;
    }

    public boolean isFixedCellWidth() {
        return this.fixedCellWidth;
    }

    public void setFixedCellWidth(boolean fixedCellWidth) {
        this.fixedCellWidth = fixedCellWidth;
    }

    public boolean isRowMajor() {
        return this.rowMajor;
    }

    public void setRowMajor(boolean rowMajor) {
        this.rowMajor = rowMajor;
    }

    public int getFirstVisible() {
        return this.firstVisible;
    }

    public int getLastVisible() {
        return this.getFirstVisible() + this.labels.length - 1;
    }

    public void setFirstVisible(int firstVisible) {
        if (this.firstVisible != (firstVisible = Math.max(0, Math.min(firstVisible, this.numEntries - 1)))) {
            this.firstVisible = firstVisible;
            this.scrollbar.setValue(firstVisible / this.numCols, false);
            this.needUpdate = true;
        }
    }

    public int getSelected() {
        return this.selected;
    }

    public void setSelected(int selected) {
        this.setSelected(selected, true, CallbackReason.SET_SELECTED);
    }

    public void setSelected(int selected, boolean scroll) {
        this.setSelected(selected, scroll, CallbackReason.SET_SELECTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSelected(int selected, boolean scroll, CallbackReason reason) {
        if (selected < -1 || selected >= this.numEntries) {
            throw new IllegalArgumentException();
        }
        if (scroll) {
            this.validateLayout();
            if (selected == -1) {
                this.setFirstVisible(0);
            } else {
                int delta = this.getFirstVisible() - selected;
                if (delta > 0) {
                    int deltaRows = (delta + this.numCols - 1) / this.numCols;
                    this.setFirstVisible(this.getFirstVisible() - deltaRows * this.numCols);
                } else {
                    delta = selected - this.getLastVisible();
                    if (delta > 0) {
                        int deltaRows = (delta + this.numCols - 1) / this.numCols;
                        this.setFirstVisible(this.getFirstVisible() + deltaRows * this.numCols);
                    }
                }
            }
        }
        if (this.selected != selected) {
            this.selected = selected;
            if (this.selectionModel != null) {
                try {
                    this.inSetSelected = true;
                    this.selectionModel.setValue(selected);
                }
                finally {
                    this.inSetSelected = false;
                }
            }
            this.needUpdate = true;
            this.doCallback(reason);
        } else if (reason.actionRequested() || reason == CallbackReason.MOUSE_CLICK) {
            this.doCallback(reason);
        }
    }

    public void scrollToSelected() {
        this.setSelected(this.selected, true, CallbackReason.SET_SELECTED);
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public int getNumRows() {
        return (this.numEntries + this.numCols - 1) / this.numCols;
    }

    public int getNumColumns() {
        return this.numCols;
    }

    public int findEntryByName(String prefix) {
        int i;
        for (i = this.selected + 1; i < this.numEntries; ++i) {
            if (!this.model.matchPrefix(i, prefix)) continue;
            return i;
        }
        for (i = 0; i < this.selected; ++i) {
            if (!this.model.matchPrefix(i, prefix)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Widget getWidgetAt(int x, int y) {
        return this;
    }

    public int getEntryAt(int x, int y) {
        int n = Math.max(this.labels.length, this.numEntries - this.firstVisible);
        for (int i = 0; i < n; ++i) {
            if (!this.labels[i].getWidget().isInside(x, y)) continue;
            return this.firstVisible + i;
        }
        return -1;
    }

    @Override
    public void insertChild(Widget child, int index) throws IndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAllChildren() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Widget removeChild(int index) throws IndexOutOfBoundsException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.setCellHeight(themeInfo.getParameter("cellHeight", 20));
        this.setCellWidth(themeInfo.getParameter("cellWidth", -1));
        this.setRowMajor(themeInfo.getParameter("rowMajor", true));
        this.setFixedCellWidth(themeInfo.getParameter("fixedCellWidth", false));
        this.setFixedCellHeight(themeInfo.getParameter("fixedCellHeight", false));
        this.minDisplayedRows = themeInfo.getParameter("minDisplayedRows", 1);
    }

    protected void goKeyboard(int dir) {
        int newPos = this.selected + dir;
        if (newPos >= 0 && newPos < this.numEntries) {
            this.setSelected(newPos, true, CallbackReason.KEYBOARD);
        }
    }

    protected boolean isSearchChar(char ch) {
        return ch != '\u0000' && Character.isLetterOrDigit(ch);
    }

    @Override
    protected void keyboardFocusGained() {
        this.setLabelFocused(true);
    }

    @Override
    protected void keyboardFocusLost() {
        this.setLabelFocused(false);
    }

    private void setLabelFocused(boolean focused) {
        int idx = this.selected - this.firstVisible;
        if (idx >= 0 && idx < this.labels.length) {
            this.labels[idx].setFocused(focused);
        }
    }

    @Override
    public boolean handleEvent(Event evt) {
        switch (evt.getType()) {
            case MOUSE_WHEEL: {
                this.scrollbar.scroll(-evt.getMouseWheelDelta());
                return true;
            }
            case KEY_PRESSED: {
                switch (evt.getKeyCode()) {
                    case 200: {
                        this.goKeyboard(-this.numCols);
                        break;
                    }
                    case 208: {
                        this.goKeyboard(this.numCols);
                        break;
                    }
                    case 203: {
                        this.goKeyboard(-1);
                        break;
                    }
                    case 205: {
                        this.goKeyboard(1);
                        break;
                    }
                    case 201: {
                        if (this.numEntries <= 0) break;
                        this.setSelected(Math.max(0, this.selected - this.labels.length), true, CallbackReason.KEYBOARD);
                        break;
                    }
                    case 209: {
                        this.setSelected(Math.min(this.numEntries - 1, this.selected + this.labels.length), true, CallbackReason.KEYBOARD);
                        break;
                    }
                    case 199: {
                        if (this.numEntries <= 0) break;
                        this.setSelected(0, true, CallbackReason.KEYBOARD);
                        break;
                    }
                    case 207: {
                        this.setSelected(this.numEntries - 1, true, CallbackReason.KEYBOARD);
                        break;
                    }
                    case 28: {
                        this.setSelected(this.selected, false, CallbackReason.KEYBOARD_RETURN);
                        break;
                    }
                    default: {
                        if (!evt.hasKeyChar() || !this.isSearchChar(evt.getKeyChar())) break;
                        int idx = this.findEntryByName(Character.toString(evt.getKeyChar()));
                        if (idx != -1) {
                            this.setSelected(idx, true, CallbackReason.KEYBOARD);
                        }
                        return true;
                    }
                }
                return true;
            }
            case KEY_RELEASED: {
                return true;
            }
        }
        if (super.handleEvent(evt)) {
            return true;
        }
        return evt.isMouseEvent();
    }

    @Override
    public int getMinWidth() {
        return Math.max(super.getMinWidth(), this.scrollbar.getMinWidth());
    }

    @Override
    public int getMinHeight() {
        int minHeight = Math.max(super.getMinHeight(), this.scrollbar.getMinHeight());
        if (this.minDisplayedRows > 0) {
            minHeight = Math.max(minHeight, this.getBorderVertical() + Math.min(this.numEntries, this.minDisplayedRows) * this.cellHeight);
        }
        return minHeight;
    }

    @Override
    public int getPreferredInnerWidth() {
        return Math.max(super.getPreferredInnerWidth(), this.scrollbar.getPreferredWidth());
    }

    @Override
    public int getPreferredInnerHeight() {
        return Math.max(this.getNumRows() * this.getCellHeight(), this.scrollbar.getPreferredHeight());
    }

    @Override
    protected void paint(GUI gui) {
        if (this.needUpdate) {
            this.updateDisplay();
        }
        int maxFirstVisibleRow = this.computeMaxFirstVisibleRow();
        this.scrollbar.setMinMaxValue(0, maxFirstVisibleRow);
        this.scrollbar.setValue(this.firstVisible / this.numCols, false);
        super.paint(gui);
    }

    private int computeMaxFirstVisibleRow() {
        int maxFirstVisibleRow = Math.max(0, this.numEntries - this.labels.length);
        maxFirstVisibleRow = (maxFirstVisibleRow + this.numCols - 1) / this.numCols;
        return maxFirstVisibleRow;
    }

    private void updateDisplay() {
        int maxFirstVisibleRow;
        int maxFirstVisible;
        this.needUpdate = false;
        if (this.selected >= this.numEntries) {
            this.selected = -1;
        }
        if (this.firstVisible > (maxFirstVisible = (maxFirstVisibleRow = this.computeMaxFirstVisibleRow()) * this.numCols)) {
            this.firstVisible = Math.max(0, maxFirstVisible);
        }
        boolean hasFocus = this.hasKeyboardFocus();
        for (int i = 0; i < this.labels.length; ++i) {
            ListBoxDisplay label = this.labels[i];
            int cell = i + this.firstVisible;
            if (cell < this.numEntries) {
                label.setData(this.model.getEntry(cell));
                label.setTooltipContent(this.model.getEntryTooltip(cell));
            } else {
                label.setData(null);
                label.setTooltipContent(null);
            }
            label.setSelected(cell == this.selected);
            label.setFocused(cell == this.selected && hasFocus);
        }
    }

    @Override
    protected void layout() {
        this.scrollbar.setSize(this.scrollbar.getPreferredWidth(), this.getInnerHeight());
        this.scrollbar.setPosition(this.getInnerRight() - this.scrollbar.getWidth(), this.getInnerY());
        int numRows = Math.max(1, this.getInnerHeight() / this.cellHeight);
        this.numCols = this.cellWidth != -1 ? Math.max(1, (this.scrollbar.getX() - this.getInnerX()) / this.cellWidth) : 1;
        this.setVisibleCells(numRows);
        this.needUpdate = true;
    }

    private void setVisibleCells(int numRows) {
        int curVisible;
        int visibleCells = numRows * this.numCols;
        assert (visibleCells >= 1);
        this.scrollbar.setPageSize(visibleCells);
        int i = curVisible = this.labels.length;
        while (i-- > visibleCells) {
            super.removeChild(1 + i);
        }
        ListBoxDisplay[] newLabels = new ListBoxDisplay[visibleCells];
        System.arraycopy(this.labels, 0, newLabels, 0, Math.min(visibleCells, this.labels.length));
        this.labels = newLabels;
        for (int i2 = curVisible; i2 < visibleCells; ++i2) {
            final int cellOffset = i2;
            ListBoxDisplay lbd = this.createDisplay();
            lbd.addListBoxCallback(new CallbackWithReason<CallbackReason>(){

                @Override
                public void callback(CallbackReason reason) {
                    int cell = ListBox.this.getFirstVisible() + cellOffset;
                    if (cell < ListBox.this.getNumEntries()) {
                        ListBox.this.setSelected(cell, false, reason);
                    }
                }
            });
            super.insertChild(lbd.getWidget(), 1 + i2);
            this.labels[i2] = lbd;
        }
        int innerWidth = this.scrollbar.getX() - this.getInnerX();
        int innerHeight = this.getInnerHeight();
        for (int i3 = 0; i3 < visibleCells; ++i3) {
            int w;
            int x;
            int h;
            int y;
            int col;
            int row;
            if (this.rowMajor) {
                row = i3 / this.numCols;
                col = i3 % this.numCols;
            } else {
                row = i3 % numRows;
                col = i3 / numRows;
            }
            if (this.fixedCellHeight) {
                y = row * this.cellHeight;
                h = this.cellHeight;
            } else {
                y = row * innerHeight / numRows;
                h = (row + 1) * innerHeight / numRows - y;
            }
            if (this.fixedCellWidth && this.cellWidth != -1) {
                x = col * this.cellWidth;
                w = this.cellWidth;
            } else {
                x = col * innerWidth / this.numCols;
                w = (col + 1) * innerWidth / this.numCols - x;
            }
            Widget cell = (Widget)((Object)this.labels[i3]);
            cell.setSize(Math.max(0, w), Math.max(0, h));
            cell.setPosition(x + this.getInnerX(), y + this.getInnerY());
        }
    }

    protected ListBoxDisplay createDisplay() {
        return new ListBoxLabel();
    }

    void entriesInserted(int first, int last) {
        int s;
        int delta = last - first + 1;
        int prevNumEntries = this.numEntries;
        this.numEntries += delta;
        int fv = this.getFirstVisible();
        if (fv >= first && prevNumEntries >= this.labels.length) {
            this.setFirstVisible(fv += delta);
        }
        if ((s = this.getSelected()) >= first) {
            this.setSelected(s + delta, false, CallbackReason.MODEL_CHANGED);
        }
        if (first <= this.getLastVisible() && last >= fv) {
            this.needUpdate = true;
        }
    }

    void entriesDeleted(int first, int last) {
        int delta = last - first + 1;
        this.numEntries -= delta;
        int fv = this.getFirstVisible();
        int lv = this.getLastVisible();
        if (fv > last) {
            this.setFirstVisible(fv - delta);
        } else if (fv <= last && lv >= first) {
            this.setFirstVisible(first);
        }
        int s = this.getSelected();
        if (s > last) {
            this.setSelected(s - delta, false, CallbackReason.MODEL_CHANGED);
        } else if (s >= first && s <= last) {
            this.setSelected(-1, false, CallbackReason.MODEL_CHANGED);
        }
    }

    void entriesChanged(int first, int last) {
        int fv = this.getFirstVisible();
        int lv = this.getLastVisible();
        if (fv <= last && lv >= first) {
            this.needUpdate = true;
        }
    }

    void allChanged() {
        this.numEntries = this.model != null ? this.model.getNumEntries() : 0;
        this.setSelected(-1, false, CallbackReason.MODEL_CHANGED);
        this.setFirstVisible(0);
        this.needUpdate = true;
    }

    void scrollbarChanged() {
        this.setFirstVisible(this.scrollbar.getValue() * this.numCols);
    }

    void syncSelectionFromModel() {
        if (!this.inSetSelected) {
            this.setSelected(this.selectionModel.getValue());
        }
    }

    private class LImpl
    implements ListModel.ChangeListener,
    Runnable {
        private LImpl() {
        }

        @Override
        public void entriesInserted(int first, int last) {
            ListBox.this.entriesInserted(first, last);
        }

        @Override
        public void entriesDeleted(int first, int last) {
            ListBox.this.entriesDeleted(first, last);
        }

        @Override
        public void entriesChanged(int first, int last) {
            ListBox.this.entriesChanged(first, last);
        }

        @Override
        public void allChanged() {
            ListBox.this.allChanged();
        }

        @Override
        public void run() {
            ListBox.this.scrollbarChanged();
        }
    }

    protected static class ListBoxLabel
    extends TextWidget
    implements ListBoxDisplay {
        public static final AnimationState.StateKey STATE_SELECTED = AnimationState.StateKey.get("selected");
        public static final AnimationState.StateKey STATE_EMPTY = AnimationState.StateKey.get("empty");
        private boolean selected;
        private CallbackWithReason<?>[] callbacks;

        public ListBoxLabel() {
            this.setClip(true);
            this.setTheme("display");
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public void setSelected(boolean selected) {
            if (this.selected != selected) {
                this.selected = selected;
                this.getAnimationState().setAnimationState(STATE_SELECTED, selected);
            }
        }

        @Override
        public boolean isFocused() {
            return this.getAnimationState().getAnimationState(STATE_KEYBOARD_FOCUS);
        }

        @Override
        public void setFocused(boolean focused) {
            this.getAnimationState().setAnimationState(STATE_KEYBOARD_FOCUS, focused);
        }

        @Override
        public void setData(Object data) {
            this.setCharSequence(data == null ? "" : data.toString());
            this.getAnimationState().setAnimationState(STATE_EMPTY, data == null);
        }

        @Override
        public Widget getWidget() {
            return this;
        }

        @Override
        public void addListBoxCallback(CallbackWithReason<CallbackReason> cb) {
            this.callbacks = CallbackSupport.addCallbackToList(this.callbacks, cb, CallbackWithReason.class);
        }

        @Override
        public void removeListBoxCallback(CallbackWithReason<CallbackReason> cb) {
            this.callbacks = CallbackSupport.removeCallbackFromList(this.callbacks, cb);
        }

        protected void doListBoxCallback(CallbackReason reason) {
            CallbackSupport.fireCallbacks(this.callbacks, reason);
        }

        protected boolean handleListBoxEvent(Event evt) {
            switch (evt.getType()) {
                case MOUSE_BTNDOWN: {
                    if (!this.selected) {
                        this.doListBoxCallback(CallbackReason.MOUSE_CLICK);
                    }
                    return true;
                }
                case MOUSE_CLICKED: {
                    if (this.selected && evt.getMouseClickCount() == 2) {
                        this.doListBoxCallback(CallbackReason.MOUSE_DOUBLE_CLICK);
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        protected boolean handleEvent(Event evt) {
            this.handleMouseHover(evt);
            if (!evt.isMouseDragEvent() && this.handleListBoxEvent(evt)) {
                return true;
            }
            if (super.handleEvent(evt)) {
                return true;
            }
            return evt.isMouseEventNoWheel();
        }
    }

    public static enum CallbackReason {
        MODEL_CHANGED(false),
        SET_SELECTED(false),
        MOUSE_CLICK(false),
        MOUSE_DOUBLE_CLICK(true),
        KEYBOARD(false),
        KEYBOARD_RETURN(true);

        final boolean forceCallback;

        private CallbackReason(boolean forceCallback) {
            this.forceCallback = forceCallback;
        }

        public boolean actionRequested() {
            return this.forceCallback;
        }
    }
}

