/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.vmfixes.mixin;

import com.mamiyaotaru.voxelmap.interfaces.AbstractMapData;
import com.mamiyaotaru.voxelmap.interfaces.IChangeObserver;
import com.mamiyaotaru.voxelmap.interfaces.IPersistentMap;
import com.mamiyaotaru.voxelmap.persistent.PersistentMap;
import com.mamiyaotaru.voxelmap.util.BlockRepository;
import com.mamiyaotaru.voxelmap.util.MutableBlockPos;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={PersistentMap.class})
public abstract class PersistentMapMixin
implements IPersistentMap,
IChangeObserver {
    @Overwrite(remap=false)
    public void getAndStoreData(AbstractMapData mapData, World world, Chunk chunk, MutableBlockPos blockPos, boolean underground, int startX, int startZ, int imageX, int imageY) {
        blockPos = blockPos.withXYZ(startX + imageX, 0, startZ + imageY);
        int biomeID = !chunk.func_76621_g() ? Biome.func_185362_a((Biome)chunk.func_177411_a((BlockPos)blockPos, world.field_73011_w.func_177499_m())) : -1;
        mapData.setBiomeID(imageX, imageY, biomeID);
        if (biomeID == -1) {
            return;
        }
        boolean solid = false;
        int surfaceHeight = this.getBlockHeight(underground, chunk, blockPos, startX + imageX, startZ + imageY);
        IBlockState blockState = chunk.func_177435_g((BlockPos)blockPos.withXYZ(startX + imageX, surfaceHeight, startZ + imageY));
        if (blockState.func_185904_a() != Material.field_151597_y) {
            blockState = chunk.func_177435_g((BlockPos)blockPos.withXYZ(startX + imageX, surfaceHeight - 1, startZ + imageY));
        }
        blockState = blockState.func_177230_c().hasTileEntity(blockState) ? blockState.func_177230_c().func_176223_P() : blockState.func_185899_b((IBlockAccess)world, (BlockPos)blockPos);
        mapData.setHeight(imageX, imageY, surfaceHeight);
        mapData.setBlockstate(imageX, imageY, blockState);
        if (surfaceHeight == -1) {
            surfaceHeight = 80;
            solid = true;
        }
        if (blockState.func_185904_a() == Material.field_151587_i) {
            solid = false;
        }
        if (!solid) {
            int light = this.getLight(blockState, chunk, blockPos, startX + imageX, startZ + imageY, surfaceHeight, solid);
            mapData.setLight(imageX, imageY, light);
        }
        int seafloorHeight = 0;
        int seafloorLight = 0;
        int underwaterTransparentHeight = 0;
        Material material = blockState.func_185904_a();
        if (material == Material.field_151586_h || material == Material.field_151588_w) {
            int[] underwaterHeights = this.getSeafloorHeight(chunk, blockPos, startX + imageX, startZ + imageY, surfaceHeight);
            seafloorHeight = underwaterHeights[0];
            underwaterTransparentHeight = underwaterHeights[1];
            blockPos.setXYZ(startX + imageX, seafloorHeight - 1, startZ + imageY);
            blockState = chunk.func_177435_g((BlockPos)blockPos);
            if (blockState.func_185904_a() == Material.field_151586_h) {
                blockState = BlockRepository.air.func_176223_P();
            }
        }
        if (blockState != BlockRepository.air.func_176223_P()) {
            blockState = blockState.func_177230_c().hasTileEntity(blockState) ? blockState.func_177230_c().func_176223_P() : blockState.func_185899_b((IBlockAccess)world, (BlockPos)blockPos);
            seafloorLight = this.getLight(blockState, chunk, blockPos, startX + imageX, startZ + imageY, seafloorHeight, solid);
        }
        mapData.setOceanFloorHeight(imageX, imageY, seafloorHeight);
        mapData.setOceanFloorBlockstate(imageX, imageY, blockState);
        mapData.setOceanFloorLight(imageX, imageY, seafloorLight);
        int transparentLight = 0;
        int transparentHeight = this.getTransparentHeight(underground, chunk, blockPos, startX + imageX, startZ + imageY, surfaceHeight);
        if (transparentHeight == 0 && underwaterTransparentHeight > 0) {
            transparentHeight = underwaterTransparentHeight;
        }
        if (transparentHeight != 0) {
            blockPos.setXYZ(startX + imageX, transparentHeight - 1, startZ + imageY);
            blockState = chunk.func_177435_g((BlockPos)blockPos);
        } else {
            blockState = BlockRepository.air.func_176223_P();
        }
        if (blockState != BlockRepository.air.func_176223_P()) {
            blockState = blockState.func_177230_c().hasTileEntity(blockState) ? blockState.func_177230_c().func_176223_P() : blockState.func_185899_b((IBlockAccess)world, (BlockPos)blockPos);
            transparentLight = this.getLight(blockState, chunk, blockPos, startX + imageX, startZ + imageY, transparentHeight, solid);
        }
        mapData.setTransparentHeight(imageX, imageY, transparentHeight);
        mapData.setTransparentBlockstate(imageX, imageY, blockState);
        mapData.setTransparentLight(imageX, imageY, transparentLight);
        int foliageHeight = 0;
        int foliageLight = 0;
        IBlockState foliageBlockState = null;
        if (transparentHeight != surfaceHeight + 1 && !solid) {
            foliageHeight = surfaceHeight + 1;
            blockPos.setXYZ(startX + imageX, foliageHeight - 1, startZ + imageY);
            foliageBlockState = chunk.func_177435_g((BlockPos)blockPos);
            material = foliageBlockState.func_185904_a();
            if (material == Material.field_151597_y || material == Material.field_151579_a || material == Material.field_151587_i) {
                foliageHeight = 0;
            }
            if (foliageBlockState == blockState) {
                foliageHeight = 0;
            }
        }
        if (foliageHeight == 0 && !solid && seafloorHeight > 0 && transparentHeight != seafloorHeight + 1) {
            foliageHeight = seafloorHeight + 1;
            blockPos.setXYZ(startX + imageX, foliageHeight - 1, startZ + imageY);
            foliageBlockState = chunk.func_177435_g((BlockPos)blockPos);
            material = foliageBlockState.func_185904_a();
            if (material == Material.field_151579_a || material == Material.field_151587_i || material == Material.field_151586_h || material == Material.field_151588_w) {
                foliageHeight = 0;
            }
            if (foliageBlockState == blockState) {
                foliageHeight = 0;
            }
        }
        if ((blockState = foliageHeight != 0 ? foliageBlockState : BlockRepository.air.func_176223_P()) != BlockRepository.air.func_176223_P()) {
            blockState = blockState.func_177230_c().hasTileEntity(blockState) ? blockState.func_177230_c().func_176223_P() : blockState.func_185899_b((IBlockAccess)world, (BlockPos)blockPos);
            foliageLight = this.getLight(blockState, chunk, blockPos, startX + imageX, startZ + imageY, foliageHeight, solid);
        }
        mapData.setFoliageHeight(imageX, imageY, foliageHeight);
        mapData.setFoliageBlockstate(imageX, imageY, blockState);
        mapData.setFoliageLight(imageX, imageY, foliageLight);
    }

    @Shadow
    protected abstract int getBlockHeight(boolean var1, Chunk var2, MutableBlockPos var3, int var4, int var5);

    @Shadow
    protected abstract int getLight(IBlockState var1, Chunk var2, MutableBlockPos var3, int var4, int var5, int var6, boolean var7);

    @Shadow
    protected abstract int[] getSeafloorHeight(Chunk var1, MutableBlockPos var2, int var3, int var4, int var5);

    @Shadow
    protected abstract int getTransparentHeight(boolean var1, Chunk var2, MutableBlockPos var3, int var4, int var5, int var6);
}

