/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.vmfixes;

import java.awt.image.BufferedImage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="vmfixes", name="VoxelMap Fixes", version="1.12.2-1.0.7", acceptedMinecraftVersions="[1.12.2]", dependencies="required-after:mixinbooter;required-after:voxelmap", clientSideOnly=true)
public class VMFixes {
    public static final String MODID = "vmfixes";
    public static final String NAME = "VoxelMap Fixes";
    public static final String VERSION = "1.12.2-1.0.7";
    public static final Logger LOGGER = LogManager.getLogger();

    public static BufferedImage getBufferedImage(TextureAtlasSprite textureAtlasSprite) {
        int iconWidth = textureAtlasSprite.func_94211_a();
        int iconHeight = textureAtlasSprite.func_94216_b();
        int frameCount = textureAtlasSprite.func_110970_k();
        if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(iconWidth, iconHeight * frameCount, 6);
        for (int i = 0; i < frameCount; ++i) {
            int[][] frameTextureData = textureAtlasSprite.func_147965_a(i);
            int[] largestMipMapTextureData = frameTextureData[0];
            bufferedImage.setRGB(0, i * iconHeight, iconWidth, iconHeight, largestMipMapTextureData, 0, iconWidth);
        }
        return bufferedImage;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LOGGER.info("VoxelMap Fixes initialized");
    }
}

