/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.betterattributes;

import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.Network;
import com.fantasticsource.mctools.betterattributes.BetterAttributeMod;
import com.fantasticsource.tools.ReflectionTool;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.datastructures.ExplicitPriorityQueue;
import com.fantasticsource.tools.datastructures.Pair;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BetterAttribute {
    public static final boolean DEBUG_MODS = false;
    public static final HashMap<String, BetterAttribute> BETTER_ATTRIBUTES = new HashMap();
    public static final Field MODIFIABLE_ATTRIBUTE_INSTANCE_NEEDS_UPDATE_FIELD = ReflectionTool.getField(ModifiableAttributeInstance.class, "field_111133_g", "needsUpdate");
    public static final Field PLAYER_CAPABILITIES_WALK_SPEED_FIELD = ReflectionTool.getField(PlayerCapabilities.class, "field_75097_g", "walkSpeed");
    public final String name;
    public final double defaultBaseAmount;
    public boolean isGood = true;
    public boolean canUseTotalAmountCaching = true;
    public boolean syncClientEntityDataToClient = true;
    public boolean syncOtherEntityDataToClient = false;
    public ArrayList<BetterAttributeMod> parentMods = new ArrayList();
    public ArrayList<BetterAttribute> children = new ArrayList();
    public IAttribute mcAttributeToSet = null;
    public double mcAttributeScalar = 1.0;
    public ArrayList<Predicate<Pair<Entity, ArrayList<String>>>> displayValueArgumentEditors = new ArrayList();

    public static void register(BetterAttribute betterAttribute) {
        String name = betterAttribute.name;
        for (BetterAttributeMod parentMod : betterAttribute.parentMods) {
            if (BETTER_ATTRIBUTES.get(parentMod.parentAttributeName) != null) continue;
            System.err.println(TextFormatting.RED + "COULD NOT REGISTER BETTER ATTRIBUTE, BECAUSE ONE OF ITS PARENTS IS NULL: " + name);
            return;
        }
        if (BETTER_ATTRIBUTES.containsKey(name)) {
            System.err.println(TextFormatting.RED + "COULD NOT REGISTER BETTER ATTRIBUTE, BECAUSE IT ALREADY EXISTS: " + name);
            return;
        }
        BETTER_ATTRIBUTES.put(name, betterAttribute);
    }

    public BetterAttribute(String name, BetterAttribute ... parents) {
        this(name, 0.0, parents);
    }

    public BetterAttribute(String name, double defaultBaseAmount, BetterAttribute ... parents) {
        this(name, defaultBaseAmount, 0, parents);
    }

    public BetterAttribute(String name, double defaultBaseAmount, int parentsOperation, BetterAttribute ... parents) {
        this(name, defaultBaseAmount, true, BetterAttribute.genParentMods(name, parentsOperation, parents));
    }

    public BetterAttribute(String name, double defaultBaseAmount, int parentsOperation, Pair<BetterAttribute, Double> ... parents) {
        this(name, defaultBaseAmount, true, BetterAttribute.genParentMods(name, parentsOperation, parents));
    }

    public BetterAttribute(String name, double defaultBaseAmount, boolean ignored, BetterAttributeMod ... parentMods) {
        this.name = name;
        this.defaultBaseAmount = defaultBaseAmount;
        this.parentMods.addAll(Arrays.asList(parentMods));
        for (BetterAttributeMod parentMod : parentMods) {
            BetterAttribute.BETTER_ATTRIBUTES.get((Object)parentMod.parentAttributeName).children.add(this);
        }
        BetterAttribute.register(this);
    }

    protected static BetterAttributeMod[] genParentMods(String attributeName, int operation, BetterAttribute ... parents) {
        BetterAttributeMod[] mods = new BetterAttributeMod[parents.length];
        for (int i = 0; i < mods.length; ++i) {
            mods[i] = new BetterAttributeMod("Parent", attributeName, operation * 100, operation, 1.0);
            mods[i].parentAttributeName = parents[i].name;
        }
        return mods;
    }

    protected static BetterAttributeMod[] genParentMods(String attributeName, int operation, Pair<BetterAttribute, Double> ... parents) {
        BetterAttributeMod[] mods = new BetterAttributeMod[parents.length];
        for (int i = 0; i < mods.length; ++i) {
            mods[i] = new BetterAttributeMod("Parent", attributeName, operation * 100, operation, (double)parents[i].getValue());
            mods[i].parentAttributeName = parents[i].getKey().name;
        }
        return mods;
    }

    public final void setBaseAmount(Entity entity, double amount) {
        if (amount == this.getBaseAmount(entity)) {
            return;
        }
        if (amount == this.defaultBaseAmount) {
            NBTTagCompound compound = MCTools.getSubCompoundIfExists(entity.getEntityData(), "fantasticlib", "baseAttributes");
            if (compound != null) {
                compound.func_82580_o(this.name);
            }
        } else {
            MCTools.getOrGenerateSubCompound(entity.getEntityData(), "fantasticlib", "baseAttributes").func_74780_a(this.name, amount);
        }
        this.calculateTotal(entity);
    }

    public double getBaseAmount(Entity entity) {
        NBTTagCompound compound = MCTools.getSubCompoundIfExists(entity.getEntityData(), "fantasticlib", "baseAttributes");
        return compound == null || !compound.func_74764_b(this.name) ? this.defaultBaseAmount : compound.func_74769_h(this.name);
    }

    protected final double calculateTotal(Entity entity) {
        AttributeMap attributeMap;
        ModifiableAttributeInstance attributeInstance;
        double result = this.getBaseAmount(entity);
        BetterAttributeCalcEvent event = new BetterAttributeCalcEvent(this, entity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.functions.isEmpty()) {
            double[] d = new double[]{result, result};
            int oldTier = (int)event.functions.peekPriority();
            int newTier = 0;
            while (!event.functions.isEmpty() && event.functions.poll().test(d)) {
                newTier = (int)event.functions.peekPriority();
                if (newTier == oldTier) continue;
                d[1] = d[0];
                oldTier = newTier;
            }
            result = d[0];
        }
        if (this.mcAttributeToSet != null && entity instanceof EntityLivingBase && (attributeInstance = (attributeMap = (AttributeMap)((EntityLivingBase)entity).func_110140_aT()).func_111151_a(this.mcAttributeToSet)) != null) {
            double convertedAmount = result * this.mcAttributeScalar;
            attributeInstance.func_111128_a(convertedAmount);
            ReflectionTool.set(MODIFIABLE_ATTRIBUTE_INSTANCE_NEEDS_UPDATE_FIELD, attributeInstance, true);
            if (entity instanceof EntityPlayerMP && this.mcAttributeToSet == SharedMonsterAttributes.field_111263_d) {
                ReflectionTool.set(PLAYER_CAPABILITIES_WALK_SPEED_FIELD, ((EntityPlayer)entity).field_71075_bZ, Float.valueOf((float)convertedAmount));
            }
        }
        if (this.canUseTotalAmountCaching) {
            NBTTagCompound compound = MCTools.getOrGenerateSubCompound(entity.getEntityData(), "fantasticlib", "attributes");
            compound.func_74780_a(this.name, result);
        }
        MinecraftForge.EVENT_BUS.post((Event)new BetterAttributeChangedEvent(this, entity));
        this.sync(entity);
        for (BetterAttribute child : this.children) {
            if (!child.canUseTotalAmountCaching) continue;
            child.calculateTotal(entity);
        }
        return result;
    }

    public final double getTotalAmount(Entity entity) {
        NBTTagCompound compound;
        if (this.canUseTotalAmountCaching && (compound = MCTools.getOrGenerateSubCompound(entity.getEntityData(), "fantasticlib", "attributes")).func_74764_b(this.name)) {
            return compound.func_74769_h(this.name);
        }
        return this.calculateTotal(entity);
    }

    public void setCurrentAmount(Entity entity, double amount) {
        if (amount == this.getCurrentAmount(entity)) {
            return;
        }
        MCTools.getOrGenerateSubCompound(entity.getEntityData(), "fantasticlib", "currentAttributes").func_74780_a(this.name, amount);
        if (this.mcAttributeToSet == SharedMonsterAttributes.field_111267_a && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70606_j((float)amount);
        }
        MinecraftForge.EVENT_BUS.post((Event)new BetterAttributeChangedEvent(this, entity));
        this.sync(entity);
    }

    public double getCurrentAmount(Entity entity) {
        if (this.mcAttributeToSet == SharedMonsterAttributes.field_111267_a && entity instanceof EntityLivingBase) {
            return ((EntityLivingBase)entity).func_110143_aJ();
        }
        NBTTagCompound compound = MCTools.getSubCompoundIfExists(entity.getEntityData(), "fantasticlib", "currentAttributes");
        if (compound == null || !compound.func_74764_b(this.name)) {
            return this.getTotalAmount(entity);
        }
        return compound.func_74769_h(this.name);
    }

    public final void sync(Entity entity) {
        if (!entity.field_70170_p.field_72995_K) {
            if (this.syncOtherEntityDataToClient) {
                MCTools.sendToAllTracking(Network.WRAPPER, new Network.BetterAttributePacket(entity, this), entity);
            } else if (this.syncClientEntityDataToClient && entity instanceof EntityPlayerMP) {
                Network.WRAPPER.sendTo((IMessage)new Network.BetterAttributePacket(entity, this), (EntityPlayerMP)entity);
            }
        }
    }

    public BetterAttribute setMCAttribute(IAttribute mcAttribute, double scalar) {
        this.mcAttributeToSet = mcAttribute;
        this.mcAttributeScalar = scalar;
        return this;
    }

    public BetterAttribute addDisplayValueArgumentEditor(Predicate<Pair<Entity, ArrayList<String>>> predicate) {
        this.displayValueArgumentEditors.add(predicate);
        return this;
    }

    public String getLocalizedName() {
        return I18n.func_74838_a((String)("attribute.name." + this.name));
    }

    public String getLocalizedDisplayValue(Entity entity) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(Tools.formatNicely(this.getTotalAmount(entity)));
        args.add(Tools.formatNicely(this.getBaseAmount(entity)));
        args.add(Tools.formatNicely(this.getCurrentAmount(entity)));
        for (Predicate<Pair<Entity, ArrayList<String>>> editor : this.displayValueArgumentEditors) {
            editor.test(new Pair(entity, args));
        }
        String result = I18n.func_74837_a((String)("attribute.value." + this.name), (Object[])args.toArray());
        return result.contains("attribute.value") ? "" + (String)args.get(0) : result;
    }

    public String getLocalizedDescription() {
        return I18n.func_74838_a((String)("attribute.description." + this.name));
    }

    public static class BetterAttributeChangedEvent
    extends Event {
        public final BetterAttribute attribute;
        public final Entity entity;

        public BetterAttributeChangedEvent(BetterAttribute attribute, Entity entity) {
            this.attribute = attribute;
            this.entity = entity;
        }
    }

    public static class BetterAttributeCalcEvent
    extends Event {
        public final BetterAttribute attribute;
        public final Entity entity;
        public final ExplicitPriorityQueue<Predicate<double[]>> functions = new ExplicitPriorityQueue();

        protected BetterAttributeCalcEvent(BetterAttribute attribute, Entity entity) {
            this.attribute = attribute;
            this.entity = entity;
        }
    }
}

