/*
 * Decompiled with CFR 0.152.
 */
package com.leviathanstudio.craftstudio.client.animation;

import com.leviathanstudio.craftstudio.CraftStudioApi;
import com.leviathanstudio.craftstudio.client.animation.CSAnimChannel;
import com.leviathanstudio.craftstudio.client.animation.ClientChannel;
import com.leviathanstudio.craftstudio.client.animation.EnumAnimationMode;
import com.leviathanstudio.craftstudio.client.animation.KeyFrame;
import com.leviathanstudio.craftstudio.client.model.CSModelRenderer;
import com.leviathanstudio.craftstudio.common.animation.AnimationHandler;
import com.leviathanstudio.craftstudio.common.animation.Channel;
import com.leviathanstudio.craftstudio.common.animation.CustomChannel;
import com.leviathanstudio.craftstudio.common.animation.IAnimated;
import com.leviathanstudio.craftstudio.common.animation.InfoChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientAnimationHandler<T extends IAnimated>
extends AnimationHandler<T> {
    private Map<String, InfoChannel> animChannels = new HashMap<String, InfoChannel>();
    private Map<T, Map<InfoChannel, AnimationHandler.AnimInfo>> currentAnimInfo = new WeakHashMap<T, Map<InfoChannel, AnimationHandler.AnimInfo>>();

    @Override
    public void addAnim(String modid, String animNameIn, String modelNameIn, boolean looped) {
        super.addAnim(modid, animNameIn, modelNameIn, looped);
        ResourceLocation anim = new ResourceLocation(modid, animNameIn);
        ResourceLocation model = new ResourceLocation(modid, modelNameIn);
        this.animChannels.put(anim.toString(), new CSAnimChannel(anim, model, looped));
    }

    @Override
    public void addAnim(String modid, String animNameIn, CustomChannel customChannelIn) {
        super.addAnim(modid, animNameIn, customChannelIn);
        ResourceLocation anim = new ResourceLocation(modid, animNameIn);
        this.animChannels.put(anim.toString(), customChannelIn);
    }

    @Override
    public void addAnim(String modid, String invertedAnimationName, String animationToInvert) {
        super.addAnim(modid, invertedAnimationName, animationToInvert);
        ResourceLocation anim = new ResourceLocation(modid, invertedAnimationName);
        ResourceLocation toInvert = new ResourceLocation(modid, animationToInvert);
        if (this.animChannels.get(toInvert.toString()) instanceof ClientChannel) {
            ClientChannel channel = ((ClientChannel)this.animChannels.get(toInvert.toString())).getInvertedChannel(invertedAnimationName);
            channel.name = anim.toString();
            this.animChannels.put(anim.toString(), channel);
        }
    }

    @Override
    public boolean clientStartAnimation(String res, float startingFrame, T animatedElement) {
        if (this.animChannels.get(res) == null) {
            CraftStudioApi.getLogger().warn("The animation called " + res + " doesn't exist!");
            return false;
        }
        Map<InfoChannel, AnimationHandler.AnimInfo> animInfoMap = this.currentAnimInfo.get(animatedElement);
        if (animInfoMap == null) {
            animInfoMap = new HashMap<InfoChannel, AnimationHandler.AnimInfo>();
            this.currentAnimInfo.put(animatedElement, animInfoMap);
        }
        InfoChannel selectedChannel = this.animChannels.get(res);
        animInfoMap.remove(selectedChannel);
        animInfoMap.put(selectedChannel, new AnimationHandler.AnimInfo(System.nanoTime(), startingFrame));
        return true;
    }

    @Override
    protected boolean serverInitAnimation(String res, float startingFrame, T animatedElement) {
        return this.animChannels.containsKey(res);
    }

    @Override
    protected boolean serverStartAnimation(String res, float endingFrame, T animatedElement) {
        return this.animChannels.containsKey(res);
    }

    @Override
    public boolean clientStopAnimation(String res, T animatedElement) {
        if (!this.animChannels.containsKey(res)) {
            CraftStudioApi.getLogger().warn("The animation stopped " + res + " doesn't exist!");
            return false;
        }
        Map<InfoChannel, AnimationHandler.AnimInfo> animInfoMap = this.currentAnimInfo.get(animatedElement);
        if (animInfoMap == null) {
            return false;
        }
        InfoChannel selectedChannel = this.animChannels.get(res);
        animInfoMap.remove(selectedChannel);
        if (animInfoMap.isEmpty()) {
            this.currentAnimInfo.remove(animatedElement);
        }
        return true;
    }

    @Override
    protected boolean serverStopAnimation(String res, T animatedElement) {
        return this.currentAnimInfo.containsKey(animatedElement);
    }

    @Override
    public void animationsUpdate(T animatedElement) {
        Map<InfoChannel, AnimationHandler.AnimInfo> animInfoMap = this.currentAnimInfo.get(animatedElement);
        if (animInfoMap == null) {
            return;
        }
        Iterator<Map.Entry<InfoChannel, AnimationHandler.AnimInfo>> it = animInfoMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<InfoChannel, AnimationHandler.AnimInfo> animInfo = it.next();
            animInfo.getValue();
            boolean canUpdate = this.canUpdateAnimation(animInfo.getKey(), animatedElement);
            if (canUpdate) continue;
            it.remove();
        }
    }

    @Override
    public boolean isAnimationActive(String name, T animatedElement) {
        InfoChannel anim = this.animChannels.get(name);
        if (anim == null) {
            return false;
        }
        Map<InfoChannel, AnimationHandler.AnimInfo> animInfoMap = this.currentAnimInfo.get(animatedElement);
        if (animInfoMap == null) {
            return false;
        }
        if (animInfoMap.containsKey(anim)) {
            AnimationHandler.AnimInfo info = animInfoMap.get(anim);
            if (anim instanceof CustomChannel || info.currentFrame < (float)(anim.totalFrames - 1)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isHoldAnimationActive(String name, T animatedElement) {
        InfoChannel anim = this.animChannels.get(name);
        if (anim == null) {
            return false;
        }
        Map<InfoChannel, AnimationHandler.AnimInfo> animInfoMap = this.currentAnimInfo.get(animatedElement);
        if (animInfoMap == null) {
            return false;
        }
        return animInfoMap.containsKey(anim);
    }

    @Override
    public boolean canUpdateAnimation(Channel channel, T animatedElement) {
        Map<InfoChannel, AnimationHandler.AnimInfo> animInfoMap = this.currentAnimInfo.get(animatedElement);
        if (animInfoMap == null) {
            return false;
        }
        long currentTime = System.nanoTime();
        if (!(channel instanceof InfoChannel)) {
            return false;
        }
        InfoChannel infoChannel = (InfoChannel)channel;
        AnimationHandler.AnimInfo animInfo = animInfoMap.get(channel);
        if (!ClientAnimationHandler.isGamePaused()) {
            if (infoChannel instanceof ClientChannel) {
                ClientChannel clientChannel = (ClientChannel)infoChannel;
                double deltaTime = (double)(currentTime - animInfo.prevTime) / 1.0E9;
                float numberOfSkippedFrames = (float)(deltaTime * (double)channel.fps);
                float currentFrame = animInfo.currentFrame + numberOfSkippedFrames;
                if (currentFrame < (float)(clientChannel.totalFrames - 1)) {
                    animInfo.prevTime = currentTime;
                    animInfo.currentFrame = currentFrame;
                    return true;
                }
                if (clientChannel.getAnimationMode() == EnumAnimationMode.LOOP) {
                    animInfo.prevTime = currentTime;
                    animInfo.currentFrame = 0.0f;
                    return true;
                }
                if (clientChannel.getAnimationMode() == EnumAnimationMode.HOLD) {
                    animInfo.prevTime = currentTime;
                    animInfo.currentFrame = (float)channel.totalFrames - 1.0f;
                    return true;
                }
                return false;
            }
            return true;
        }
        animInfo.prevTime = currentTime;
        return true;
    }

    public static boolean isGamePaused() {
        Minecraft MC = Minecraft.func_71410_x();
        return MC.func_71356_B() && MC.field_71462_r != null && MC.field_71462_r.func_73868_f() && !MC.func_71401_C().func_71344_c();
    }

    public static void performAnimationInModel(List<CSModelRenderer> parts, IAnimated animated) {
        for (CSModelRenderer entry : parts) {
            ClientAnimationHandler.performAnimationForBlock(entry, animated);
        }
    }

    public static void performAnimationForBlock(CSModelRenderer block, IAnimated animated) {
        String boxName = block.field_78802_n;
        if (animated.getAnimationHandler() instanceof ClientAnimationHandler) {
            ClientAnimationHandler animHandler = (ClientAnimationHandler)animated.getAnimationHandler();
            if (block.field_78805_m != null) {
                for (int i = 0; i < block.field_78805_m.size(); ++i) {
                    ModelRenderer child = (ModelRenderer)block.field_78805_m.get(i);
                    if (!(child instanceof CSModelRenderer)) continue;
                    CSModelRenderer childModel = (CSModelRenderer)child;
                    ClientAnimationHandler.performAnimationForBlock(childModel, animated);
                }
            }
            block.resetRotationPoint();
            block.resetRotationMatrix();
            block.resetOffset();
            block.resetStretch();
            Map<InfoChannel, AnimationHandler.AnimInfo> animInfoMap = animHandler.currentAnimInfo.get(animated);
            if (animInfoMap == null) {
                return;
            }
            for (Map.Entry<InfoChannel, AnimationHandler.AnimInfo> animInfo : animInfoMap.entrySet()) {
                if (animInfo.getKey() instanceof ClientChannel) {
                    Vector3f currentPosition;
                    Vector3f endPosition;
                    Vector3f startPosition;
                    Vector3f currentPosition2;
                    Vector3f startPosition2;
                    Vector3f currentPosition3;
                    Vector3f startPosition3;
                    Quat4f currentQuat;
                    KeyFrame nextRotationKeyFrame;
                    int nextRotationKeyFramePosition;
                    float currentFrame;
                    ClientChannel clientChannel = (ClientChannel)animInfo.getKey();
                    KeyFrame prevRotationKeyFrame = clientChannel.getPreviousRotationKeyFrameForBox(boxName, currentFrame = animInfo.getValue().currentFrame);
                    int prevRotationKeyFramePosition = prevRotationKeyFrame != null ? clientChannel.getKeyFramePosition(prevRotationKeyFrame) : 0;
                    float SLERPProgress = (currentFrame - (float)prevRotationKeyFramePosition) / (float)((nextRotationKeyFramePosition = (nextRotationKeyFrame = clientChannel.getNextRotationKeyFrameForBox(boxName, currentFrame)) != null ? clientChannel.getKeyFramePosition(nextRotationKeyFrame) : 0) - prevRotationKeyFramePosition);
                    if (SLERPProgress > 1.0f || SLERPProgress < 0.0f) {
                        SLERPProgress = 1.0f;
                    }
                    if (prevRotationKeyFramePosition == 0 && prevRotationKeyFrame == null && nextRotationKeyFramePosition != 0) {
                        currentQuat = new Quat4f();
                        currentQuat.interpolate(block.getDefaultRotationAsQuaternion(), nextRotationKeyFrame.modelRenderersRotations.get(boxName), SLERPProgress);
                        Matrix4f mat = block.getRotationMatrix();
                        mat.set(currentQuat);
                        mat.transpose();
                    } else if (nextRotationKeyFramePosition != 0) {
                        currentQuat = new Quat4f();
                        currentQuat.interpolate(prevRotationKeyFrame.modelRenderersRotations.get(boxName), nextRotationKeyFrame.modelRenderersRotations.get(boxName), SLERPProgress);
                        Matrix4f mat = block.getRotationMatrix();
                        mat.set(currentQuat);
                        mat.transpose();
                    }
                    KeyFrame prevTranslationKeyFrame = clientChannel.getPreviousTranslationKeyFrameForBox(boxName, currentFrame);
                    int prevTranslationsKeyFramePosition = prevTranslationKeyFrame != null ? clientChannel.getKeyFramePosition(prevTranslationKeyFrame) : 0;
                    KeyFrame nextTranslationKeyFrame = clientChannel.getNextTranslationKeyFrameForBox(boxName, currentFrame);
                    int nextTranslationsKeyFramePosition = nextTranslationKeyFrame != null ? clientChannel.getKeyFramePosition(nextTranslationKeyFrame) : 0;
                    float LERPProgress = (currentFrame - (float)prevTranslationsKeyFramePosition) / (float)(nextTranslationsKeyFramePosition - prevTranslationsKeyFramePosition);
                    if (LERPProgress > 1.0f || LERPProgress < 0.0f) {
                        LERPProgress = 1.0f;
                    }
                    if (prevTranslationsKeyFramePosition == 0 && prevTranslationKeyFrame == null && nextTranslationsKeyFramePosition != 0) {
                        startPosition3 = block.getPositionAsVector();
                        Vector3f endPosition2 = nextTranslationKeyFrame.modelRenderersTranslations.get(boxName);
                        currentPosition3 = new Vector3f(startPosition3);
                        currentPosition3.interpolate((Tuple3f)endPosition2, LERPProgress);
                        block.func_78793_a(currentPosition3.x, currentPosition3.y, currentPosition3.z);
                    } else if (nextTranslationsKeyFramePosition != 0) {
                        startPosition3 = prevTranslationKeyFrame.modelRenderersTranslations.get(boxName);
                        Vector3f endPosition3 = nextTranslationKeyFrame.modelRenderersTranslations.get(boxName);
                        currentPosition3 = new Vector3f(startPosition3);
                        currentPosition3.interpolate((Tuple3f)endPosition3, LERPProgress);
                        block.func_78793_a(currentPosition3.x, currentPosition3.y, currentPosition3.z);
                    }
                    KeyFrame prevOffsetKeyFrame = clientChannel.getPreviousOffsetKeyFrameForBox(boxName, currentFrame);
                    int prevOffsetKeyFramePosition = prevOffsetKeyFrame != null ? clientChannel.getKeyFramePosition(prevOffsetKeyFrame) : 0;
                    KeyFrame nextOffsetKeyFrame = clientChannel.getNextOffsetKeyFrameForBox(boxName, currentFrame);
                    int nextOffsetKeyFramePosition = nextOffsetKeyFrame != null ? clientChannel.getKeyFramePosition(nextOffsetKeyFrame) : 0;
                    float OffProgress = (currentFrame - (float)prevOffsetKeyFramePosition) / (float)(nextOffsetKeyFramePosition - prevOffsetKeyFramePosition);
                    if (OffProgress > 1.0f || OffProgress < 0.0f) {
                        OffProgress = 1.0f;
                    }
                    if (prevOffsetKeyFramePosition == 0 && prevOffsetKeyFrame == null && nextOffsetKeyFramePosition != 0) {
                        startPosition2 = block.getOffsetAsVector();
                        Vector3f endPosition4 = nextOffsetKeyFrame.modelRenderersOffsets.get(boxName);
                        currentPosition2 = new Vector3f(startPosition2);
                        currentPosition2.interpolate((Tuple3f)endPosition4, OffProgress);
                        block.setOffset(currentPosition2.x, currentPosition2.y, currentPosition2.z);
                    } else if (nextOffsetKeyFramePosition != 0) {
                        startPosition2 = prevOffsetKeyFrame.modelRenderersOffsets.get(boxName);
                        Vector3f endPosition5 = nextOffsetKeyFrame.modelRenderersOffsets.get(boxName);
                        currentPosition2 = new Vector3f(startPosition2);
                        currentPosition2.interpolate((Tuple3f)endPosition5, OffProgress);
                        block.setOffset(currentPosition2.x, currentPosition2.y, currentPosition2.z);
                    }
                    KeyFrame prevStretchKeyFrame = clientChannel.getPreviousStretchKeyFrameForBox(boxName, currentFrame);
                    int prevStretchKeyFramePosition = prevStretchKeyFrame != null ? clientChannel.getKeyFramePosition(prevStretchKeyFrame) : 0;
                    KeyFrame nextStretchKeyFrame = clientChannel.getNextStretchKeyFrameForBox(boxName, currentFrame);
                    int nextStretchKeyFramePosition = nextStretchKeyFrame != null ? clientChannel.getKeyFramePosition(nextStretchKeyFrame) : 0;
                    float strProgress = (currentFrame - (float)prevStretchKeyFramePosition) / (float)(nextStretchKeyFramePosition - prevStretchKeyFramePosition);
                    if (strProgress > 1.0f || strProgress < 0.0f) {
                        strProgress = 1.0f;
                    }
                    if (prevStretchKeyFramePosition == 0 && prevStretchKeyFrame == null && nextStretchKeyFramePosition != 0) {
                        startPosition = block.getStretchAsVector();
                        endPosition = nextStretchKeyFrame.modelRenderersStretchs.get(boxName);
                        currentPosition = new Vector3f(startPosition);
                        currentPosition.interpolate((Tuple3f)endPosition, strProgress);
                        block.setStretch(currentPosition.x, currentPosition.y, currentPosition.z);
                        continue;
                    }
                    if (nextStretchKeyFramePosition == 0) continue;
                    startPosition = prevStretchKeyFrame.modelRenderersStretchs.get(boxName);
                    endPosition = nextStretchKeyFrame.modelRenderersStretchs.get(boxName);
                    currentPosition = new Vector3f(startPosition);
                    currentPosition.interpolate((Tuple3f)endPosition, strProgress);
                    block.setStretch(currentPosition.x, currentPosition.y, currentPosition.z);
                    continue;
                }
                if (!(animInfo.getKey() instanceof CustomChannel)) continue;
                ((CustomChannel)animInfo.getKey()).update(block, animated);
            }
        }
    }

    public Map<T, Map<InfoChannel, AnimationHandler.AnimInfo>> getCurrentAnimInfo() {
        return this.currentAnimInfo;
    }

    public void setCurrentAnimInfo(Map<T, Map<InfoChannel, AnimationHandler.AnimInfo>> currentAnimInfo) {
        this.currentAnimInfo = currentAnimInfo;
    }

    public Map<String, InfoChannel> getAnimChannels() {
        return this.animChannels;
    }

    public void setAnimChannels(Map<String, InfoChannel> animChannels) {
        this.animChannels = animChannels;
    }
}

