/*
 * Decompiled with CFR 0.152.
 */
package c4.comforts.common.blocks;

import c4.comforts.common.blocks.BlockHammock;
import c4.comforts.common.blocks.ComfortsBlocks;
import c4.comforts.common.items.ComfortsItems;
import c4.comforts.common.util.ComfortsUtil;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRope
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", apply -> apply != EnumFacing.DOWN && apply != EnumFacing.UP);
    public static final PropertyBool SUPPORTING = PropertyBool.func_177716_a((String)"supporting");
    protected static final AxisAlignedBB ROPE_NORTH_AABB = new AxisAlignedBB(0.375, 0.0, 0.75, 0.625, 0.5, 1.0);
    protected static final AxisAlignedBB ROPE_SOUTH_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 0.5, 0.25);
    protected static final AxisAlignedBB ROPE_WEST_AABB = new AxisAlignedBB(0.75, 0.0, 0.375, 1.0, 0.5, 0.625);
    protected static final AxisAlignedBB ROPE_EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 0.25, 0.5, 0.625);
    protected static final AxisAlignedBB ROPE_NORTH_S_AABB = new AxisAlignedBB(0.375, 0.1875, 0.5625, 0.625, 0.5, 1.0);
    protected static final AxisAlignedBB ROPE_SOUTH_S_AABB = new AxisAlignedBB(0.375, 0.1875, 0.0, 0.625, 0.5, 0.4375);
    protected static final AxisAlignedBB ROPE_WEST_S_AABB = new AxisAlignedBB(0.5625, 0.1875, 0.375, 1.0, 0.5, 0.625);
    protected static final AxisAlignedBB ROPE_EAST_S_AABB = new AxisAlignedBB(0.0, 0.1875, 0.375, 0.4375, 0.5, 0.625);

    public BlockRope() {
        super(Material.field_151580_n);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SUPPORTING, (Comparable)Boolean.valueOf(false)));
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.2f);
        this.setRegistryName("rope");
        this.func_149663_c("comforts.rope");
        this.func_149647_a(ComfortsUtil.comfortsTab);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        boolean supporting = (Boolean)state.func_177229_b((IProperty)SUPPORTING);
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                return supporting ? ROPE_EAST_S_AABB : ROPE_EAST_AABB;
            }
            case WEST: {
                return supporting ? ROPE_WEST_S_AABB : ROPE_WEST_AABB;
            }
            case SOUTH: {
                return supporting ? ROPE_SOUTH_S_AABB : ROPE_SOUTH_AABB;
            }
        }
        return supporting ? ROPE_NORTH_S_AABB : ROPE_NORTH_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, @Nonnull BlockPos pos) {
        for (EnumFacing enumfacing : FACING.func_177700_c()) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(World worldIn, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        return facing != EnumFacing.UP && facing != EnumFacing.DOWN && !BlockRope.func_193382_c((Block)iblockstate.func_177230_c()) && iblockstate.func_193401_d((IBlockAccess)worldIn, pos, facing) == BlockFaceShape.SOLID && iblockstate.func_185904_a().func_76218_k();
    }

    @Nonnull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.canPlaceAt(worldIn, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canPlaceAt(worldIn, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState blockstate = worldIn.func_180495_p(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
        if (!(blockstate.func_177230_c() instanceof BlockHammock)) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)SUPPORTING, (Comparable)Boolean.valueOf(false)));
        }
        this.onNeighborChangeInternal(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (playerIn.func_184586_b(hand).func_77973_b() != ComfortsItems.HAMMOCK || ((Boolean)state.func_177229_b((IProperty)SUPPORTING)).booleanValue() || !this.checkForPartnerRope(worldIn, pos, state)) {
            return true;
        }
        this.hangHammock(worldIn, pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)), playerIn, hand, (EnumFacing)state.func_177229_b((IProperty)FACING));
        return true;
    }

    private void hangHammock(World worldIn, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing facing) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        boolean flag = block.func_176200_f((IBlockAccess)worldIn, pos);
        BlockPos blockpos = pos.func_177972_a(facing);
        ItemStack itemstack = player.func_184586_b(hand);
        if (player.func_175151_a(pos, facing, itemstack) && player.func_175151_a(blockpos, facing, itemstack)) {
            boolean flag3;
            IBlockState iblockstate1 = worldIn.func_180495_p(blockpos);
            boolean flag1 = iblockstate1.func_177230_c().func_176200_f((IBlockAccess)worldIn, blockpos);
            boolean flag2 = flag || worldIn.func_175623_d(pos);
            boolean bl = flag3 = flag1 || worldIn.func_175623_d(blockpos);
            if (flag2 && flag3) {
                IBlockState iblockstate2 = ComfortsBlocks.HAMMOCKS[itemstack.func_77960_j()].func_176223_P().func_177226_a((IProperty)BlockHammock.OCCUPIED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockHammock.field_185512_D, (Comparable)facing).func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT);
                worldIn.func_175656_a(pos.func_177972_a(facing.func_176734_d()), worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_177226_a((IProperty)SUPPORTING, (Comparable)Boolean.valueOf(true)));
                worldIn.func_175656_a(blockpos.func_177972_a(facing), worldIn.func_180495_p(blockpos.func_177972_a(facing)).func_177226_a((IProperty)SUPPORTING, (Comparable)Boolean.valueOf(true)));
                worldIn.func_180501_a(pos, iblockstate2, 10);
                worldIn.func_180501_a(blockpos, iblockstate2.func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD), 10);
                SoundType soundtype = iblockstate2.func_177230_c().getSoundType(iblockstate2, worldIn, pos, (Entity)player);
                worldIn.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                worldIn.func_175722_b(pos, block, false);
                worldIn.func_175722_b(blockpos, iblockstate1.func_177230_c(), false);
                if (player instanceof EntityPlayerMP) {
                    CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, itemstack);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
            }
        }
    }

    private boolean checkForPartnerRope(World worldIn, BlockPos pos, IBlockState state) {
        BlockPos blockpos = pos.func_177967_a((EnumFacing)state.func_177229_b((IProperty)FACING), 3);
        IBlockState blockstate = worldIn.func_180495_p(blockpos);
        return blockstate.func_177230_c() instanceof BlockRope && blockstate.func_177229_b((IProperty)FACING) == ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d() && (Boolean)blockstate.func_177229_b((IProperty)SUPPORTING) == false;
    }

    protected boolean onNeighborChangeInternal(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.checkForDrop(worldIn, pos, state)) {
            return true;
        }
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumFacing enumfacing1 = enumfacing.func_176734_d();
        BlockPos blockpos = pos.func_177972_a(enumfacing1);
        boolean flag = false;
        if (worldIn.func_180495_p(blockpos).func_193401_d((IBlockAccess)worldIn, blockpos, enumfacing) != BlockFaceShape.SOLID) {
            flag = true;
        }
        if (flag) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return true;
        }
        return false;
    }

    protected boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this && this.canPlaceAt(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            return true;
        }
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        return false;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        iblockstate = meta < 4 ? iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)) : iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta - 4))).func_177226_a((IProperty)SUPPORTING, (Comparable)Boolean.valueOf(true));
        return iblockstate;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i += ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)SUPPORTING)).booleanValue()) {
            i += 4;
        }
        return i;
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, SUPPORTING});
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess access, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

