/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.startuptimer.mixin;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.fml.client.SplashProgress;
import org.embeddedt.startuptimer.StartupTimer;
import org.embeddedt.startuptimer.core.LoadingPlugin;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"net/minecraftforge/fml/client/SplashProgress$2"})
public abstract class SplashProgressMixin {
    @Shadow
    @Final
    private int textHeight2;
    private static FontRenderer fontRenderer = null;
    private static int fontColor = 0;

    @Shadow
    protected abstract void setColor(int var1);

    @Inject(method={"run"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glDisable(I)V", ordinal=1, remap=false, shift=At.Shift.AFTER)}, remap=false)
    private void injectStartupTime(CallbackInfo ci) {
        if (fontRenderer == null) {
            try {
                Field f = SplashProgress.class.getDeclaredField("fontRenderer");
                f.setAccessible(true);
                fontRenderer = (FontRenderer)f.get(null);
                f = SplashProgress.class.getDeclaredField("fontColor");
                f.setAccessible(true);
                fontColor = f.getInt(null);
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
                return;
            }
        }
        GL11.glPushMatrix();
        this.setColor(fontColor);
        GL11.glTranslatef((float)(320 - Display.getWidth() / 2 + 4), (float)(240 + Display.getHeight() / 2 - this.textHeight2), (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        String renderString = this.getString();
        fontRenderer.func_78276_b(renderString, 0, 0, 0);
        GL11.glDisable((int)3553);
        GL11.glPopMatrix();
    }

    private String getString() {
        long startupTime = ManagementFactory.getRuntimeMXBean().getUptime();
        if (StartupTimer.doneTime > 0L) {
            startupTime = StartupTimer.doneTime;
        }
        long minutes = startupTime / 1000L / 60L;
        long seconds = startupTime / 1000L % 60L;
        String str = "Startup: " + minutes + "m " + seconds + "s";
        if (LoadingPlugin.expectedTime > 0L) {
            long ex_minutes = LoadingPlugin.expectedTime / 1000L / 60L;
            long ex_seconds = LoadingPlugin.expectedTime / 1000L % 60L;
            str = str + " / ~" + ex_minutes + "m " + ex_seconds + "s";
        }
        return str;
    }
}

