/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.startuptimer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import net.minecraft.launchwrapper.Launch;

public class StartupTimerConfig {
    public static boolean displayStartupTimeOnMainMenu = true;
    public static final File TIMES_FILE = new File(Launch.minecraftHome, "config/startuptimer/startup_times.json");
    public static final File CONFIG_FILE = new File(Launch.minecraftHome, "config/startuptimer/config.json");
    public static final String KEY_TIMER_ON_TOP = "timerOnTop";
    public static final String KEY_DISPLAY_ON_MAIN_MENU = "displayStartupTimeOnMainMenu";

    public static void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try {
                JsonObject obj;
                JsonReader jr = new JsonReader((Reader)new FileReader(CONFIG_FILE));
                JsonElement jp = new JsonParser().parse(jr);
                if (jp.isJsonObject() && (obj = jp.getAsJsonObject()).has(KEY_DISPLAY_ON_MAIN_MENU)) {
                    displayStartupTimeOnMainMenu = obj.get(KEY_DISPLAY_ON_MAIN_MENU).getAsBoolean();
                }
                jr.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        StartupTimerConfig.saveConfig();
    }

    public static void saveConfig() {
        try {
            CONFIG_FILE.getParentFile().mkdirs();
            if (!CONFIG_FILE.exists()) {
                CONFIG_FILE.createNewFile();
            }
            JsonWriter jw = new JsonWriter((Writer)new FileWriter(CONFIG_FILE));
            jw.setIndent("  ");
            jw.beginObject();
            jw.name(KEY_DISPLAY_ON_MAIN_MENU).value(displayStartupTimeOnMainMenu);
            jw.endObject();
            jw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static long getTimeEstimate() {
        try {
            JsonArray arr;
            JsonObject obj;
            JsonReader jr;
            JsonElement jp;
            TIMES_FILE.getParentFile().mkdirs();
            if (!TIMES_FILE.exists()) {
                TIMES_FILE.createNewFile();
            }
            if ((jp = new JsonParser().parse(jr = new JsonReader((Reader)new FileReader(TIMES_FILE)))).isJsonObject() && (obj = jp.getAsJsonObject()).has("times") && obj.get("times").isJsonArray() && (arr = obj.get("times").getAsJsonArray()).size() > 0) {
                long sum = 0L;
                for (int i = 0; i < arr.size(); ++i) {
                    sum += arr.get(i).getAsLong();
                }
                return sum /= (long)arr.size();
            }
            jr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public static void addStartupTime(long startupTime) {
        try {
            JsonArray arr;
            JsonObject obj;
            TIMES_FILE.getParentFile().mkdirs();
            if (!TIMES_FILE.exists()) {
                TIMES_FILE.createNewFile();
            }
            long[] times = new long[]{};
            JsonReader jr = new JsonReader((Reader)new FileReader(TIMES_FILE));
            JsonElement jp = new JsonParser().parse(jr);
            if (jp.isJsonObject() && (obj = jp.getAsJsonObject()).has("times") && obj.get("times").isJsonArray() && (arr = obj.get("times").getAsJsonArray()).size() > 0) {
                times = new long[arr.size()];
                for (int i = 0; i < arr.size(); ++i) {
                    times[i] = arr.get(i).getAsLong();
                }
            }
            jr.close();
            JsonWriter jw = new JsonWriter((Writer)new FileWriter(TIMES_FILE));
            jw.setIndent("  ");
            jw.beginObject();
            jw.name("times");
            jw.beginArray();
            if (times.length > 2) {
                for (int i = times.length - 2; i < times.length; ++i) {
                    jw.value(times[i]);
                }
            } else {
                for (int i = 0; i < times.length; ++i) {
                    jw.value(times[i]);
                }
            }
            jw.value(startupTime);
            jw.endArray();
            jw.endObject();
            jw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

