/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.backtools.common;

import java.util.HashMap;
import java.util.HashSet;
import me.ichun.mods.backtools.client.core.EventHandlerClient;
import me.ichun.mods.backtools.client.thread.ThreadCheckModSupport;
import me.ichun.mods.backtools.common.config.Config;
import me.ichun.mods.ichunutil.common.core.Logger;
import me.ichun.mods.ichunutil.common.core.config.ConfigBase;
import me.ichun.mods.ichunutil.common.core.config.ConfigHandler;
import me.ichun.mods.ichunutil.common.module.update.UpdateChecker;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemSword;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="backtools", name="BackTools", version="7.0.1", certificateFingerprint="4db5c2bd1b556f252a5b8b54b256d381b2a0a6b8", guiFactory="me.ichun.mods.ichunutil.common.core.config.GenericModGuiFactory", dependencies="required-after:ichunutil@[7.2.0,8.0.0)", acceptedMinecraftVersions="[1.12,1.13)", clientSideOnly=true)
public class BackTools {
    public static final String MOD_NAME = "BackTools";
    public static final String MOD_ID = "backtools";
    public static final String VERSION = "7.0.1";
    public static final Logger LOGGER = Logger.createLogger((String)"BackTools");
    @Mod.Instance(value="backtools")
    public static BackTools instance;
    public static Config config;
    public static EventHandlerClient eventHandlerClient;
    public static HashMap<Class, Integer> orientationMap;
    public static HashSet<Item> blacklist;
    public static HashSet<Class<? extends Item>> blacklistItemConfig;

    public static boolean isBlacklistedInConfig(Item item) {
        for (Class<? extends Item> clz : blacklistItemConfig) {
            if (!clz.isInstance(item)) continue;
            return true;
        }
        return false;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = (Config)ConfigHandler.registerConfig((ConfigBase)new Config(event.getSuggestedConfigurationFile()));
        eventHandlerClient = new EventHandlerClient();
        MinecraftForge.EVENT_BUS.register((Object)eventHandlerClient);
        orientationMap.put(ItemSword.class, 2);
        orientationMap.put(ItemBow.class, 1);
        new ThreadCheckModSupport().start();
        UpdateChecker.registerMod((UpdateChecker.ModVersionInfo)new UpdateChecker.ModVersionInfo(MOD_NAME, "1.12.2", VERSION, true));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (String s : BackTools.config.blacklistedItemClasses) {
            try {
                Class<?> clz = Class.forName(s);
                if (Item.class.isAssignableFrom(clz)) {
                    blacklistItemConfig.add(clz);
                    continue;
                }
                LOGGER.warn((Object)("Class does not extend Item class: " + s));
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn((Object)("Cannot find class for blacklist: " + s));
                e.printStackTrace();
            }
        }
    }

    @Mod.EventHandler
    public void onIMCMessage(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (message.key.equalsIgnoreCase("blacklist") && message.isItemStackMessage()) {
                if (blacklist.contains(message.getItemStackValue().func_77973_b())) continue;
                blacklist.add(message.getItemStackValue().func_77973_b());
                LOGGER.info((Object)("Registered " + message.getItemStackValue().func_77973_b().toString() + " to Item blacklist"));
                continue;
            }
            if (!message.key.equalsIgnoreCase("backtool") || !message.isItemStackMessage() || orientationMap.containsKey(message.getItemStackValue().func_77973_b().getClass())) continue;
            orientationMap.put(message.getItemStackValue().func_77973_b().getClass(), message.getItemStackValue().func_190916_E());
            LOGGER.warn((Object)("Registered " + message.getItemStackValue().func_77973_b().getClass().getName() + " to backtools"));
        }
    }

    public static int getOrientation(Class clz) {
        try {
            Integer i = orientationMap.get(clz);
            if (i == null && clz != Item.class) {
                return BackTools.getOrientation(clz.getSuperclass());
            }
            return i;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    static {
        orientationMap = new HashMap();
        blacklist = new HashSet();
        blacklistItemConfig = new HashSet();
    }
}

