/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.particle;

import epicsquid.mysticallib.struct.Vec4f;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="mysticallib", value={Side.CLIENT})
@SideOnly(value=Side.CLIENT)
public class RenderUtil {
    private static TextureAtlasSprite whiteTexture;

    public static void renderBoundingBox(@Nonnull AxisAlignedBB bb, @Nonnull Vec4f color) {
        float minU = whiteTexture.func_94209_e();
        float maxU = whiteTexture.func_94212_f();
        float minV = whiteTexture.func_94206_g();
        float maxV = whiteTexture.func_94210_h();
        BufferBuilder tes = Tessellator.func_178181_a().func_178180_c();
        tes.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (EnumFacing e : EnumFacing.values()) {
            for (Vertex v : RenderUtil.getCornersWithUvForFace(bb, e, minU, maxU, minV, maxV)) {
                tes.func_181662_b(v.x(), v.y(), v.z()).func_187315_a((double)v.u(), (double)v.v()).func_181666_a(color.x, color.y, color.z, color.w).func_181675_d();
            }
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    private static List<Vertex> getCornersWithUvForFace(@Nonnull AxisAlignedBB bb, @Nonnull EnumFacing face, float minU, float maxU, float minV, float maxV) {
        ArrayList<Vertex> result = new ArrayList<Vertex>();
        switch (face) {
            case NORTH: {
                result.add(new Vertex(new Vec3d(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c), new Vec2f(minU, minV)));
                result.add(new Vertex(new Vec3d(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c), new Vec2f(maxU, minV)));
                result.add(new Vertex(new Vec3d(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c), new Vec2f(maxU, maxV)));
                result.add(new Vertex(new Vec3d(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c), new Vec2f(minU, maxV)));
                break;
            }
            case SOUTH: {
                result.add(new Vertex(new Vec3d(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f), new Vec2f(maxU, minV)));
                result.add(new Vertex(new Vec3d(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f), new Vec2f(minU, minV)));
                result.add(new Vertex(new Vec3d(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f), new Vec2f(minU, maxV)));
                result.add(new Vertex(new Vec3d(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f), new Vec2f(maxU, maxV)));
                break;
            }
            case EAST: {
                result.add(new Vertex(new Vec3d(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c), new Vec2f(maxU, maxV)));
                result.add(new Vertex(new Vec3d(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f), new Vec2f(minU, maxV)));
                result.add(new Vertex(new Vec3d(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f), new Vec2f(minU, minV)));
                result.add(new Vertex(new Vec3d(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c), new Vec2f(maxU, minV)));
                break;
            }
            case WEST: {
                result.add(new Vertex(new Vec3d(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c), new Vec2f(maxU, minV)));
                result.add(new Vertex(new Vec3d(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f), new Vec2f(minU, minV)));
                result.add(new Vertex(new Vec3d(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f), new Vec2f(minU, maxV)));
                result.add(new Vertex(new Vec3d(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c), new Vec2f(maxU, maxV)));
                break;
            }
            case UP: {
                result.add(new Vertex(new Vec3d(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f), new Vec2f(minU, minV)));
                result.add(new Vertex(new Vec3d(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c), new Vec2f(minU, maxV)));
                result.add(new Vertex(new Vec3d(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c), new Vec2f(maxU, maxV)));
                result.add(new Vertex(new Vec3d(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f), new Vec2f(maxU, minV)));
                break;
            }
            default: {
                result.add(new Vertex(new Vec3d(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c), new Vec2f(maxU, maxV)));
                result.add(new Vertex(new Vec3d(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c), new Vec2f(minU, maxV)));
                result.add(new Vertex(new Vec3d(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f), new Vec2f(minU, minV)));
                result.add(new Vertex(new Vec3d(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f), new Vec2f(maxU, minV)));
            }
        }
        return result;
    }

    @SubscribeEvent
    public static void onIconLoad(TextureStitchEvent.Pre event) {
        TextureMap map = event.getMap();
        if (map != null) {
            whiteTexture = map.func_174942_a(new ResourceLocation("mysticallib", "white"));
        }
    }

    public static interface IRanged {
        @SideOnly(value=Side.CLIENT)
        public boolean isShowingRange();

        @SideOnly(value=Side.CLIENT)
        public void toggleShowRange();

        @SideOnly(value=Side.CLIENT)
        public void setShowingRange(boolean var1);

        @Nonnull
        public AxisAlignedBB getBounds();
    }

    public static class Vertex {
        private Vec3d xyz;
        private Vec2f uv;

        public Vertex(Vec3d xyz, Vec2f uv) {
            this.xyz = xyz;
            this.uv = uv;
        }

        public double x() {
            return this.xyz.field_72450_a;
        }

        public double y() {
            return this.xyz.field_72448_b;
        }

        public double z() {
            return this.xyz.field_72449_c;
        }

        public float u() {
            return this.uv.field_189982_i;
        }

        public float v() {
            return this.uv.field_189983_j;
        }
    }
}

