/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.eyes.client;

import gigaherz.eyes.EyesInTheDarkness;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.util.Rectangle;

public class JumpscareOverlay
extends Gui {
    private static final ResourceLocation TEXTURE_EYES = EyesInTheDarkness.location("textures/entity/eyes2.png");
    private static final ResourceLocation TEXTURE_FLASH = EyesInTheDarkness.location("textures/creepy.png");
    public static JumpscareOverlay INSTANCE = new JumpscareOverlay();
    private boolean visible = false;
    private float progress = 0.0f;
    private Minecraft mc = Minecraft.func_71410_x();
    private static final Rectangle[] FRAMES = new Rectangle[]{new Rectangle(0, 0, 13, 6), new Rectangle(0, 7, 13, 6), new Rectangle(0, 14, 13, 6), new Rectangle(0, 21, 13, 6), new Rectangle(15, 1, 15, 8), new Rectangle(15, 16, 15, 12)};
    private static final int ANIMATION_APPEAR = 10;
    private static final int ANIMATION_LINGER = 90;
    private static final int ANIMATION_BLINK = 60;
    private static final int ANIMATION_SCARE1 = 20;
    private static final int ANIMATION_FADE = 20;
    private static final int ANIMATION_BLINK_START = 100;
    private static final int ANIMATION_SCARE_START = 160;
    private static final int ANIMATION_FADE_START = 180;
    private static final int ANIMATION_TOTAL = 200;

    private JumpscareOverlay() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void show(double ex, double ey, double ez) {
        this.visible = true;
        this.mc.field_71441_e.func_184134_a(ex, ey, ez, EyesInTheDarkness.eyes_jumpscare, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (this.visible) {
            this.progress += 1.0f;
            if (this.progress >= 200.0f) {
                this.visible = false;
                this.progress = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public void overlayEvent(RenderGameOverlayEvent.Pre event) {
        if (!this.visible || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        int screenWidth = this.mc.field_71443_c;
        int screenHeight = this.mc.field_71440_d;
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)screenWidth, (double)screenHeight, (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        float time = this.progress + event.getPartialTicks();
        if (time >= 200.0f) {
            this.visible = false;
            this.progress = 0.0f;
            return;
        }
        float darkening = MathHelper.func_76131_a((float)Math.min(time / 10.0f, (200.0f - time) / 20.0f), (float)0.0f, (float)1.0f);
        boolean showCreep = false;
        int blinkstate = 0;
        if (time >= 100.0f) {
            if (time >= 160.0f) {
                blinkstate = 1;
                showCreep = time - 160.0f > 20.0f;
            } else {
                float fade = Math.max(0.0f, (time - 100.0f) / 60.0f);
                float blinkspeed = (float)(1.0 + Math.pow(fade, 3.0));
                blinkstate = MathHelper.func_76141_d((float)(20.0f * blinkspeed)) & 1;
                showCreep = blinkstate == 1;
            }
        }
        int alpha = MathHelper.func_76141_d((float)(darkening * 255.0f));
        if (showCreep) {
            int texW = 2048;
            int texH = 1024;
            float scale1 = (float)screenHeight / (float)texH;
            int drawY = 0;
            int drawH = screenHeight;
            int drawW = MathHelper.func_76141_d((float)((float)texW * scale1));
            int drawX = (screenWidth - drawW) / 2;
            GlStateManager.func_179147_l();
            this.drawScaledCustomTexture(TEXTURE_FLASH, texW, texH, 0, 0, texW, texH, drawX, drawY, drawW, drawH, alpha << 24 | 0xFFFFFF);
        } else {
            JumpscareOverlay.func_73734_a((int)0, (int)0, (int)screenWidth, (int)screenHeight, (int)(alpha << 24));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
        }
        if (blinkstate == 1) {
            return;
        }
        float scale = Float.MAX_VALUE;
        for (Rectangle r : FRAMES) {
            float s = Math.min(MathHelper.func_76128_c((double)((double)screenWidth * 0.8 / (double)r.getWidth())), MathHelper.func_76128_c((double)((double)screenHeight * 0.8 / (double)r.getHeight())));
            scale = Math.min(scale, s);
        }
        scale = Math.min(1.0f, (1.0f + time) / 11.0f) * scale;
        int currentFrame = Math.min(FRAMES.length - 1, MathHelper.func_76141_d((float)((float)FRAMES.length * time / 10.0f)));
        Rectangle rect = FRAMES[currentFrame];
        int tx = rect.getX();
        int ty = rect.getY();
        int tw = rect.getWidth();
        int th = rect.getHeight();
        float drawW = (float)tw * scale;
        float drawH = (float)th * scale;
        float drawX = ((float)screenWidth - drawW) / 2.0f;
        float drawY = ((float)screenHeight - drawH) / 2.0f;
        float texW = 32.0f;
        float texH = 32.0f;
        this.drawScaledCustomTexture(TEXTURE_EYES, texW, texH, tx, ty, tw, th, drawX, drawY, drawW, drawH);
    }

    private void drawScaledCustomTexture(ResourceLocation tex, float texW, float texH, int tx, int ty, int tw, int th, float targetX, float targetY, float targetW, float targetH) {
        this.mc.field_71446_o.func_110577_a(tex);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)targetX, (double)targetY, 0.0).func_187315_a((double)((float)tx / texW), (double)((float)ty / texH)).func_181675_d();
        buffer.func_181662_b((double)targetX, (double)(targetY + targetH), 0.0).func_187315_a((double)((float)tx / texW), (double)((float)(ty + th) / texH)).func_181675_d();
        buffer.func_181662_b((double)(targetX + targetW), (double)(targetY + targetH), 0.0).func_187315_a((double)((float)(tx + tw) / texW), (double)((float)(ty + th) / texH)).func_181675_d();
        buffer.func_181662_b((double)(targetX + targetW), (double)targetY, 0.0).func_187315_a((double)((float)(tx + tw) / texW), (double)((float)ty / texH)).func_181675_d();
        tessellator.func_78381_a();
    }

    private void drawScaledCustomTexture(ResourceLocation tex, float texW, float texH, int tx, int ty, int tw, int th, float targetX, float targetY, float targetW, float targetH, int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        this.mc.field_71446_o.func_110577_a(tex);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b((double)targetX, (double)targetY, 0.0).func_187315_a((double)((float)tx / texW), (double)((float)ty / texH)).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)targetX, (double)(targetY + targetH), 0.0).func_187315_a((double)((float)tx / texW), (double)((float)(ty + th) / texH)).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(targetX + targetW), (double)(targetY + targetH), 0.0).func_187315_a((double)((float)(tx + tw) / texW), (double)((float)(ty + th) / texH)).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(targetX + targetW), (double)targetY, 0.0).func_187315_a((double)((float)(tx + tw) / texW), (double)((float)ty / texH)).func_181669_b(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
    }
}

