/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ChocoFunctions {
    public static int weightedRandom(int[] weightArray, Random random) {
        int totalW = 0;
        for (int w : weightArray) {
            totalW += w;
        }
        int index = 0;
        int r = random.nextInt(totalW) + 1;
        for (int i = 0; i < weightArray.length; ++i) {
            if ((r -= weightArray[i]) > 0) continue;
            index = i;
            break;
        }
        return index;
    }

    public static Object weightedRandom(Object elementArray, double[] weightArray, Random random) {
        if (Array.getLength(elementArray) != weightArray.length) {
            return null;
        }
        double totalWeight = 0.0;
        for (int i = 0; i < weightArray.length; ++i) {
            totalWeight += weightArray[i];
        }
        int randomIndex = -1;
        double randomObject = random.nextDouble() * totalWeight;
        for (int i = 0; i < Array.getLength(elementArray); ++i) {
            if (!((randomObject -= weightArray[i]) <= 0.0)) continue;
            randomIndex = i;
            break;
        }
        return Array.get(elementArray, randomIndex);
    }

    public static int getCurrentPage(ItemStack book) {
        if (!book.func_77942_o()) {
            return 0;
        }
        return book.func_77978_p().func_74762_e("CCP|CP");
    }

    public static void setCurrentPage(ItemStack chocopedia, int currPage) {
        if (chocopedia.func_77978_p() == null) {
            chocopedia.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound chocopediaTagcompound = chocopedia.func_77978_p();
        if (currPage <= 0) {
            chocopediaTagcompound.func_82580_o("CCP|CP");
            chocopedia.func_77982_d(chocopediaTagcompound);
        } else {
            chocopediaTagcompound.func_74768_a("CCP|CP", currPage);
            chocopedia.func_77982_d(chocopediaTagcompound);
        }
    }

    public static long getUniqueLongForXYZ(int x, int y, int z) {
        boolean xIsNegative = x < 0;
        boolean zIsNegative = z < 0;
        x = Math.abs(x);
        y = Math.abs(y);
        z = Math.abs(z);
        return ((x + y + z) * (x + y + z + 1) * (x + y + z + 2) / 6 + (y + z) * (y + z + 1) / 2 + y + (zIsNegative ? 1 : 0)) * (xIsNegative ? -2 : 2);
    }

    public static int medianIntArray(ArrayList<Integer> array, boolean roundup) {
        if (array.size() <= 0) {
            return -1;
        }
        Collections.sort(array);
        if (array.size() % 2 == 0) {
            int totalElements = array.size();
            int sumOfMiddleTwo = array.get(totalElements / 2) + array.get(totalElements / 2 - 1);
            if (sumOfMiddleTwo % 2 == 0) {
                return sumOfMiddleTwo / 2;
            }
            double median = (double)sumOfMiddleTwo / 2.0;
            double average = 0.0;
            for (int i : array) {
                average += (double)i;
            }
            if ((average /= (double)array.size()) < median) {
                return MathHelper.func_76128_c((double)median);
            }
            if (average > median) {
                return MathHelper.func_76143_f((double)median);
            }
            return roundup ? MathHelper.func_76143_f((double)median) : MathHelper.func_76128_c((double)median);
        }
        return array.get(array.size() / 2);
    }

    public static String getBiomeName(Biome biome) {
        return (String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"});
    }

    public static boolean isChocoCraftAuthor(EntityPlayer player) {
        return player.func_110124_au().toString().equals("f08e25bc-411c-48f5-a623-634c2c213387") || player.func_110124_au().toString().equals("07aa849d-43e5-4da1-b2f9-5d8ac69f4d1a") || player.func_110124_au().toString().equals("89550ceb-1cf6-48a5-ab39-2a3e39a48f08");
    }

    public static enum MaterialType {
        OAK,
        SPRUCE,
        BIRCH,
        JUNGLE,
        ACACIA,
        DARK_OAK,
        SAND,
        MESA,
        SNOW,
        MUSHROOM;


        public static MaterialType getMaterialTemplateForBiome(World world, int posX, int posZ) {
            Biome biome = world.func_180494_b(new BlockPos(posX, 0, posZ));
            return MaterialType.getMaterialTemplateForBiome(biome);
        }

        public static MaterialType getMaterialTemplateForBiome(BiomeProvider biomeProvider, int posX, int posZ) {
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 0, posZ));
            return MaterialType.getMaterialTemplateForBiome(biome);
        }

        public static MaterialType getMaterialTemplateForBiome(Biome biome) {
            if (ChocoFunctions.getBiomeName(biome).toLowerCase().contains("birch")) {
                return BIRCH;
            }
            if (ChocoFunctions.getBiomeName(biome).toLowerCase().contains("roofed forest")) {
                return DARK_OAK;
            }
            Set typeTags = BiomeDictionary.getTypes((Biome)biome);
            if (ChocoFunctions.getBiomeName(biome).toLowerCase().contains("taiga")) {
                return SPRUCE;
            }
            for (BiomeDictionary.Type type : typeTags) {
                if (type != BiomeDictionary.Type.CONIFEROUS) continue;
                return SPRUCE;
            }
            for (BiomeDictionary.Type type : typeTags) {
                if (type != BiomeDictionary.Type.JUNGLE) continue;
                return JUNGLE;
            }
            if (ChocoFunctions.getBiomeName(biome).toLowerCase().contains("savanna")) {
                return ACACIA;
            }
            for (BiomeDictionary.Type type : typeTags) {
                if (type != BiomeDictionary.Type.SAVANNA) continue;
                return ACACIA;
            }
            for (BiomeDictionary.Type type : typeTags) {
                if (type != BiomeDictionary.Type.MESA) continue;
                return MESA;
            }
            for (BiomeDictionary.Type type : typeTags) {
                if (type != BiomeDictionary.Type.MUSHROOM) continue;
                return MUSHROOM;
            }
            boolean isSnowy = false;
            boolean isWasteland = false;
            for (BiomeDictionary.Type type : typeTags) {
                if (type == BiomeDictionary.Type.SNOWY) {
                    isSnowy = true;
                }
                if (type == BiomeDictionary.Type.WASTELAND) {
                    isWasteland = true;
                }
                if (type != BiomeDictionary.Type.DENSE && type != BiomeDictionary.Type.FOREST && type != BiomeDictionary.Type.LUSH && type != BiomeDictionary.Type.SPARSE) continue;
                isSnowy = false;
                isWasteland = false;
                break;
            }
            if (isSnowy && isWasteland) {
                return SNOW;
            }
            for (BiomeDictionary.Type type : typeTags) {
                if (type != BiomeDictionary.Type.SANDY) continue;
                return SAND;
            }
            return OAK;
        }

        public static MaterialType getMaterialTypeFromName(String name, MaterialType defaultType) {
            if (name.toUpperCase().equals("OAK")) {
                return OAK;
            }
            if (name.toUpperCase().equals("SPRUCE")) {
                return SPRUCE;
            }
            if (name.toUpperCase().equals("BIRCH")) {
                return BIRCH;
            }
            if (name.toUpperCase().equals("JUNGLE")) {
                return JUNGLE;
            }
            if (name.toUpperCase().equals("ACACIA")) {
                return ACACIA;
            }
            if (name.toUpperCase().equals("DARK_OAK")) {
                return DARK_OAK;
            }
            if (name.toUpperCase().equals("SAND")) {
                return SAND;
            }
            if (name.toUpperCase().equals("MESA")) {
                return MESA;
            }
            if (name.toUpperCase().equals("SNOW")) {
                return SNOW;
            }
            if (name.toUpperCase().equals("MUSHROOM")) {
                return MUSHROOM;
            }
            return defaultType;
        }
    }
}

