/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.stable;

import chococraftplus.common.config.GeneralConfig;
import chococraftplus.common.entities.EntityChocobo;
import chococraftplus.common.entities.FactoryEntityChocobo;
import chococraftplus.common.stable.ComponentChocoboStable;
import chococraftplus.common.utils.ChocoFunctions;
import chococraftplus.common.utils.LogHelper;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MapGenStable
extends MapGenStructure {
    private static int maxDistanceBetweenScatteredFeatures;
    private static int minDistanceBetweenScatteredFeatures;
    private static final int WORLD_STABLE_SEED_MODULATOR = 19940402;

    public MapGenStable() {
        minDistanceBetweenScatteredFeatures = Math.max(GeneralConfig.worldStableSpacing - GeneralConfig.worldStableSpread / 2, 0);
        maxDistanceBetweenScatteredFeatures = GeneralConfig.worldStableSpacing + (GeneralConfig.worldStableSpread + 1) / 2;
    }

    public MapGenStable(Map map) {
        this();
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getKey()).equals("distance")) continue;
            maxDistanceBetweenScatteredFeatures = MathHelper.func_82714_a((String)((String)entry.getValue()), (int)maxDistanceBetweenScatteredFeatures, (int)(minDistanceBetweenScatteredFeatures + 1));
        }
    }

    public String func_143025_a() {
        return "ChocoboStable";
    }

    public boolean func_75047_a(int chunkX, int chunkZ) {
        return MapGenStable.canSpawnStructureAtCoords(this.field_75039_c, chunkX, chunkZ);
    }

    protected static boolean canSpawnStructureAtCoords(World worldIn, int chunkX, int chunkZ) {
        int k = chunkX;
        int l = chunkZ;
        if (chunkX < 0) {
            chunkX -= maxDistanceBetweenScatteredFeatures - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= maxDistanceBetweenScatteredFeatures - 1;
        }
        int i1 = chunkX / maxDistanceBetweenScatteredFeatures;
        int j1 = chunkZ / maxDistanceBetweenScatteredFeatures;
        Random random = worldIn.func_72843_D(i1, j1, 19940402);
        i1 *= maxDistanceBetweenScatteredFeatures;
        j1 *= maxDistanceBetweenScatteredFeatures;
        if (k == (i1 += random.nextInt(maxDistanceBetweenScatteredFeatures - minDistanceBetweenScatteredFeatures)) && l == (j1 += random.nextInt(maxDistanceBetweenScatteredFeatures - minDistanceBetweenScatteredFeatures))) {
            Biome biome = worldIn.func_72959_q().func_180631_a(new BlockPos((k << 4) + 8, 0, (l << 4) + 8));
            if (GeneralConfig.stableBiomesNames != null) {
                for (int i = 0; i < GeneralConfig.stableBiomesNames.length; ++i) {
                    if (!GeneralConfig.stableBiomesNames[i].toLowerCase().equals(ChocoFunctions.getBiomeName(biome).toLowerCase())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        return MapGenStable.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)maxDistanceBetweenScatteredFeatures, (int)minDistanceBetweenScatteredFeatures, (int)19940402, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    @SubscribeEvent(receiveCanceled=true)
    public void retroGenStable(WorldEvent.Load event) {
        if (event.getWorld().field_73011_w.getDimension() == 0 && !event.getWorld().field_72995_K) {
            World world = event.getWorld();
            Random random = world.field_73012_v;
            for (int stableType = 0; stableType < 2; ++stableType) {
                try {
                    MapGenStructureData structureData = (MapGenStructureData)event.getWorld().getPerWorldStorage().func_75742_a(MapGenStructureData.class, (new String[]{"Village", "ChocoboStable"})[stableType]);
                    NBTTagCompound nbttagcompound = structureData.func_143041_a();
                    for (Object element : nbttagcompound.func_150296_c()) {
                        try {
                            int zPos;
                            int xPos;
                            NBTBase nbtbase = nbttagcompound.func_74781_a(element.toString());
                            if (nbtbase.func_74732_a() != 10) continue;
                            NBTTagCompound stableTagCompound = (NBTTagCompound)nbtbase;
                            NBTTagList childrenTagList = stableTagCompound.func_150295_c("Children", 10);
                            NBTTagCompound childrenTagCompound = null;
                            if (stableType == 0) {
                                for (int tag_index = 0; tag_index < childrenTagList.func_74745_c(); ++tag_index) {
                                    if (!childrenTagList.func_150305_b(tag_index).func_74779_i("id").equals("ChocStbl")) continue;
                                    childrenTagCompound = childrenTagList.func_150305_b(tag_index);
                                    break;
                                }
                            } else {
                                childrenTagCompound = childrenTagList.func_150305_b(0);
                            }
                            if (childrenTagCompound == null) continue;
                            boolean hasChocobo = childrenTagCompound.func_74764_b("Chocobo");
                            int horizIndex = childrenTagCompound.func_74762_e("O");
                            int[] bbCoords = childrenTagCompound.func_74759_k("BB");
                            if (hasChocobo) continue;
                            int yPos = bbCoords[1] + 2;
                            switch (horizIndex) {
                                default: {
                                    xPos = bbCoords[0] + (3 + random.nextInt(6));
                                    zPos = bbCoords[2] + (9 + random.nextInt(3));
                                    break;
                                }
                                case 1: {
                                    xPos = bbCoords[3] - (9 + random.nextInt(3));
                                    zPos = bbCoords[2] + (3 + random.nextInt(6));
                                    break;
                                }
                                case 2: {
                                    xPos = bbCoords[0] + (3 + random.nextInt(6));
                                    zPos = bbCoords[5] - (9 + random.nextInt(3));
                                    break;
                                }
                                case 3: {
                                    xPos = bbCoords[0] + (9 + random.nextInt(3));
                                    zPos = bbCoords[2] + (3 + random.nextInt(6));
                                }
                            }
                            EntityChocobo stableChocobo = FactoryEntityChocobo.createStableChocobo(world, random);
                            stableChocobo.func_70012_b((double)xPos + 0.5, (double)yPos + (double)(stableType == 0 ? 0 : 3) + 0.5, (double)zPos + 0.5, random.nextFloat() * 360.0f, 0.0f);
                            stableChocobo.func_180482_a(world.func_175649_E(new BlockPos((Entity)stableChocobo)), null);
                            int i = MathHelper.func_76128_c((double)(stableChocobo.field_70165_t / 16.0));
                            int j = MathHelper.func_76128_c((double)(stableChocobo.field_70161_v / 16.0));
                            world.func_72964_e(i, j).func_76612_a((Entity)stableChocobo);
                            world.field_72996_f.add(stableChocobo);
                            world.func_72923_a((Entity)stableChocobo);
                            LogHelper.info("Successfully retro-generated chocobo into " + (stableType == 0 ? "village" : "world") + " stable" + (GeneralConfig.debugMessages ? " at x=" + xPos + ", y=" + yPos + ", z=" + zPos : ""));
                            childrenTagCompound.func_74757_a("Chocobo", true);
                            structureData.func_76186_a(true);
                        }
                        catch (Exception e) {
                            LogHelper.warn("Failed to evaluate World Chocobo Stable");
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    if (!GeneralConfig.debugMessages) continue;
                    LogHelper.warn("Failed to load ChocoboStable list, or none exists.");
                }
            }
        }
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World worldIn, Random rand, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            Biome biome = worldIn.func_180494_b(new BlockPos((chunkX << 4) + 8, 0, (chunkZ << 4) + 8));
            if (GeneralConfig.stableBiomesNames != null) {
                for (int i = 0; i < GeneralConfig.stableBiomesNames.length; ++i) {
                    if (!GeneralConfig.stableBiomesNames[i].toLowerCase().equals(ChocoFunctions.getBiomeName(biome).toLowerCase())) continue;
                    ComponentChocoboStable.ChocoboStableWorld stable = new ComponentChocoboStable.ChocoboStableWorld(rand, chunkX << 4, chunkZ << 4, worldIn.func_72959_q());
                    this.field_75075_a.add(stable);
                }
            }
            this.func_75072_c();
        }
    }
}

