/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.stable;

import chococraftplus.common.config.GeneralConfig;
import chococraftplus.common.entities.EntityChocobo;
import chococraftplus.common.entities.FactoryEntityChocobo;
import chococraftplus.common.entities.villager.ModProfessions;
import chococraftplus.common.registry.ChocoCraftBlocks;
import chococraftplus.common.registry.ChocoCraftItems;
import chococraftplus.common.stable.chestloot.ChestGenHooks;
import chococraftplus.common.stable.chestloot.WeightedRandomChestContent;
import chococraftplus.common.utils.ChocoFunctions;
import chococraftplus.common.utils.LogHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ComponentChocoboStable {
    private static final String[] foundationPattern = new String[]{"FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "   FFFFFF   ", "    FFFF    "};
    public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
    public static final int STRUCTURE_DEPTH = foundationPattern.length;
    public static final int STRUCTURE_HEIGHT = 12;
    private static final int GROUND_LEVEL = 2;
    private static final int INCREASE_MIN_U = 0;
    private static final int DECREASE_MAX_U = 0;
    protected static final String CHOCOBO_NBT_TAG = "Chocobo";
    public static final String CHOCOBOSTABLE_WORLDDATA = "ChocoboStable";
    public static final String CHOCOBOSTABLE_ID = "Stable";
    public static final String CHOCOBOSTABLE_CHILD_ID = "Stbl";
    public static final String VILLAGE_STABLE_ID = "ChocStbl";
    private static final int[][] COBBLESTONE_POS = new int[][]{{4, -1, 0, 7, -1, 0}, {3, -1, 1, 8, -1, 1}, {4, -2, 0, 7, -2, 0}, {0, -2, 2, 1, -1, STRUCTURE_DEPTH - 1}, {2, -2, 2, 2, -2, STRUCTURE_DEPTH - 1}, {2, -1, 2, 2, -1, 3}, {2, -1, 7, 2, -1, STRUCTURE_DEPTH - 1}, {3, -2, 2, STRUCTURE_WIDTH - 1, -1, STRUCTURE_DEPTH - 1}, {1, 1, 4, 1, 4, 4}, {1, 1, 3, 1, 4, 3}, {2, 2, 3, 2, 5, 3}, {10, 1, 4, 10, 4, 4}, {10, 1, 3, 10, 4, 3}, {9, 2, 3, 9, 5, 3}, {1, 1, 12, 1, 4, 12}, {1, 1, 13, 1, 4, 13}, {2, 1, 13, 2, 5, 13}, {10, 1, 12, 10, 4, 12}, {10, 1, 13, 10, 4, 13}, {9, 1, 13, 9, 5, 13}};
    private static final int[][] LOG_HOR_ALONG_POS = new int[][]{{0, 3, 3, 0, 3, 13}, {3, 5, 3, 3, 5, 13}, {11, 3, 3, 11, 3, 13}, {8, 5, 3, 8, 5, 13}};
    private static final int[][] LOG_HOR_ACROSS_POS = new int[][]{{1, 3, 2, 10, 3, 2}, {1, 3, 14, 10, 3, 14}};
    private static final int[][] BRICK_POS = new int[][]{{0, 0, 2, 0, 3, 2}, {11, 0, 2, 11, 3, 2}, {0, 0, 14, 0, 3, 14}, {11, 0, 14, 11, 3, 14}, {4, 0, 2, 4, 2, 2}, {7, 0, 2, 7, 2, 2}, {3, 0, 3, 4, 2, 3}, {7, 0, 3, 8, 2, 3}, {3, 3, 3, 8, 4, 3}, {4, 5, 3, 7, 5, 3}, {4, 6, 3, 4, 7, 3}, {4, 8, 3, 7, 8, 3}, {7, 6, 3, 7, 7, 3}, {3, 0, 13, 8, 4, 13}, {4, 5, 13, 7, 5, 13}, {4, 6, 13, 4, 7, 13}, {4, 8, 13, 7, 8, 13}, {7, 6, 13, 7, 7, 13}, {3, 6, 7, 3, 6, 9}, {8, 6, 7, 8, 6, 9}, {1, 0, 5, 1, 0, 6}, {1, 2, 5, 1, 4, 6}, {1, 0, 7, 1, 4, 11}, {10, 0, 5, 10, 0, 6}, {10, 2, 5, 10, 4, 6}, {10, 0, 7, 10, 4, 11}, {2, 5, 3, 2, 5, 12}, {9, 5, 3, 9, 5, 12}, {1, 5, 4, 1, 5, 4}, {1, 5, 7, 1, 5, 7}, {1, 5, 9, 1, 5, 9}, {1, 5, 12, 1, 5, 12}, {3, 7, 4, 3, 7, 4}, {3, 7, 7, 3, 7, 7}, {3, 7, 9, 3, 7, 9}, {3, 7, 12, 3, 7, 12}, {8, 7, 4, 8, 7, 4}, {8, 7, 7, 8, 7, 7}, {8, 7, 9, 8, 7, 9}, {8, 7, 12, 8, 7, 12}, {10, 5, 4, 10, 5, 4}, {10, 5, 7, 10, 5, 7}, {10, 5, 9, 10, 5, 9}, {10, 5, 12, 10, 5, 12}, {3, 6, 3, 3, 6, 3}, {3, 6, 4, 3, 7, 4}, {8, 6, 3, 8, 6, 3}, {8, 6, 4, 8, 7, 4}, {3, 6, 13, 3, 6, 13}, {3, 6, 12, 3, 7, 12}, {8, 6, 13, 8, 6, 13}, {8, 6, 12, 8, 7, 12}};
    private static final int[][] TORCH_POS = new int[][]{{4, 2, 4, 0}, {7, 2, 4, 0}, {4, 2, 12, 2}, {7, 2, 12, 2}, {2, 2, 8, 1}, {9, 2, 8, 3}, {4, 6, 4, 0}, {7, 6, 4, 0}, {4, 6, 12, 2}, {7, 6, 12, 2}, {4, 2, 1, 2}, {7, 2, 1, 2}};
    private static final int[][] STONE_BRICK_POS = new int[][]{{1, 0, 2, 3, 0, 2}, {8, 0, 2, 10, 0, 2}, {1, 0, 14, 10, 0, 14}, {0, 0, 3, 0, 0, 13}, {11, 0, 3, 11, 0, 13}};
    private static final int[][] PLANK_POS = new int[][]{{1, 0, 3, 2, 0, 3}, {1, 0, 4, 1, 0, 4}, {9, 0, 3, 10, 0, 3}, {10, 0, 4, 10, 0, 4}, {1, 0, 13, 2, 0, 13}, {1, 0, 12, 1, 0, 12}, {9, 0, 13, 10, 0, 13}, {10, 0, 12, 10, 0, 12}, {1, 1, 2, 1, 1, 2}, {3, 1, 2, 3, 1, 2}, {8, 1, 2, 8, 1, 2}, {10, 1, 2, 10, 1, 2}, {1, 1, 14, 10, 1, 14}, {0, 1, 3, 0, 1, 4}, {0, 1, 7, 0, 1, 13}, {11, 1, 3, 11, 1, 4}, {11, 1, 7, 11, 1, 13}};
    private static final int[][] GLASS_PANE_POS = new int[][]{{2, 1, 2}, {9, 1, 2}};
    private static final int[][] GLASS_PANE_OR_WALL_POS = new int[][]{{0, 1, 5, -1, 1}, {0, 1, 6, -1, 1}, {11, 1, 5, 12, 10}, {11, 1, 6, 12, 10}};
    private static final int[][] FENCE_POS = new int[][]{{5, 6, 3, 6, 7, 3}, {5, 6, 13, 6, 7, 13}, {3, 6, 5, 3, 7, 6}, {3, 6, 10, 3, 7, 11}, {8, 6, 5, 8, 7, 6}, {8, 6, 10, 8, 7, 11}, {1, 6, 4, 1, 6, 4}, {1, 6, 7, 1, 6, 7}, {1, 6, 9, 1, 6, 9}, {1, 6, 12, 1, 6, 12}, {10, 6, 4, 10, 6, 4}, {10, 6, 7, 10, 6, 7}, {10, 6, 9, 10, 6, 9}, {10, 6, 12, 10, 6, 12}, {3, 3, 7, 3, 4, 7}, {2, 0, 8, 4, 0, 8}, {7, 0, 8, 9, 0, 8}};
    private static final int[][] WOOD_STAIRS_POS = new int[][]{{1, 2, 2, 3, 2, 2, 3}, {8, 2, 2, 10, 2, 2, 3}, {1, 2, 14, 10, 2, 14, 2}, {0, 2, 3, 0, 2, 13, 0}, {11, 2, 3, 11, 2, 13, 1}, {2, 4, 4, 9, 4, 4, 6}, {2, 4, 12, 9, 4, 12, 7}, {2, 4, 5, 2, 4, 11, 5}, {9, 4, 5, 9, 4, 11, 4}, {3, 0, 5, 3, 0, 6, 5}, {2, 0, 7, 3, 0, 7, 6}};
    private static final int[][] BIRCH_STAIRS_POS = new int[][]{{0, 4, 2, 0}, {1, 5, 2, 0}, {2, 6, 2, 0}, {3, 7, 2, 0}, {4, 8, 2, 0}, {11, 4, 2, 1}, {10, 5, 2, 1}, {9, 6, 2, 1}, {8, 7, 2, 1}, {7, 8, 2, 1}, {1, 4, 2, 5}, {2, 5, 2, 5}, {3, 6, 2, 5}, {4, 7, 2, 5}, {10, 4, 2, 4}, {9, 5, 2, 4}, {8, 6, 2, 4}, {7, 7, 2, 4}, {0, 4, 14, 0}, {1, 5, 14, 0}, {2, 6, 14, 0}, {3, 7, 14, 0}, {4, 8, 14, 0}, {11, 4, 14, 1}, {10, 5, 14, 1}, {9, 6, 14, 1}, {8, 7, 14, 1}, {7, 8, 14, 1}, {1, 4, 14, 5}, {2, 5, 14, 5}, {3, 6, 14, 5}, {4, 7, 14, 5}, {10, 4, 14, 4}, {9, 5, 14, 4}, {8, 6, 14, 4}, {7, 7, 14, 4}};
    private static final int[][] WOOD_SLAB_TOP_POS = new int[][]{{3, 5, 2, 8, 5, 2}, {5, 7, 2, 6, 7, 2}, {3, 5, 14, 8, 5, 14}, {5, 7, 14, 6, 7, 14}, {3, 2, 4, 3, 2, 6}, {2, 2, 7, 3, 2, 7}};
    private static final int[][] SMOOTH_STONE_SLAB_POS = new int[][]{{5, 2, 3, 6, 2, 3}};
    private static final int[][] STONE_BRICK_SLAB_TOP_POS = new int[][]{{2, 4, 2, 3, 4, 2}, {5, 4, 2, 6, 4, 2}, {8, 4, 2, 9, 4, 2}, {2, 4, 14, 3, 4, 14}, {5, 4, 14, 6, 4, 14}, {8, 4, 14, 9, 4, 14}};
    private static final int[][] STONE_BRICK_STAIRS_POS = new int[][]{{4, 4, 2, 7}, {7, 4, 2, 7}, {4, 4, 14, 6}, {7, 4, 14, 6}};
    private static final int[][] BRICK_STAIRS_POS = new int[][]{{5, 8, 2, 5, 8, 2, 5}, {6, 8, 2, 6, 8, 2, 4}, {5, 8, 14, 5, 8, 14, 5}, {6, 8, 14, 6, 8, 14, 4}, {0, 4, 3, 0, 4, 13, 0}, {1, 5, 3, 1, 5, 3, 0}, {1, 5, 5, 1, 5, 6, 0}, {1, 5, 8, 1, 5, 8, 0}, {1, 5, 10, 1, 5, 11, 0}, {1, 5, 13, 1, 5, 13, 0}, {2, 6, 3, 2, 6, 4, 0}, {2, 6, 7, 2, 6, 9, 0}, {2, 6, 12, 2, 6, 13, 0}, {3, 7, 3, 3, 7, 3, 0}, {2, 7, 4, 2, 7, 4, 0}, {1, 7, 5, 1, 7, 5, 6}, {1, 7, 6, 1, 7, 6, 7}, {2, 7, 7, 2, 7, 7, 0}, {3, 7, 8, 3, 7, 8, 0}, {2, 7, 9, 2, 7, 9, 0}, {1, 7, 10, 1, 7, 10, 6}, {1, 7, 11, 1, 7, 11, 7}, {2, 7, 12, 2, 7, 12, 0}, {3, 7, 13, 3, 7, 13, 0}, {4, 8, 3, 4, 8, 13, 0}, {11, 4, 3, 11, 4, 13, 1}, {10, 5, 3, 10, 5, 3, 1}, {10, 5, 5, 10, 5, 6, 1}, {10, 5, 8, 10, 5, 8, 1}, {10, 5, 10, 10, 5, 11, 1}, {10, 5, 13, 10, 5, 13, 0}, {9, 6, 3, 9, 6, 4, 1}, {9, 6, 7, 9, 6, 9, 1}, {9, 6, 12, 9, 6, 13, 1}, {8, 7, 3, 8, 7, 3, 1}, {9, 7, 4, 9, 7, 4, 1}, {10, 7, 5, 10, 7, 5, 6}, {10, 7, 6, 10, 7, 6, 7}, {9, 7, 7, 9, 7, 7, 1}, {8, 7, 8, 8, 7, 8, 1}, {9, 7, 9, 9, 7, 9, 1}, {10, 7, 10, 10, 7, 10, 6}, {10, 7, 11, 10, 7, 11, 7}, {9, 7, 12, 9, 7, 12, 1}, {8, 7, 13, 8, 7, 13, 1}, {7, 8, 3, 7, 8, 13, 1}, {4, 7, 4, 4, 7, 4, 5}, {4, 7, 7, 4, 7, 9, 5}, {4, 7, 12, 4, 7, 12, 5}, {7, 7, 4, 7, 7, 4, 4}, {7, 7, 7, 7, 7, 9, 4}, {7, 7, 12, 7, 7, 12, 4}, {5, 8, 4, 6, 8, 4, 6}, {5, 8, 12, 6, 8, 12, 7}};
    private static final int[][] BRICK_SLAB_BOTTOM_POS = new int[][]{{5, 9, 2, 6, 9, 14}, {2, 8, 5, 3, 8, 6}, {1, 7, 4, 1, 7, 4}, {1, 7, 7, 1, 7, 7}, {2, 8, 10, 3, 8, 11}, {1, 7, 9, 1, 7, 9}, {1, 7, 12, 1, 7, 12}, {8, 8, 5, 9, 8, 6}, {10, 7, 4, 10, 7, 4}, {10, 7, 7, 10, 7, 7}, {8, 8, 10, 9, 8, 11}, {10, 7, 9, 10, 7, 9}, {10, 7, 12, 10, 7, 12}};
    private static final int[][] BRICK_SLAB_TOP_POS = new int[][]{{2, 7, 5, 2, 7, 6}, {2, 7, 10, 2, 7, 11}, {9, 7, 5, 9, 7, 6}, {9, 7, 10, 9, 7, 11}};
    private static final int[][] CAULDRON_POS = new int[][]{{9, 0, 5, 0}, {7, 0, 12, 3}, {8, 0, 12, 3}};
    private static final int[][] STRAW_BEDDING_POS = new int[][]{{2, 0, 9, 4, 0, 12}, {5, 0, 8, 6, 0, 12}, {7, 0, 9, 9, 0, 11}, {9, 0, 12, 9, 0, 12}};
    private static final int[][] FENCE_GATE_POS = new int[][]{{3, 0, 4, 1, 0}};
    private static final int[][] WOOD_DOOR_POS = new int[][]{{5, 0, 3, 2, 1, 1}, {6, 0, 3, 2, 1, 0}};
    private static final WeightedRandomChestContent[] STABLE_CHEST_CONTENTS = new WeightedRandomChestContent[]{new WeightedRandomChestContent(new ItemStack(Items.field_151017_I), 1, 1, 10), new WeightedRandomChestContent(new ItemStack(ChocoCraftItems.GYSAHL_SEED_PACKET), 2, 5, 16), new WeightedRandomChestContent(new ItemStack(ChocoCraftItems.CHOCOBO_FEATHER_YELLOW), 1, 5, 12), new WeightedRandomChestContent(new ItemStack(Items.field_151058_ca), 1, 3, 9), new WeightedRandomChestContent(new ItemStack(ChocoCraftBlocks.STRAW_BEDDING), 3, 12, 12), new WeightedRandomChestContent(new ItemStack(ChocoCraftItems.GYSAHL_GARDEN_SEEDS), 1, 4, 10), new WeightedRandomChestContent(new ItemStack(Items.field_151015_O), 1, 1, 5), new WeightedRandomChestContent(new ItemStack(ChocoCraftItems.GYSAHL_CARROT), 2, 8, 8), new WeightedRandomChestContent(new ItemStack(Items.field_151133_ar), 1, 1, 3), new WeightedRandomChestContent(new ItemStack((Block)Blocks.field_150383_bp), 1, 1, 2), new WeightedRandomChestContent(new ItemStack(GeneralConfig.carobAsLoot ? ChocoCraftItems.CAROB_NUT : ChocoCraftItems.GYSAHL_SEED_PACKET), 1, 1, 1), new WeightedRandomChestContent(new ItemStack(GeneralConfig.chocopediaChestLoot ? ChocoCraftItems.CHOCOPEDIA : ChocoCraftItems.GYSAHL_GARDEN_SEEDS), 1, 1, 4)};
    public static final int[] DOOR_META_ARRAY = new int[]{1, 2, 3, 0};
    public static final int[] FENCE_GATE_META_ARRAY = new int[]{0, 1, 2, 3};
    public static final int[][] FURNACE_META_ARRAY = new int[][]{{3, 4, 2, 5}, {5, 3, 5, 3}, {2, 5, 3, 4}, {4, 2, 4, 2}};
    public static final int[] COLOR_METAS = new int[]{15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
    public static final double[] COLOR_WEIGHTS = new double[]{28.0, 56.0, 56.0, 1.0, 56.0, 14.0, 1.0, 1.0, 1.0, 28.0, 1.0, 112.0, 1.0, 1.0, 7.0, 56.0};

    private static void makeChocoboSign(World world, BlockPos pos, EnumFacing coordBaseMode, ChocoFunctions.MaterialType materialType, Biome biome, boolean disallowModSubs) {
        TileEntitySign signContents = new TileEntitySign();
        signContents = ComponentChocoboStable.setChocoboSignText(signContents);
        signContents.func_70296_d();
        IBlockState biomeWallSignState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150444_as.func_176223_P(), materialType, biome, disallowModSubs);
        world.func_180501_a(pos, biomeWallSignState.func_177230_c().func_176203_a(ComponentChocoboStable.getSignRotationMeta(2, coordBaseMode, true)), 2);
        world.func_175690_a(pos, (TileEntity)signContents);
    }

    public static void registerScatteredFeaturePieces() {
        MapGenStructureIO.func_143031_a(ChocoboStableWorld.class, (String)CHOCOBOSTABLE_CHILD_ID);
    }

    public static void registerStableChest() {
        int chestMin = 3;
        int chestMax = 8;
        ChestGenHooks chocoboChestContents = ChestGenHooks.getInfo("stable_chest");
        for (WeightedRandomChestContent wrcc : STABLE_CHEST_CONTENTS) {
            chocoboChestContents.addItem(wrcc);
        }
        chocoboChestContents.setMin(chestMin);
        chocoboChestContents.setMax(chestMax);
    }

    public static int getAboveTopmostSolidOrLiquidBlockVN(World world, int posX, int posZ) {
        Chunk chunk = world.func_175726_f(new BlockPos(posX, 0, posZ));
        int x = posX;
        int z = posZ;
        posX &= 0xF;
        posZ &= 0xF;
        for (int k = chunk.func_76625_h() + 15; k > 0; --k) {
            BlockPos pos = new BlockPos(posX, k, posZ);
            IBlockState blockstate = chunk.func_177435_g(pos);
            Material material = blockstate.func_185904_a();
            if ((!material.func_76230_c() || material == Material.field_151584_j || material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_151579_a || blockstate.func_177230_c().isFoliage((IBlockAccess)world, pos) || !blockstate.func_185915_l()) && !material.func_76224_d()) continue;
            return k + 1;
        }
        return -1;
    }

    public static int getMedianGroundLevel(World world, StructureBoundingBox boundingBox, boolean outlineOnly, byte sideFlag, EnumFacing coordBaseMode) {
        ArrayList<Integer> i = new ArrayList<Integer>();
        for (int k = boundingBox.field_78896_c; k <= boundingBox.field_78892_f; ++k) {
            for (int l = boundingBox.field_78897_a; l <= boundingBox.field_78893_d; ++l) {
                int aboveTopLevel;
                if (!boundingBox.func_175898_b(new Vec3i(l, 64, k))) continue;
                int horizIndex = coordBaseMode.func_176736_b();
                if (outlineOnly && (!outlineOnly || !(k == boundingBox.field_78896_c && (sideFlag & (new int[]{1, 2, 4, 2})[horizIndex]) > 0 || k == boundingBox.field_78892_f && (sideFlag & (new int[]{4, 8, 1, 8})[horizIndex]) > 0 || l == boundingBox.field_78897_a && (sideFlag & (new int[]{2, 4, 2, 1})[horizIndex]) > 0) && (l != boundingBox.field_78893_d || (sideFlag & (new int[]{8, 1, 8, 4})[horizIndex]) <= 0)) || (aboveTopLevel = ComponentChocoboStable.getAboveTopmostSolidOrLiquidBlockVN(world, l, k)) == -1) continue;
                i.add(aboveTopLevel);
            }
        }
        return ChocoFunctions.medianIntArray(i, true);
    }

    public static IBlockState getBiomeSpecificBlockState(IBlockState blockstate, ChocoFunctions.MaterialType materialType, Biome biome, boolean disallowModSubs) {
        if (materialType == null || biome == null) {
            return blockstate;
        }
        Block block = blockstate.func_177230_c();
        int meta = block.func_176201_c(blockstate);
        int woodMeta = 0;
        switch (materialType) {
            default: {
                woodMeta = BlockPlanks.EnumType.OAK.func_176839_a();
                if (block == Blocks.field_150322_A && meta == 2) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 1) {
                    blockstate = Blocks.field_150347_e.func_176203_a(3);
                    break;
                }
                if (block == Blocks.field_150322_A) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150333_U) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 1 ? 3 : (meta == 9 ? 11 : meta));
                    break;
                }
                if (block == Blocks.field_150334_T && meta == 9) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150334_T) {
                    blockstate = Blocks.field_150334_T.func_176203_a(meta == 1 ? 0 : meta);
                    break;
                }
                if (block == Blocks.field_150372_bz) {
                    blockstate = Blocks.field_150446_ar.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150345_g) {
                    blockstate = Blocks.field_150345_g.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150433_aE) {
                    blockstate = Blocks.field_150346_d.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150431_aC) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150432_aD) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block != Blocks.field_150403_cj) break;
                blockstate = Blocks.field_150347_e.func_176223_P();
                break;
            }
            case SPRUCE: {
                woodMeta = BlockPlanks.EnumType.SPRUCE.func_176839_a();
                if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
                    blockstate = Blocks.field_150364_r.func_176203_a(woodMeta % 4);
                    break;
                }
                if (block == Blocks.field_150344_f) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180407_aO) {
                    blockstate = Blocks.field_180408_aP.func_176223_P();
                    break;
                }
                if (block == Blocks.field_180390_bo) {
                    blockstate = Blocks.field_180391_bp.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150476_ad) {
                    blockstate = Blocks.field_150485_bF.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150376_bx) {
                    blockstate = Blocks.field_150376_bx.func_176203_a(meta == 0 ? 0 + woodMeta : (meta == 8 ? 8 + woodMeta : meta));
                    break;
                }
                if (block == Blocks.field_150373_bw) {
                    blockstate = Blocks.field_150373_bw.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180410_as || block == Blocks.field_180412_aq || block == Blocks.field_180409_at || block == Blocks.field_180411_ar || block == Blocks.field_180413_ao || block == Blocks.field_180414_ap) {
                    blockstate = Blocks.field_180414_ap.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 2) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 1) {
                    blockstate = Blocks.field_150347_e.func_176203_a(3);
                    break;
                }
                if (block == Blocks.field_150322_A) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150333_U) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 1 ? 3 : (meta == 9 ? 11 : meta));
                    break;
                }
                if (block == Blocks.field_150334_T && meta == 9) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150334_T) {
                    blockstate = Blocks.field_150334_T.func_176203_a(meta == 1 ? 0 : meta);
                    break;
                }
                if (block == Blocks.field_150372_bz) {
                    blockstate = Blocks.field_150446_ar.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150345_g) {
                    blockstate = Blocks.field_150345_g.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150432_aD) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block != Blocks.field_150403_cj) break;
                blockstate = Blocks.field_150347_e.func_176223_P();
                break;
            }
            case BIRCH: {
                woodMeta = BlockPlanks.EnumType.BIRCH.func_176839_a();
                if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
                    blockstate = Blocks.field_150364_r.func_176203_a(woodMeta % 4);
                    break;
                }
                if (block == Blocks.field_150344_f) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180407_aO) {
                    blockstate = Blocks.field_180404_aQ.func_176223_P();
                    break;
                }
                if (block == Blocks.field_180390_bo) {
                    blockstate = Blocks.field_180392_bq.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150476_ad) {
                    blockstate = Blocks.field_150487_bG.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150376_bx) {
                    blockstate = Blocks.field_150376_bx.func_176203_a(meta == 0 ? 0 + woodMeta : (meta == 8 ? 8 + woodMeta : meta));
                    break;
                }
                if (block == Blocks.field_150373_bw) {
                    blockstate = Blocks.field_150373_bw.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180410_as || block == Blocks.field_180412_aq || block == Blocks.field_180409_at || block == Blocks.field_180411_ar || block == Blocks.field_180413_ao || block == Blocks.field_180414_ap) {
                    blockstate = Blocks.field_180412_aq.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 1) {
                    blockstate = Blocks.field_150347_e.func_176203_a(3);
                    break;
                }
                if (block == Blocks.field_150322_A) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150333_U) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 1 ? 3 : (meta == 9 ? 11 : meta));
                    break;
                }
                if (block == Blocks.field_150334_T && meta == 9) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150334_T) {
                    blockstate = Blocks.field_150334_T.func_176203_a(meta == 1 ? 0 : meta);
                    break;
                }
                if (block == Blocks.field_150372_bz) {
                    blockstate = Blocks.field_150446_ar.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150345_g) {
                    blockstate = Blocks.field_150345_g.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150433_aE) {
                    blockstate = Blocks.field_150346_d.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150431_aC) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150432_aD) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block != Blocks.field_150403_cj) break;
                blockstate = Blocks.field_150347_e.func_176223_P();
                break;
            }
            case JUNGLE: {
                woodMeta = BlockPlanks.EnumType.JUNGLE.func_176839_a();
                if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
                    blockstate = Blocks.field_150364_r.func_176203_a(woodMeta % 4);
                    break;
                }
                if (block == Blocks.field_150347_e) {
                    blockstate = Blocks.field_150341_Y.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150463_bK) {
                    blockstate = Blocks.field_150463_bK.func_176203_a(1);
                    break;
                }
                if (block == Blocks.field_150344_f) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180407_aO) {
                    blockstate = Blocks.field_180403_aR.func_176223_P();
                    break;
                }
                if (block == Blocks.field_180390_bo) {
                    blockstate = Blocks.field_180386_br.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150476_ad) {
                    blockstate = Blocks.field_150481_bH.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150376_bx) {
                    blockstate = Blocks.field_150376_bx.func_176203_a(meta == 0 ? 0 + woodMeta : (meta == 8 ? 8 + woodMeta : meta));
                    break;
                }
                if (block == Blocks.field_150373_bw) {
                    blockstate = Blocks.field_150373_bw.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180410_as || block == Blocks.field_180412_aq || block == Blocks.field_180409_at || block == Blocks.field_180411_ar || block == Blocks.field_180413_ao || block == Blocks.field_180414_ap) {
                    blockstate = Blocks.field_180411_ar.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 2) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 1) {
                    blockstate = Blocks.field_150347_e.func_176203_a(3);
                    break;
                }
                if (block == Blocks.field_150322_A) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150333_U) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 1 ? 3 : (meta == 9 ? 11 : meta));
                    break;
                }
                if (block == Blocks.field_150334_T && meta == 9) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150334_T) {
                    blockstate = Blocks.field_150334_T.func_176203_a(meta == 1 ? 0 : meta);
                    break;
                }
                if (block == Blocks.field_150372_bz) {
                    blockstate = Blocks.field_150446_ar.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150345_g) {
                    blockstate = Blocks.field_150345_g.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150433_aE) {
                    blockstate = Blocks.field_150346_d.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150431_aC) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150432_aD) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block != Blocks.field_150403_cj) break;
                blockstate = Blocks.field_150347_e.func_176223_P();
                break;
            }
            case ACACIA: {
                woodMeta = BlockPlanks.EnumType.ACACIA.func_176839_a();
                if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
                    blockstate = Blocks.field_150363_s.func_176203_a(woodMeta % 4);
                    break;
                }
                if (block == Blocks.field_150344_f) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180407_aO) {
                    blockstate = Blocks.field_180405_aT.func_176223_P();
                    break;
                }
                if (block == Blocks.field_180390_bo) {
                    blockstate = Blocks.field_180387_bt.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150476_ad) {
                    blockstate = Blocks.field_150400_ck.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150376_bx) {
                    blockstate = Blocks.field_150376_bx.func_176203_a(meta == 0 ? 0 + woodMeta : (meta == 8 ? 8 + woodMeta : meta));
                    break;
                }
                if (block == Blocks.field_150373_bw) {
                    blockstate = Blocks.field_150373_bw.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180410_as || block == Blocks.field_180412_aq || block == Blocks.field_180409_at || block == Blocks.field_180411_ar || block == Blocks.field_180413_ao || block == Blocks.field_180414_ap) {
                    blockstate = Blocks.field_180410_as.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 2) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 1) {
                    blockstate = Blocks.field_150347_e.func_176203_a(3);
                    break;
                }
                if (block == Blocks.field_150322_A) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150333_U) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 1 ? 3 : (meta == 9 ? 11 : meta));
                    break;
                }
                if (block == Blocks.field_150334_T && meta == 9) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150334_T) {
                    blockstate = Blocks.field_150334_T.func_176203_a(meta == 1 ? 0 : meta);
                    break;
                }
                if (block == Blocks.field_150372_bz) {
                    blockstate = Blocks.field_150446_ar.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150345_g) {
                    blockstate = Blocks.field_150345_g.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150433_aE) {
                    blockstate = Blocks.field_150346_d.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150431_aC) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150432_aD) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block != Blocks.field_150403_cj) break;
                blockstate = Blocks.field_150347_e.func_176223_P();
                break;
            }
            case DARK_OAK: {
                woodMeta = BlockPlanks.EnumType.DARK_OAK.func_176839_a();
                if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
                    blockstate = Blocks.field_150363_s.func_176203_a(woodMeta % 4);
                    break;
                }
                if (block == Blocks.field_150344_f) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180407_aO) {
                    blockstate = Blocks.field_180406_aS.func_176223_P();
                    break;
                }
                if (block == Blocks.field_180390_bo) {
                    blockstate = Blocks.field_180385_bs.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150476_ad) {
                    blockstate = Blocks.field_150401_cl.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150376_bx) {
                    blockstate = Blocks.field_150376_bx.func_176203_a(meta == 0 ? 0 + woodMeta : (meta == 8 ? 8 + woodMeta : meta));
                    break;
                }
                if (block == Blocks.field_150373_bw) {
                    blockstate = Blocks.field_150373_bw.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180410_as || block == Blocks.field_180412_aq || block == Blocks.field_180409_at || block == Blocks.field_180411_ar || block == Blocks.field_180413_ao || block == Blocks.field_180414_ap) {
                    blockstate = Blocks.field_180409_at.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 2) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 1) {
                    blockstate = Blocks.field_150347_e.func_176203_a(3);
                    break;
                }
                if (block == Blocks.field_150322_A) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150333_U) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 1 ? 3 : (meta == 9 ? 11 : meta));
                    break;
                }
                if (block == Blocks.field_150334_T && meta == 9) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150334_T) {
                    blockstate = Blocks.field_150334_T.func_176203_a(meta == 1 ? 0 : meta);
                    break;
                }
                if (block == Blocks.field_150372_bz) {
                    blockstate = Blocks.field_150446_ar.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150345_g) {
                    blockstate = Blocks.field_150345_g.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150433_aE) {
                    blockstate = Blocks.field_150346_d.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150431_aC) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150432_aD) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block != Blocks.field_150403_cj) break;
                blockstate = Blocks.field_150347_e.func_176223_P();
                break;
            }
            case SAND: {
                woodMeta = BlockPlanks.EnumType.JUNGLE.func_176839_a();
                if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
                    blockstate = Blocks.field_150322_A.func_176203_a(2);
                    break;
                }
                if (block == Blocks.field_150417_aV && meta == 0) {
                    blockstate = Blocks.field_150322_A.func_176203_a(2);
                    break;
                }
                if (block == Blocks.field_150347_e && meta == 3) {
                    blockstate = Blocks.field_150322_A.func_176203_a(1);
                    break;
                }
                if (block == Blocks.field_150347_e) {
                    blockstate = Blocks.field_150322_A.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150341_Y) {
                    blockstate = Blocks.field_150322_A.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150344_f) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180407_aO) {
                    blockstate = Blocks.field_180403_aR.func_176223_P();
                    break;
                }
                if (block == Blocks.field_180387_bt || block == Blocks.field_180392_bq || block == Blocks.field_180385_bs || block == Blocks.field_180386_br || block == Blocks.field_180390_bo || block == Blocks.field_180391_bp) {
                    blockstate = Blocks.field_180386_br.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150476_ad) {
                    blockstate = Blocks.field_150481_bH.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150446_ar) {
                    blockstate = Blocks.field_150372_bz.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150351_n) {
                    blockstate = Blocks.field_150322_A.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150346_d) {
                    blockstate = Blocks.field_150354_m.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150349_c) {
                    blockstate = Blocks.field_150354_m.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150376_bx) {
                    blockstate = Blocks.field_150376_bx.func_176203_a(meta == 0 ? 0 + woodMeta : (meta == 8 ? 8 + woodMeta : meta));
                    break;
                }
                if (block == Blocks.field_150373_bw) {
                    blockstate = Blocks.field_150373_bw.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180410_as || block == Blocks.field_180412_aq || block == Blocks.field_180409_at || block == Blocks.field_180411_ar || block == Blocks.field_180413_ao || block == Blocks.field_180414_ap) {
                    blockstate = Blocks.field_180411_ar.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150333_U) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 3 ? 1 : (meta == 11 ? 9 : meta));
                    break;
                }
                if (block == Blocks.field_150345_g) {
                    blockstate = Blocks.field_150330_I.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150433_aE) {
                    blockstate = Blocks.field_150354_m.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150431_aC) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150432_aD) {
                    blockstate = Blocks.field_150322_A.func_176203_a(0);
                    break;
                }
                if (block != Blocks.field_150403_cj) break;
                blockstate = Blocks.field_150322_A.func_176203_a(2);
                break;
            }
            case MESA: {
                if (block == Blocks.field_150347_e) {
                    blockstate = Blocks.field_150405_ch.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150341_Y) {
                    blockstate = Blocks.field_150405_ch.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150446_ar) {
                    blockstate = Blocks.field_150389_bf.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150351_n) {
                    blockstate = Blocks.field_150405_ch.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150354_m) {
                    blockstate = Blocks.field_150354_m.func_176203_a(1);
                    break;
                }
                if (block == Blocks.field_150322_A) {
                    blockstate = Blocks.field_180395_cM.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150333_U) {
                    blockstate = Blocks.field_180389_cP.func_176203_a(meta >= 8 ? 8 : 0);
                    break;
                }
                if (block == Blocks.field_150372_bz) {
                    blockstate = Blocks.field_180396_cN.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150345_g) {
                    blockstate = Blocks.field_150329_H.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150433_aE) {
                    blockstate = Blocks.field_150354_m.func_176203_a(1);
                    break;
                }
                if (block == Blocks.field_150431_aC) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150432_aD) {
                    blockstate = Blocks.field_150405_ch.func_176223_P();
                    break;
                }
                if (block != Blocks.field_150403_cj) break;
                blockstate = Blocks.field_150405_ch.func_176223_P();
                break;
            }
            case SNOW: {
                woodMeta = BlockPlanks.EnumType.SPRUCE.func_176839_a();
                if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
                    blockstate = Blocks.field_150364_r.func_176203_a(woodMeta % 4);
                    break;
                }
                if (block == Blocks.field_150344_f) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180407_aO) {
                    blockstate = Blocks.field_180408_aP.func_176223_P();
                    break;
                }
                if (block == Blocks.field_180390_bo) {
                    blockstate = Blocks.field_180391_bp.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150476_ad) {
                    blockstate = Blocks.field_150485_bF.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150376_bx) {
                    blockstate = Blocks.field_150376_bx.func_176203_a(meta == 0 ? 0 + woodMeta : (meta == 8 ? 8 + woodMeta : meta));
                    break;
                }
                if (block == Blocks.field_150373_bw) {
                    blockstate = Blocks.field_150373_bw.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180410_as || block == Blocks.field_180412_aq || block == Blocks.field_180409_at || block == Blocks.field_180411_ar || block == Blocks.field_180413_ao || block == Blocks.field_180414_ap) {
                    blockstate = Blocks.field_180414_ap.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150341_Y) {
                    blockstate = Blocks.field_150347_e.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150322_A) {
                    blockstate = Blocks.field_150347_e.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150333_U) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 1 ? 3 : (meta == 9 ? 11 : meta));
                    break;
                }
                if (block == Blocks.field_150334_T && meta == 9) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150334_T) {
                    blockstate = Blocks.field_150334_T.func_176203_a(meta == 1 ? 0 : meta);
                    break;
                }
                if (block == Blocks.field_150372_bz) {
                    blockstate = Blocks.field_150446_ar.func_176203_a(meta);
                    break;
                }
                if (block != Blocks.field_150345_g) break;
                blockstate = Blocks.field_150345_g.func_176203_a(woodMeta);
                break;
            }
            case MUSHROOM: {
                if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(15);
                    break;
                }
                if (block == Blocks.field_150347_e) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(14);
                    break;
                }
                if (block == Blocks.field_150341_Y) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(14);
                    break;
                }
                if (block == Blocks.field_150344_f) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150347_e && meta == 3) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(14);
                    break;
                }
                if (block == Blocks.field_150417_aV) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(14);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 2) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(14);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 1) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(14);
                    break;
                }
                if (block == Blocks.field_150322_A) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(14);
                    break;
                }
                if (block == Blocks.field_150333_U) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 1 ? 3 : (meta == 9 ? 11 : meta));
                    break;
                }
                if (block == Blocks.field_150334_T && meta == 9) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150334_T) {
                    blockstate = Blocks.field_150334_T.func_176203_a(meta == 1 ? 0 : meta);
                    break;
                }
                if (block == Blocks.field_150372_bz) {
                    blockstate = Blocks.field_150446_ar.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150345_g) {
                    blockstate = Blocks.field_150338_P.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150349_c) {
                    blockstate = Blocks.field_150391_bh.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150433_aE) {
                    blockstate = Blocks.field_150346_d.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150431_aC) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150432_aD) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(0);
                    break;
                }
                if (block != Blocks.field_150403_cj) break;
                blockstate = Blocks.field_150420_aW.func_176203_a(14);
            }
        }
        if (!disallowModSubs) {
            BiomeEvent.GetVillageBlockID villageBlockEvent = new BiomeEvent.GetVillageBlockID(biome == null ? null : biome, blockstate);
            MinecraftForge.TERRAIN_GEN_BUS.post((Event)villageBlockEvent);
            if (villageBlockEvent.getResult() == Event.Result.DENY) {
                return villageBlockEvent.getReplacement();
            }
        }
        return blockstate;
    }

    public static Map<String, ArrayList<String>> unpackBiomes(String[] inputList) {
        ArrayList<String> biomeNames = new ArrayList<String>();
        ArrayList<String> villageTypes = new ArrayList<String>();
        ArrayList<String> materialTypes = new ArrayList<String>();
        ArrayList<String> disallowModSubs = new ArrayList<String>();
        for (String entry : inputList) {
            entry.replaceAll("\\)", "");
            entry.replaceAll("\\(", "");
            String[] splitEntry = entry.split("\\|");
            String biomeName = "";
            String villageType = "";
            String materialType = "";
            String disallowModSub = "";
            try {
                biomeName = splitEntry[0].trim();
            }
            catch (Exception e) {
                biomeName = "";
            }
            try {
                villageType = splitEntry[1].trim();
            }
            catch (Exception e) {
                villageType = "";
            }
            try {
                materialType = splitEntry[2].trim();
            }
            catch (Exception e) {
                materialType = "";
            }
            try {
                disallowModSub = splitEntry[3].trim();
            }
            catch (Exception e) {
                disallowModSub = "";
            }
            if (biomeName.equals("")) continue;
            biomeNames.add(biomeName);
            villageTypes.add(villageType);
            materialTypes.add(materialType);
            disallowModSubs.add(disallowModSub);
        }
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        map.put("BiomeNames", biomeNames);
        map.put("VillageTypes", villageTypes);
        map.put("MaterialTypes", materialTypes);
        map.put("DisallowModSubs", disallowModSubs);
        return map;
    }

    public static int getTorchRotationMeta(int relativeOrientation) {
        switch (relativeOrientation) {
            case 0: {
                return 4;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    public static int[] getDoorMetas(int orientation, EnumFacing coordBaseMode, boolean isShut, boolean isRightHanded) {
        int horizIndex = coordBaseMode.func_176736_b();
        return new int[]{DOOR_META_ARRAY[orientation] + (isShut ? 0 : 4), isRightHanded ? 8 : 9};
    }

    public static int chooseFenceGateMeta(int orientation, boolean isOpen) {
        return FENCE_GATE_META_ARRAY[orientation] + (isOpen ? 4 : 0);
    }

    public static void cleanEntityItems(World world, StructureBoundingBox boundingBox) {
        AxisAlignedBB aabb = new AxisAlignedBB((double)boundingBox.field_78897_a, (double)boundingBox.field_78895_b, (double)boundingBox.field_78896_c, (double)boundingBox.field_78893_d, (double)boundingBox.field_78894_e, (double)boundingBox.field_78892_f).func_72314_b(3.0, 8.0, 3.0);
        List list = world.func_175647_a(EntityItem.class, aabb, null);
        if (!list.isEmpty()) {
            for (EntityItem entityitem : list) {
                entityitem.func_70106_y();
            }
            if (GeneralConfig.debugMessages) {
                LogHelper.info("Cleaned " + list.size() + " Entity items within " + aabb.toString());
            }
        }
    }

    protected static boolean generateStructureFlowerPot(World world, StructureBoundingBox box, Random random, BlockPos pos, Block block, int meta) {
        IBlockState blockstate = world.func_180495_p(pos);
        if (box.func_175898_b((Vec3i)pos) && blockstate.func_177230_c() != Blocks.field_150457_bL) {
            world.func_180501_a(pos, Blocks.field_150457_bL.func_176223_P(), 2);
            TileEntityFlowerPot tileentityflowerpot = (TileEntityFlowerPot)world.func_175625_s(pos);
            if (tileentityflowerpot != null) {
                if (!ComponentChocoboStable.isNotPlaceableIntoPot(block, meta)) {
                    return false;
                }
                tileentityflowerpot.func_190614_a(new ItemStack(Item.func_150898_a((Block)block), 1, meta));
                tileentityflowerpot.func_70296_d();
                if (!world.func_180501_a(pos, Blocks.field_150457_bL.func_176223_P(), 2)) {
                    world.func_184138_a(pos, blockstate, Blocks.field_150457_bL.func_176223_P(), 2);
                }
                return true;
            }
            return true;
        }
        return false;
    }

    private static boolean isNotPlaceableIntoPot(Block block, int meta) {
        Block flowerModded = null;
        for (String modFlower : new String[]{"futuremc:cornflower", "futuremc:lily_of_the_valley", "futureminecraf:cornflower", "futureminecraf:lilyofthevalley"}) {
            flowerModded = Block.func_149684_b((String)modFlower);
            if (flowerModded == null || block != flowerModded) continue;
            return true;
        }
        return block != Blocks.field_150327_N && block != Blocks.field_150328_O && block != Blocks.field_150434_aF && block != Blocks.field_150338_P && block != Blocks.field_150337_Q && block != Blocks.field_150345_g && block != Blocks.field_150330_I ? block == Blocks.field_150329_H && meta == 2 : true;
    }

    public static int getSignRotationMeta(int relativeOrientation, EnumFacing coordBaseMode, boolean isHangingOnWall) {
        int horizIndex = coordBaseMode.func_176736_b();
        if (isHangingOnWall) {
            switch (relativeOrientation) {
                case 0: {
                    return (new int[]{3, 4, 2, 5})[horizIndex];
                }
                case 1: {
                    return (new int[]{5, 3, 5, 3})[horizIndex];
                }
                case 2: {
                    return (new int[]{2, 5, 3, 4})[horizIndex];
                }
                case 3: {
                    return (new int[]{4, 2, 4, 2})[horizIndex];
                }
            }
        } else {
            return horizIndex <= 1 ? ((horizIndex == 1 ? 24 : 16) - (relativeOrientation + horizIndex * 4)) % 16 : (relativeOrientation + horizIndex * 4) % 16;
        }
        return 0;
    }

    public static int chooseFurnaceMeta(int orientation, EnumFacing coordBaseMode) {
        if (orientation < 0) {
            return -orientation;
        }
        return FURNACE_META_ARRAY[orientation][coordBaseMode.func_176736_b()];
    }

    public static IBlockState getHorizontalPillarState(IBlockState blockstate, int coordBaseMode, boolean isAcross) {
        return blockstate.func_177230_c().func_176203_a(blockstate.func_177230_c().func_176201_c(blockstate) % 4 + 4 + (isAcross ? 0 : 4));
    }

    private static void spawnStablehandVillager(World world, Random random, StructureComponent component, EnumFacing coordBaseMode) {
        int z;
        int y;
        int x;
        EntityVillager stablehand = new EntityVillager(world);
        stablehand.setProfession(ModProfessions.stablehand);
        StructureBoundingBox sbb = component.func_74874_b();
        int u = 2;
        int v = 2;
        int w = 5;
        if (coordBaseMode == null) {
            x = u;
            y = v;
            z = w;
        } else {
            y = u + sbb.field_78895_b;
            switch (coordBaseMode) {
                case NORTH: {
                    x = sbb.field_78897_a + u;
                    z = sbb.field_78892_f - w;
                    break;
                }
                case SOUTH: {
                    x = sbb.field_78897_a + u;
                    z = sbb.field_78896_c + w;
                    break;
                }
                case WEST: {
                    x = sbb.field_78893_d - w;
                    z = sbb.field_78896_c + u;
                    break;
                }
                case EAST: {
                    x = sbb.field_78897_a + w;
                    z = sbb.field_78896_c + u;
                    break;
                }
                default: {
                    x = u;
                    z = w;
                }
            }
        }
        stablehand.func_70012_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, random.nextFloat() * 360.0f, 0.0f);
        world.func_72838_d((Entity)stablehand);
    }

    private static TileEntitySign setChocoboSignText(TileEntitySign tes) {
        tes.field_145915_a[0] = new TextComponentString("  /~',    /,_");
        tes.field_145915_a[1] = new TextComponentString(" L  '--,/ ,.'");
        tes.field_145915_a[2] = new TextComponentString("\\_`-\"/");
        tes.field_145915_a[3] = new TextComponentString("../../");
        return tes;
    }

    public static class ChocoboStableWorld
    extends Feature {
        public boolean entitiesGenerated = false;
        public boolean disallowModSubs = false;
        public ChocoFunctions.MaterialType materialType = ChocoFunctions.MaterialType.OAK;
        public Biome biome = null;
        private int villagersSpawned;

        public ChocoboStableWorld() {
        }

        public ChocoboStableWorld(Random rand, int x, int z, BiomeProvider biomeProvider) {
            super(rand, x, 64, z, STRUCTURE_WIDTH, 12, STRUCTURE_DEPTH);
            this.materialType = ChocoFunctions.MaterialType.getMaterialTemplateForBiome(biomeProvider, x, z);
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (GeneralConfig.debugMessages) {
                LogHelper.info("World Stable generated at " + structureBB.field_78897_a + " " + structureBB.field_78892_f + " with coordBaseMode " + this.func_186165_e() + " and material type " + (Object)((Object)this.materialType));
            }
            if (!this.offsetToAverageGroundLevel(world, structureBB, -1)) {
                return false;
            }
            if (this.averageGroundLvl < 0 && this.averageGroundLvl < 0) {
                int horizIndex = this.func_186165_e().func_176736_b();
                this.averageGroundLvl = ComponentChocoboStable.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (horizIndex % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (horizIndex % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (horizIndex % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (horizIndex % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e());
                if (this.averageGroundLvl < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78895_b - 2, 0);
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 0, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = ComponentChocoboStable.unpackBiomes(GeneralConfig.stableBiomesNames);
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf(ChocoFunctions.getBiomeName(biome)));
                    this.materialType = mappedMaterialType.equals("") ? ChocoFunctions.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : ChocoFunctions.MaterialType.getMaterialTypeFromName(mappedMaterialType, ChocoFunctions.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = ChocoFunctions.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf(ChocoFunctions.getBiomeName(biome)));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < 2; ++w) {
                    this.func_74871_b(world, u, 2, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 1, w, structureBB);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)) != biomeFillerState) continue;
                    this.func_175808_b(world, biomeFillerState, u, 1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 1, w, structureBB);
                }
            }
            for (int i = 0; i < 10; ++i) {
                this.func_74878_a(world, structureBB, Math.max(-4 + i, 0), 2 + i, 2, STRUCTURE_WIDTH - 1 + Math.min(4 - i, 0), 2 + i, STRUCTURE_DEPTH - 1);
            }
            this.func_74878_a(world, structureBB, 1, 7, 2, STRUCTURE_WIDTH - 2, 7, STRUCTURE_DEPTH - 1);
            IBlockState biomeCobblestoneState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : COBBLESTONE_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeLogVertState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = ComponentChocoboStable.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : LOG_HOR_ALONG_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(4 + (this.func_186165_e().func_176736_b() % 2 != 0 ? 4 : 0)), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : LOG_HOR_ACROSS_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeBrickState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150336_V.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : BRICK_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeBrickState, biomeBrickState, false);
            }
            for (int[] uvwm : TORCH_POS) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(ComponentChocoboStable.getTorchRotationMeta(uvwm[3])), uvwm[0], 2 + uvwm[1], uvwm[2], structureBB);
            }
            IBlockState biomeStoneBrickState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : STONE_BRICK_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeStoneBrickState, biomeStoneBrickState, false);
            }
            IBlockState biomePlankState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : PLANK_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvw : GLASS_PANE_POS) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], 2 + uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwu : GLASS_PANE_OR_WALL_POS) {
                int z;
                int y;
                int x = this.func_74865_a(uvwu[3], uvwu[2]);
                BlockPos pos = new BlockPos(x, y = this.func_74862_a(uvwu[1] + 2), z = this.func_74873_b(uvwu[3], uvwu[2]));
                IBlockState outsidewindow = world.func_180495_p(pos);
                if (outsidewindow == null || world.func_175623_d(pos) || !outsidewindow.func_185914_p()) {
                    this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvwu[0], 2 + uvwu[1], uvwu[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, biomeBrickState, uvwu[4], 2 + uvwu[1], uvwu[2], structureBB);
                this.func_175811_a(world, biomePlankState, uvwu[0], 2 + uvwu[1], uvwu[2], structureBB);
            }
            IBlockState biomeFenceState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : FENCE_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeWoodStairsState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : WOOD_STAIRS_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeWoodStairsState.func_177230_c().func_176203_a(uuvvww[6] % 4 + uuvvww[6] / 4 * 4), biomeWoodStairsState.func_177230_c().func_176203_a(uuvvww[6] % 4 + uuvvww[6] / 4 * 4), false);
            }
            for (int[] uvwo : BIRCH_STAIRS_POS) {
                this.func_175811_a(world, Blocks.field_150487_bG.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], 2 + uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : WOOD_SLAB_TOP_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeStoneSlabTopState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : SMOOTH_STONE_SLAB_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeStoneSlabTopState, biomeStoneSlabTopState, false);
            }
            IBlockState biomeStoneBrickSlabTopState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(13), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : STONE_BRICK_SLAB_TOP_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeStoneBrickSlabTopState, biomeStoneBrickSlabTopState, false);
            }
            IBlockState biomeStoneBrickStairsState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150390_bg.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : STONE_BRICK_STAIRS_POS) {
                this.func_175811_a(world, biomeStoneBrickStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], 2 + uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeBrickStairsState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150389_bf.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : BRICK_STAIRS_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeBrickStairsState.func_177230_c().func_176203_a(uuvvww[6] % 4 + uuvvww[6] / 4 * 4), biomeBrickStairsState.func_177230_c().func_176203_a(uuvvww[6] % 4 + uuvvww[6] / 4 * 4), false);
            }
            IBlockState biomeBrickSlabBottomState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(4), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : BRICK_SLAB_BOTTOM_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeBrickSlabBottomState, biomeBrickSlabBottomState, false);
            }
            IBlockState biomeBrickSlabTopState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(12), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : BRICK_SLAB_TOP_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeBrickSlabTopState, biomeBrickSlabTopState, false);
            }
            for (int[] uvwm : CAULDRON_POS) {
                this.func_175811_a(world, Blocks.field_150383_bp.func_176203_a(uvwm[3]), uvwm[0], 2 + uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uuvvww : STRAW_BEDDING_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], ChocoCraftBlocks.STRAW_BEDDING.func_176223_P(), ChocoCraftBlocks.STRAW_BEDDING.func_176223_P(), false);
            }
            int u = 2;
            int v = 1;
            int w = 3;
            int x = this.func_74865_a(u, w);
            int y = this.func_74862_a(v + 2);
            int z = this.func_74873_b(u, w);
            BlockPos flowerPotPos = new BlockPos(x, y, z);
            int randomPottedPlant = random.nextInt(10) - 1;
            if (randomPottedPlant == -1) {
                ComponentChocoboStable.generateStructureFlowerPot(world, structureBB, random, flowerPotPos, (Block)Blocks.field_150327_N, 0);
            } else {
                ComponentChocoboStable.generateStructureFlowerPot(world, structureBB, random, flowerPotPos, (Block)Blocks.field_150328_O, randomPottedPlant);
            }
            u = 9;
            v = 1;
            w = 3;
            x = this.func_74865_a(u, w);
            y = this.func_74862_a(v + 2);
            z = this.func_74873_b(u, w);
            flowerPotPos = new BlockPos(x, y, z);
            ComponentChocoboStable.generateStructureFlowerPot(world, structureBB, random, flowerPotPos, Blocks.field_150345_g, random.nextInt(6));
            IBlockState biomeFenceGateState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwos : FENCE_GATE_POS) {
                this.func_175811_a(world, biomeFenceGateState.func_177230_c().func_176203_a(ComponentChocoboStable.chooseFenceGateMeta(uvwos[3], uvwos[4] == 1)), uvwos[0], uvwos[1] + 2, uvwos[2], structureBB);
            }
            IBlockState biomeWoodDoorState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : WOOD_DOOR_POS) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(ComponentChocoboStable.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height + 2, uvwoor[2], structureBB);
                }
            }
            int signU = 4;
            int signV = 3;
            int signW = 1;
            int signX = this.func_74865_a(signU, signW);
            int signY = this.func_74862_a(signV);
            int signZ = this.func_74873_b(signU, signW);
            ComponentChocoboStable.makeChocoboSign(world, new BlockPos(signX, signY, signZ), this.func_186165_e(), this.materialType, this.biome, this.disallowModSubs);
            Random randomFromXYZ = new Random();
            randomFromXYZ.setSeed(world.func_72905_C() + ChocoFunctions.getUniqueLongForXYZ(this.func_74865_a(0, 0), this.func_74862_a(0), this.func_74873_b(0, 0)));
            if (randomFromXYZ.nextFloat() < GeneralConfig.villageStableChestChance) {
                int chestPos = randomFromXYZ.nextInt(3);
                int chestU = 2;
                int chestV = 1;
                int chestW = 4 + chestPos;
                int chestO = chestPos;
                IBlockState biomeChestState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150486_ae.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
                this.func_175811_a(world, biomeChestState.func_177230_c().func_176203_a(ComponentChocoboStable.chooseFurnaceMeta(chestO, this.func_186165_e())), chestU, chestV, chestW, structureBB);
                TileEntity te = world.func_175625_s(new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW)));
                if (te instanceof IInventory) {
                    ChestGenHooks chestGenHook = ChestGenHooks.getInfo("stable_chest");
                    WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
                }
                for (int i = 1; i <= 2; ++i) {
                    this.func_175811_a(world, biomeCobblestoneState, chestU, chestV, 4 + (chestPos + i) % 3, structureBB);
                }
            } else {
                for (int[] uuvvww : new int[][]{{2, -1, 4, 2, -1, 6}}) {
                    this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1] + 2, uuvvww[2], uuvvww[3], uuvvww[4] + 2, uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
                }
            }
            int carpetColor = (Integer)ChocoFunctions.weightedRandom(COLOR_METAS, COLOR_WEIGHTS, randomFromXYZ);
            for (int[] uuvvww : new int[][]{{2, 0, 4, 2, 0, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1] + 2, uuvvww[2], uuvvww[3], uuvvww[4] + 2, uuvvww[5], Blocks.field_150404_cg.func_176203_a(carpetColor), Blocks.field_150404_cg.func_176203_a(carpetColor), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                ComponentChocoboStable.spawnStablehandVillager(world, random, this, this.func_186165_e());
                int xPos = 3 + random.nextInt(6);
                int yPos = 2;
                int zPos = 9 + random.nextInt(3);
                int xOffset = this.func_74865_a(xPos, zPos);
                int yOffset = this.func_74862_a(yPos);
                int zOffset = this.func_74873_b(xPos, zPos);
                EntityChocobo stableChocobo = FactoryEntityChocobo.createStableChocobo(world, random);
                stableChocobo.func_70012_b((double)xOffset + 0.5, yOffset, (double)zOffset + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)stableChocobo);
            }
            ComponentChocoboStable.cleanEntityItems(world, this.field_74887_e);
            return true;
        }
    }

    static abstract class Feature
    extends StructureComponent {
        protected int scatteredFeatureSizeX;
        protected int scatteredFeatureSizeY;
        protected int scatteredFeatureSizeZ;
        protected int averageGroundLvl = -1;
        int downwardShift = 3;

        public Feature() {
        }

        protected Feature(Random rand, int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
            super(0);
            this.scatteredFeatureSizeX = sizeX;
            this.scatteredFeatureSizeY = sizeY;
            this.scatteredFeatureSizeZ = sizeZ;
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
            switch (this.func_186165_e().func_176736_b()) {
                case 0: 
                case 2: {
                    this.field_74887_e = new StructureBoundingBox(x, y + this.downwardShift, z, x + sizeX - 3, y + sizeY - 1 + this.downwardShift, z + sizeZ - 3);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(x, y + this.downwardShift, z, x + sizeZ - 3, y + sizeY - 1 + this.downwardShift, z + sizeX - 3);
                }
            }
        }

        protected void func_143012_a(NBTTagCompound tagCompound) {
            tagCompound.func_74768_a("Width", this.scatteredFeatureSizeX);
            tagCompound.func_74768_a("Height", this.scatteredFeatureSizeY);
            tagCompound.func_74768_a("Depth", this.scatteredFeatureSizeZ);
            tagCompound.func_74768_a("HPos", this.averageGroundLvl);
            tagCompound.func_74757_a(ComponentChocoboStable.CHOCOBO_NBT_TAG, true);
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager templatemanager) {
            this.scatteredFeatureSizeX = tagCompound.func_74762_e("Width");
            this.scatteredFeatureSizeY = tagCompound.func_74762_e("Height");
            this.scatteredFeatureSizeZ = tagCompound.func_74762_e("Depth");
            this.averageGroundLvl = tagCompound.func_74762_e("HPos");
        }

        protected boolean offsetToAverageGroundLevel(World worldIn, StructureBoundingBox structurebb, int yOffset) {
            if (this.averageGroundLvl >= 0) {
                return true;
            }
            this.averageGroundLvl = ComponentChocoboStable.getMedianGroundLevel(worldIn, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)1, this.func_186165_e());
            if (this.averageGroundLvl < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLvl - this.field_74887_e.field_78895_b - 2, 0);
            return true;
        }
    }

    public static class ChocoboStableVillage
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public ChocoFunctions.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public Biome biome = null;
        protected int field_143015_k = -1;

        public ChocoboStableVillage() {
        }

        public ChocoboStableVillage(StructureVillagePieces.Start start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing facing) {
            this.func_186164_a(facing);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.biome = start.biome;
            }
        }

        public static ChocoboStableVillage buildComponent(StructureVillagePieces.Start villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)12, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return ChocoboStableVillage.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new ChocoboStableVillage(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74757_a(ComponentChocoboStable.CHOCOBO_NBT_TAG, true);
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.field_143015_k < 0 && this.field_143015_k < 0) {
                int horizIndex = this.func_186165_e().func_176736_b();
                this.field_143015_k = ComponentChocoboStable.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (horizIndex % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (horizIndex % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (horizIndex % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (horizIndex % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 2, 0);
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 0, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = ComponentChocoboStable.unpackBiomes(GeneralConfig.stableBiomesNames);
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf(ChocoFunctions.getBiomeName(biome)));
                    this.materialType = mappedMaterialType.equals("") ? ChocoFunctions.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : ChocoFunctions.MaterialType.getMaterialTypeFromName(mappedMaterialType, ChocoFunctions.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = ChocoFunctions.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf(ChocoFunctions.getBiomeName(biome)));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < 2; ++w) {
                    this.func_74871_b(world, u, 2, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 1, w, structureBB);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)) != biomeFillerState) continue;
                    this.func_175808_b(world, biomeFillerState, u, 1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 1, w, structureBB);
                }
            }
            for (int i = 0; i < 10; ++i) {
                this.func_74878_a(world, structureBB, Math.max(-4 + i, 0), 2 + i, 2, STRUCTURE_WIDTH - 1 + Math.min(4 - i, 0), 2 + i, STRUCTURE_DEPTH - 1);
            }
            this.func_74878_a(world, structureBB, 1, 7, 2, STRUCTURE_WIDTH - 2, 7, STRUCTURE_DEPTH - 1);
            IBlockState biomeCobblestoneState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : COBBLESTONE_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeLogVertState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = ComponentChocoboStable.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : LOG_HOR_ALONG_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = ComponentChocoboStable.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : LOG_HOR_ACROSS_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeBrickState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150336_V.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : BRICK_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeBrickState, biomeBrickState, false);
            }
            for (int[] uvwm : TORCH_POS) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(ComponentChocoboStable.getTorchRotationMeta(uvwm[3])), uvwm[0], 2 + uvwm[1], uvwm[2], structureBB);
            }
            IBlockState biomeStoneBrickState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150417_aV.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : STONE_BRICK_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeStoneBrickState, biomeStoneBrickState, false);
            }
            IBlockState biomePlankState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : PLANK_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvw : GLASS_PANE_POS) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvw[0], 2 + uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwu : GLASS_PANE_OR_WALL_POS) {
                int z;
                int y;
                int x = this.func_74865_a(uvwu[3], uvwu[2]);
                BlockPos pos = new BlockPos(x, y = this.func_74862_a(uvwu[1] + 2), z = this.func_74873_b(uvwu[3], uvwu[2]));
                IBlockState outsidewindow = world.func_180495_p(pos);
                if (outsidewindow == null || world.func_175623_d(pos) || !outsidewindow.func_185914_p()) {
                    this.func_175811_a(world, Blocks.field_150410_aZ.func_176223_P(), uvwu[0], 2 + uvwu[1], uvwu[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, biomeBrickState, uvwu[4], 2 + uvwu[1], uvwu[2], structureBB);
                this.func_175811_a(world, biomePlankState, uvwu[0], 2 + uvwu[1], uvwu[2], structureBB);
            }
            IBlockState biomeFenceState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : FENCE_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeWoodStairsState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : WOOD_STAIRS_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeWoodStairsState.func_177230_c().func_176203_a(uuvvww[6] % 4 + uuvvww[6] / 4 * 4), biomeWoodStairsState.func_177230_c().func_176203_a(uuvvww[6] % 4 + uuvvww[6] / 4 * 4), false);
            }
            for (int[] uvwo : BIRCH_STAIRS_POS) {
                this.func_175811_a(world, Blocks.field_150487_bG.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], 2 + uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodSlabTopState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : WOOD_SLAB_TOP_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            IBlockState biomeStoneSlabTopState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : SMOOTH_STONE_SLAB_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeStoneSlabTopState, biomeStoneSlabTopState, false);
            }
            IBlockState biomeStoneBrickSlabTopState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(13), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : STONE_BRICK_SLAB_TOP_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeStoneBrickSlabTopState, biomeStoneBrickSlabTopState, false);
            }
            IBlockState biomeStoneBrickStairsState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150390_bg.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : STONE_BRICK_STAIRS_POS) {
                this.func_175811_a(world, biomeStoneBrickStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], 2 + uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeBrickStairsState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150389_bf.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : BRICK_STAIRS_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeBrickStairsState.func_177230_c().func_176203_a(uuvvww[6] % 4 + uuvvww[6] / 4 * 4), biomeBrickStairsState.func_177230_c().func_176203_a(uuvvww[6] % 4 + uuvvww[6] / 4 * 4), false);
            }
            IBlockState biomeBrickSlabBottomState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(4), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : BRICK_SLAB_BOTTOM_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeBrickSlabBottomState, biomeBrickSlabBottomState, false);
            }
            IBlockState biomeBrickSlabTopState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(12), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : BRICK_SLAB_TOP_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], biomeBrickSlabTopState, biomeBrickSlabTopState, false);
            }
            for (int[] uvwm : CAULDRON_POS) {
                this.func_175811_a(world, Blocks.field_150383_bp.func_176203_a(uvwm[3]), uvwm[0], 2 + uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uuvvww : STRAW_BEDDING_POS) {
                this.func_175804_a(world, structureBB, uuvvww[0], 2 + uuvvww[1], uuvvww[2], uuvvww[3], 2 + uuvvww[4], uuvvww[5], ChocoCraftBlocks.STRAW_BEDDING.func_176223_P(), ChocoCraftBlocks.STRAW_BEDDING.func_176223_P(), false);
            }
            int u = 2;
            int v = 1;
            int w = 3;
            int x = this.func_74865_a(u, w);
            int y = this.func_74862_a(v + 2);
            int z = this.func_74873_b(u, w);
            BlockPos flowerPotPos = new BlockPos(x, y, z);
            int randomPottedPlant = random.nextInt(10) - 1;
            if (randomPottedPlant == -1) {
                ComponentChocoboStable.generateStructureFlowerPot(world, structureBB, random, flowerPotPos, (Block)Blocks.field_150327_N, 0);
            } else {
                ComponentChocoboStable.generateStructureFlowerPot(world, structureBB, random, flowerPotPos, (Block)Blocks.field_150328_O, randomPottedPlant);
            }
            u = 9;
            v = 1;
            w = 3;
            x = this.func_74865_a(u, w);
            y = this.func_74862_a(v + 2);
            z = this.func_74873_b(u, w);
            flowerPotPos = new BlockPos(x, y, z);
            ComponentChocoboStable.generateStructureFlowerPot(world, structureBB, random, flowerPotPos, Blocks.field_150345_g, random.nextInt(6));
            IBlockState biomeFenceGateState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwos : FENCE_GATE_POS) {
                this.func_175811_a(world, biomeFenceGateState.func_177230_c().func_176203_a(ComponentChocoboStable.chooseFenceGateMeta(uvwos[3], uvwos[4] == 1)), uvwos[0], uvwos[1] + 2, uvwos[2], structureBB);
            }
            IBlockState biomeWoodDoorState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : WOOD_DOOR_POS) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(ComponentChocoboStable.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height + 2, uvwoor[2], structureBB);
                }
            }
            int signU = 4;
            int signV = 3;
            int signW = 1;
            int signX = this.func_74865_a(signU, signW);
            int signY = this.func_74862_a(signV);
            int signZ = this.func_74873_b(signU, signW);
            ComponentChocoboStable.makeChocoboSign(world, new BlockPos(signX, signY, signZ), this.func_186165_e(), this.materialType, this.biome, this.disallowModSubs);
            Random randomFromXYZ = new Random();
            randomFromXYZ.setSeed(world.func_72905_C() + ChocoFunctions.getUniqueLongForXYZ(this.func_74865_a(0, 0), this.func_74862_a(0), this.func_74873_b(0, 0)));
            if (randomFromXYZ.nextFloat() < GeneralConfig.villageStableChestChance) {
                int chestPos = randomFromXYZ.nextInt(3);
                int chestU = 2;
                int chestV = 1;
                int chestW = 4 + chestPos;
                int chestO = chestPos;
                IBlockState biomeChestState = ComponentChocoboStable.getBiomeSpecificBlockState(Blocks.field_150486_ae.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
                this.func_175811_a(world, biomeChestState.func_177230_c().func_176203_a(ComponentChocoboStable.chooseFurnaceMeta(chestO, this.func_186165_e())), chestU, chestV, chestW, structureBB);
                TileEntity te = world.func_175625_s(new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW)));
                if (te instanceof IInventory) {
                    ChestGenHooks chestGenHook = ChestGenHooks.getInfo("stable_chest");
                    WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
                }
                for (int i = 1; i <= 2; ++i) {
                    this.func_175811_a(world, biomeCobblestoneState, chestU, chestV, 4 + (chestPos + i) % 3, structureBB);
                }
            } else {
                for (int[] uuvvww : new int[][]{{2, -1, 4, 2, -1, 6}}) {
                    this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1] + 2, uuvvww[2], uuvvww[3], uuvvww[4] + 2, uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
                }
            }
            int carpetColor = (Integer)ChocoFunctions.weightedRandom(COLOR_METAS, COLOR_WEIGHTS, randomFromXYZ);
            for (int[] uuvvww : new int[][]{{2, 0, 4, 2, 0, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1] + 2, uuvvww[2], uuvvww[3], uuvvww[4] + 2, uuvvww[5], Blocks.field_150404_cg.func_176203_a(carpetColor), Blocks.field_150404_cg.func_176203_a(carpetColor), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                ComponentChocoboStable.spawnStablehandVillager(world, random, (StructureComponent)this, this.func_186165_e());
                int xPos = 3 + random.nextInt(6);
                int yPos = 2;
                int zPos = 9 + random.nextInt(3);
                int xOffset = this.func_74865_a(xPos, zPos);
                int yOffset = this.func_74862_a(yPos);
                int zOffset = this.func_74873_b(xPos, zPos);
                EntityChocobo stableChocobo = FactoryEntityChocobo.createStableChocobo(world, random);
                stableChocobo.func_70012_b((double)xOffset + 0.5, yOffset, (double)zOffset + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)stableChocobo);
            }
            ComponentChocoboStable.cleanEntityItems(world, this.field_74887_e);
            return true;
        }
    }
}

