/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.registry;

import chococraftplus.common.ModChocoCraft;
import chococraftplus.common.blocks.BlockGysahlCrop;
import chococraftplus.common.blocks.BlockGysahlGarden;
import chococraftplus.common.blocks.BlockStraw;
import chococraftplus.common.registry.ChocoCraftCreativeTabs;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ChocoCraftBlocks {
    public static final Block GYSAHL_GARDEN = new BlockGysahlCrop();
    public static final BlockBush WILD_GYSAHL_GARDEN = new BlockGysahlGarden();
    public static final Block STRAW_BEDDING = new BlockStraw();

    public static void registerBlocks() {
        ChocoCraftBlocks.registerBlock(GYSAHL_GARDEN, "gysahlstemblock", null);
        ChocoCraftBlocks.registerBlock((Block)WILD_GYSAHL_GARDEN, "gysahlgardenblock", ChocoCraftCreativeTabs.tabChococraft);
        ChocoCraftBlocks.registerBlock(STRAW_BEDDING, "strawblock", ChocoCraftCreativeTabs.tabChococraft);
    }

    public static void registerBlock(Block block, String name, CreativeTabs creativeTab) {
        block.func_149663_c("chococraftplus".toLowerCase() + ":" + name);
        block.func_149647_a(creativeTab);
        ChocoCraftBlocks.registerBlockWithItem(block, name, ItemBlock.class);
        ChocoCraftBlocks.registerBlockItemModel(block, name, 0);
    }

    private static void registerBlockWithItem(Block block, String blockName, Class<? extends ItemBlock> clazz) {
        try {
            Item itemBlock = clazz != null ? (Item)clazz.getConstructor(Block.class).newInstance(block) : null;
            ResourceLocation location = new ResourceLocation("chococraftplus", blockName);
            block.setRegistryName(new ResourceLocation("chococraftplus", blockName));
            ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
            if (itemBlock != null) {
                itemBlock.setRegistryName(new ResourceLocation("chococraftplus", blockName));
                ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("An error occurred associating an item block during registration of " + blockName, e);
        }
    }

    public static void registerBlockItemModel(Block block, String stateName, int stateMeta) {
        Item item = Item.func_150898_a((Block)block);
        ModChocoCraft.PROXY.registerItemVariantModel(item, stateName, stateMeta);
    }
}

