/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.network.serverSide;

import chococraftplus.common.entities.EntityAnimalChocobo;
import chococraftplus.common.entities.EntityChocoboRideable;
import chococraftplus.common.network.PacketHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ChocoboMount
implements IMessage {
    public int entityID;
    public String playerUUID;
    public int dimensionId;

    public ChocoboMount() {
    }

    public ChocoboMount(EntityChocoboRideable chocobo) {
        this.entityID = chocobo.func_145782_y();
        this.playerUUID = FMLClientHandler.instance().getClient().field_71439_g.func_110124_au().toString();
        this.dimensionId = chocobo.field_70170_p.field_73011_w.getDimension();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.entityID);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.playerUUID);
        buffer.writeInt(this.dimensionId);
    }

    public void fromBytes(ByteBuf buffer) {
        this.entityID = buffer.readInt();
        this.playerUUID = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.dimensionId = buffer.readInt();
    }

    public static class Handler
    implements IMessageHandler<ChocoboMount, IMessage> {
        public IMessage onMessage(ChocoboMount message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(ChocoboMount message, MessageContext ctx) {
            EntityAnimalChocobo chocobo = PacketHelper.getChocoboByID(message.entityID, message.dimensionId);
            if (chocobo != null && chocobo instanceof EntityChocoboRideable) {
                EntityChocoboRideable chocoboRideable = (EntityChocoboRideable)chocobo;
                if (message.playerUUID.isEmpty()) {
                    chocoboRideable.func_184210_p();
                    chocoboRideable.func_70637_d(false);
                    chocoboRideable.setStepHeight(false);
                    chocoboRideable.setJumpHigh(false);
                } else {
                    EntityPlayer rider = PacketHelper.getPlayer(message.playerUUID, message.dimensionId);
                    rider.func_70031_b(false);
                    rider.func_184220_m((Entity)chocoboRideable);
                    chocoboRideable.setStepHeight(true);
                    chocoboRideable.setJumpHigh(true);
                }
            }
        }
    }
}

