/*
 * Decompiled with CFR 0.152.
 */
package chococraftplus.common.network.serverSide;

import chococraftplus.common.entities.EntityAnimalChocobo;
import chococraftplus.common.entities.EntityChocoboRideable;
import chococraftplus.common.network.PacketHelper;
import chococraftplus.common.registry.ChocoCraftItems;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ChocoboDropGear
implements IMessage {
    public int entityID;
    public int dimensionId;

    public ChocoboDropGear() {
    }

    public ChocoboDropGear(EntityChocoboRideable chicobo) {
        this.entityID = chicobo.func_145782_y();
        this.dimensionId = chicobo.field_70170_p.field_73011_w.getDimension();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.entityID);
        buffer.writeInt(this.dimensionId);
    }

    public void fromBytes(ByteBuf buffer) {
        this.entityID = buffer.readInt();
        this.dimensionId = buffer.readInt();
    }

    public static class Handler
    implements IMessageHandler<ChocoboDropGear, IMessage> {
        public IMessage onMessage(ChocoboDropGear message, MessageContext ctx) {
            EntityAnimalChocobo chocobo = PacketHelper.getChocoboByID(message.entityID, message.dimensionId);
            if (chocobo != null && chocobo instanceof EntityChocoboRideable) {
                EntityChocoboRideable chocoRideable = (EntityChocoboRideable)chocobo;
                if (chocoRideable.isSaddleBagged().booleanValue()) {
                    chocoRideable.func_70099_a(new ItemStack(ChocoCraftItems.CHOCOBO_SADDLE_BAGS, 1), 0.0f);
                    chocoRideable.getChocoBagInventory().dropAllItems();
                    chocoRideable.setSaddleBagged(false);
                }
                if (chocoRideable.isSaddled()) {
                    chocoRideable.func_70099_a(new ItemStack(ChocoCraftItems.CHOCOBO_SADDLE, 1), 0.0f);
                    chocoRideable.setSaddled(false);
                }
                if (chocoRideable.isPackBagged().booleanValue()) {
                    chocoRideable.func_70099_a(new ItemStack(ChocoCraftItems.CHOCOBO_PACK_BAGS, 1), 0.0f);
                    chocoRideable.getChocoBagInventory().dropAllItems();
                    chocoRideable.setPackBagged(false);
                }
            }
            return null;
        }
    }
}

